/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.ref.WeakReference;
import org.h2.engine.Database;

public class DatabaseCloser
extends Thread {
    private final boolean shutdownHook;
    private volatile WeakReference databaseRef;
    private int delayInMillis;
    private boolean stopImmediately;

    DatabaseCloser(Database database, int n, boolean bl) {
        this.databaseRef = new WeakReference<Database>(database);
        this.delayInMillis = n;
        this.shutdownHook = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DatabaseCloser databaseCloser = this;
        synchronized (databaseCloser) {
            this.databaseRef = null;
        }
        if (this.getThreadGroup().activeCount() > 100) {
            this.stopImmediately = true;
            try {
                this.start();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.stopImmediately) {
            return;
        }
        while (this.delayInMillis > 0) {
            try {
                int n = 100;
                Thread.sleep(n);
                this.delayInMillis -= n;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.databaseRef != null) continue;
            return;
        }
        Database database = null;
        DatabaseCloser databaseCloser = this;
        synchronized (databaseCloser) {
            if (this.databaseRef != null) {
                database = (Database)this.databaseRef.get();
            }
        }
        if (database != null) {
            database.close(this.shutdownHook);
        }
    }
}

