/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.dml.BackupCommand;
import org.h2.message.Message;
import org.h2.store.FileLister;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.Tool;

public class Backup
extends Tool {
    private void showUsage() {
        this.out.println("Creates a backup of a database.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-file <filename>]  The target file name (default: backup.zip)\n" + " [-dir <dir>]        Source directory (default: .)\n" + " [-db <database>]    Source database name\n" + " [-quiet]            Do not print progress information");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] args) throws SQLException {
        new Backup().run(args);
    }

    public void run(String[] args) throws SQLException {
        String zipFileName = "backup.zip";
        String dir = ".";
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (arg.equals("-db")) {
                db = args[++i];
                continue;
            }
            if (arg.equals("-quiet")) {
                quiet = true;
                continue;
            }
            if (arg.equals("-file")) {
                zipFileName = args[++i];
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + arg);
            this.showUsage();
            return;
        }
        this.process(zipFileName, dir, db, quiet);
    }

    public static void execute(String zipFileName, String directory, String db, boolean quiet) throws SQLException {
        new Backup().process(zipFileName, directory, db, quiet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String zipFileName, String directory, String db, boolean quiet) throws SQLException {
        ArrayList list = FileLister.getDatabaseFiles(directory, db, true);
        if (list.size() == 0) {
            if (!quiet) {
                this.out.println("No database files found");
            }
            return;
        }
        if (FileUtils.exists(zipFileName = FileUtils.normalize(zipFileName))) {
            FileUtils.delete(zipFileName);
        }
        OutputStream fileOut = null;
        try {
            String fileName;
            int i;
            fileOut = FileUtils.openFileOutputStream(zipFileName, false);
            ZipOutputStream zipOut = new ZipOutputStream(fileOut);
            String base = "";
            for (i = 0; i < list.size(); ++i) {
                fileName = (String)list.get(i);
                if (!fileName.endsWith(".data.db")) continue;
                base = FileUtils.getParent(fileName);
            }
            for (i = 0; i < list.size(); ++i) {
                fileName = (String)list.get(i);
                String f = FileUtils.getAbsolutePath(fileName);
                if (!f.startsWith(base)) {
                    throw Message.getInternalError(f + " does not start with " + base);
                }
                f = f.substring(base.length());
                f = BackupCommand.correctFileName(f);
                ZipEntry entry = new ZipEntry(f);
                zipOut.putNextEntry(entry);
                InputStream in = null;
                try {
                    in = FileUtils.openFileInputStream(fileName);
                    IOUtils.copyAndCloseInput(in, zipOut);
                }
                catch (FileNotFoundException e) {
                }
                finally {
                    IOUtils.closeSilently(in);
                }
                zipOut.closeEntry();
                if (quiet) continue;
                this.out.println("Processed: " + fileName);
            }
            zipOut.closeEntry();
            zipOut.close();
        }
        catch (IOException e) {
            throw Message.convertIOException(e, zipFileName);
        }
        finally {
            IOUtils.closeSilently(fileOut);
        }
    }
}

