/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import org.h2.constant.SysProperties;
import org.h2.message.TraceSystem;
import org.h2.util.StringUtils;

public class Trace {
    private TraceSystem traceSystem;
    private String module;
    private String lineSeparator;
    public static final String LOCK = "lock";
    public static final String SETTING = "setting";
    public static final String COMMAND = "command";
    public static final String INDEX = "index";
    public static final String SEQUENCE = "sequence";
    public static final String CONSTRAINT = "constraint";
    public static final String USER = "user";
    public static final String TRIGGER = "trigger";
    public static final String FUNCTION = "function";
    public static final String JDBC = "jdbc";
    public static final String FILE_LOCK = "fileLock";
    public static final String TABLE = "table";
    public static final String LOG = "log";
    public static final String SCHEMA = "schema";
    public static final String DATABASE = "database";
    public static final String SESSION = "session";
    public static final String AGGREGATE = "aggregate";

    public Trace(TraceSystem traceSystem, String module) {
        this.traceSystem = traceSystem;
        this.module = module;
        this.lineSeparator = SysProperties.LINE_SEPARATOR;
    }

    public boolean info() {
        return this.traceSystem.isEnabled(2);
    }

    public boolean debug() {
        return this.traceSystem.isEnabled(3);
    }

    public void error(String s) {
        this.traceSystem.write(1, this.module, s, null);
    }

    public void error(String s, Throwable t) {
        this.traceSystem.write(1, this.module, s, t);
    }

    public void info(String s) {
        this.traceSystem.write(2, this.module, s, null);
    }

    public void debugCode(String java) {
        this.traceSystem.write(3, this.module, this.lineSeparator + "/**/" + java, null);
    }

    public void infoCode(String java) {
        this.traceSystem.write(2, this.module, this.lineSeparator + "/**/" + java, null);
    }

    public void infoSQL(String sql) {
        sql = StringUtils.javaEncode(sql);
        this.traceSystem.write(2, this.module, this.lineSeparator + "/*SQL*/" + sql, null);
    }

    public void debug(String s) {
        this.traceSystem.write(3, this.module, s, null);
    }

    public void debug(String s, Throwable t) {
        this.traceSystem.write(3, this.module, s, t);
    }
}

