/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.table.TableView;

public class CreateView
extends SchemaCommand {
    private Query select;
    private String viewName;
    private boolean ifNotExists;
    private String selectSQL;
    private String[] columnNames;
    private String comment;
    private boolean recursive;

    public CreateView(Session session, Schema schema) {
        super(session, schema);
    }

    public void setViewName(String name) {
        this.viewName = name;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setSelect(Query select) {
        this.select = select;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (this.getSchema().findTableOrView(this.session, this.viewName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90038, this.viewName);
        }
        int id = this.getObjectId(true, true);
        String querySQL = this.select == null ? this.selectSQL : this.select.getSQL();
        Session sysSession = db.getSystemSession();
        TableView view = new TableView(this.getSchema(), id, this.viewName, querySQL, null, this.columnNames, sysSession, this.recursive);
        view.setComment(this.comment);
        db.addSchemaObject(this.session, view);
        return 0;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setSelectSQL(String selectSQL) {
        this.selectSQL = selectSQL;
    }

    public void setColumnNames(String[] cols) {
        this.columnNames = cols;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

