/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectDisk;
import org.h2.store.fs.FileSystem;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

public class FileSystemDisk
extends FileSystem {
    private static final FileSystemDisk INSTANCE = new FileSystemDisk();
    private static final boolean IS_FILE_SYSTEM_CASE_INSENSITIVE = File.separatorChar == '\\';

    public static FileSystemDisk getInstance() {
        return INSTANCE;
    }

    protected FileSystemDisk() {
    }

    public long length(String fileName) {
        fileName = this.translateFileName(fileName);
        return new File(fileName).length();
    }

    private String translateFileName(String fileName) {
        if (fileName != null && fileName.startsWith("~")) {
            String userDir = SysProperties.USER_HOME;
            fileName = userDir + fileName.substring(1);
        }
        return fileName;
    }

    public void rename(String oldName, String newName) throws SQLException {
        File oldFile = new File(oldName);
        File newFile = new File(newName);
        if (oldFile.getAbsolutePath().equals(newFile.getAbsolutePath())) {
            throw Message.getInternalError("rename file old=new");
        }
        if (!oldFile.exists()) {
            throw Message.getSQLException(90024, new String[]{oldName + " (not found)", newName});
        }
        if (newFile.exists()) {
            throw Message.getSQLException(90024, new String[]{oldName, newName + " (exists)"});
        }
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            this.trace("rename", oldName + " >" + newName, null);
            boolean ok = oldFile.renameTo(newFile);
            if (ok) {
                return;
            }
            FileSystemDisk.wait(i);
        }
        throw Message.getSQLException(90024, new String[]{oldName, newName});
    }

    void trace(String method, String fileName, Object o) {
        if (SysProperties.TRACE_IO) {
            System.out.println("FileSystem." + method + " " + fileName + " " + o);
        }
    }

    private static void wait(int i) {
        if (i > 8) {
            System.gc();
        }
        try {
            long sleep = Math.min(256, i * i);
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean createNewFile(String fileName) throws SQLException {
        fileName = this.translateFileName(fileName);
        File file = new File(fileName);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                FileSystemDisk.wait(i);
                continue;
            }
        }
        return false;
    }

    public boolean exists(String fileName) {
        fileName = this.translateFileName(fileName);
        return new File(fileName).exists();
    }

    public void delete(String fileName) throws SQLException {
        File file = new File(fileName = this.translateFileName(fileName));
        if (file.exists()) {
            for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
                this.trace("delete", fileName, null);
                boolean ok = file.delete();
                if (ok) {
                    return;
                }
                FileSystemDisk.wait(i);
            }
            throw Message.getSQLException(90025, fileName);
        }
    }

    public boolean tryDelete(String fileName) {
        fileName = this.translateFileName(fileName);
        this.trace("tryDelete", fileName, null);
        return new File(fileName).delete();
    }

    public String createTempFile(String name, String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException {
        File dir;
        name = this.translateFileName(name);
        name = name + ".";
        String prefix = new File(name).getName();
        if (inTempDir) {
            dir = null;
        } else {
            dir = new File(name).getAbsoluteFile().getParentFile();
            dir.mkdirs();
        }
        File f = File.createTempFile(prefix, suffix, dir);
        if (deleteOnExit) {
            try {
                f.deleteOnExit();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return f.getCanonicalPath();
    }

    public String[] listFiles(String path) throws SQLException {
        path = this.translateFileName(path);
        File f = new File(path);
        try {
            String[] list = f.list();
            if (list == null) {
                return new String[0];
            }
            String base = f.getCanonicalPath();
            if (!base.endsWith(File.separator)) {
                base = base + File.separator;
            }
            for (int i = 0; i < list.length; ++i) {
                list[i] = base + list[i];
            }
            return list;
        }
        catch (IOException e) {
            throw Message.convertIOException(e, path);
        }
    }

    public void deleteRecursive(String fileName) throws SQLException {
        if (FileUtils.isDirectory(fileName = this.translateFileName(fileName))) {
            String[] list = this.listFiles(fileName);
            for (int i = 0; list != null && i < list.length; ++i) {
                this.deleteRecursive(list[i]);
            }
        }
        this.delete(fileName);
    }

    public boolean isReadOnly(String fileName) {
        File f = new File(fileName = this.translateFileName(fileName));
        return f.exists() && !f.canWrite();
    }

    public String normalize(String fileName) throws SQLException {
        fileName = this.translateFileName(fileName);
        File f = new File(fileName);
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            throw Message.convertIOException(e, fileName);
        }
    }

    public String getParent(String fileName) {
        fileName = this.translateFileName(fileName);
        return new File(fileName).getParent();
    }

    public boolean isDirectory(String fileName) {
        fileName = this.translateFileName(fileName);
        return new File(fileName).isDirectory();
    }

    public boolean isAbsolute(String fileName) {
        fileName = this.translateFileName(fileName);
        File file = new File(fileName);
        return file.isAbsolute();
    }

    public String getAbsolutePath(String fileName) {
        fileName = this.translateFileName(fileName);
        File parent = new File(fileName).getAbsoluteFile();
        return parent.getAbsolutePath();
    }

    public long getLastModified(String fileName) {
        fileName = this.translateFileName(fileName);
        return new File(fileName).lastModified();
    }

    public boolean canWrite(String fileName) {
        fileName = this.translateFileName(fileName);
        return new File(fileName).canWrite();
    }

    public void copy(String original, String copy) throws SQLException {
        original = this.translateFileName(original);
        copy = this.translateFileName(copy);
        OutputStream out = null;
        InputStream in = null;
        try {
            int len;
            out = FileUtils.openFileOutputStream(copy, false);
            in = FileUtils.openFileInputStream(original);
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            out.close();
        }
        catch (IOException e) {
            try {
                throw Message.convertIOException(e, "original: " + original + " copy: " + copy);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(in);
                IOUtils.closeSilently(out);
                throw throwable;
            }
        }
        IOUtils.closeSilently(in);
        IOUtils.closeSilently(out);
    }

    public void createDirs(String fileName) throws SQLException {
        File f = new File(fileName = this.translateFileName(fileName));
        if (!f.exists()) {
            String parent = f.getParent();
            if (parent == null) {
                return;
            }
            File dir = new File(parent);
            for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
                if (dir.exists() || dir.mkdirs()) {
                    return;
                }
                FileSystemDisk.wait(i);
            }
            throw Message.getSQLException(90062, parent);
        }
    }

    public String getFileName(String name) throws SQLException {
        String fullFileName;
        name = this.translateFileName(name);
        String separator = SysProperties.FILE_SEPARATOR;
        String path = this.getParent(name);
        if (!path.endsWith(separator)) {
            path = path + separator;
        }
        if (!(fullFileName = this.normalize(name)).startsWith(path)) {
            throw Message.getInternalError("file utils error: " + fullFileName + " does not start with " + path);
        }
        String fileName = fullFileName.substring(path.length());
        return fileName;
    }

    public boolean fileStartsWith(String fileName, String prefix) {
        fileName = this.translateFileName(fileName);
        if (IS_FILE_SYSTEM_CASE_INSENSITIVE) {
            fileName = StringUtils.toUpperEnglish(fileName);
            prefix = StringUtils.toUpperEnglish(prefix);
        }
        return fileName.startsWith(prefix);
    }

    public OutputStream openFileOutputStream(String fileName, boolean append) throws SQLException {
        fileName = this.translateFileName(fileName);
        try {
            File file = new File(fileName);
            this.createDirs(file.getAbsolutePath());
            FileOutputStream out = new FileOutputStream(fileName, append);
            this.trace("openFileOutputStream", fileName, out);
            return out;
        }
        catch (IOException e) {
            this.freeMemoryAndFinalize();
            try {
                return new FileOutputStream(fileName);
            }
            catch (IOException e2) {
                throw Message.convertIOException(e, fileName);
            }
        }
    }

    public InputStream openFileInputStream(String fileName) throws IOException {
        if (fileName.indexOf(58) > 1) {
            URL url = new URL(fileName);
            InputStream in = url.openStream();
            return in;
        }
        fileName = this.translateFileName(fileName);
        FileInputStream in = new FileInputStream(fileName);
        this.trace("openFileInputStream", fileName, in);
        return in;
    }

    private void freeMemoryAndFinalize() {
        this.trace("freeMemoryAndFinalize", null, null);
        Runtime rt = Runtime.getRuntime();
        long mem = rt.freeMemory();
        for (int i = 0; i < 16; ++i) {
            rt.gc();
            long now = rt.freeMemory();
            rt.runFinalization();
            if (now == mem) break;
            mem = now;
        }
    }

    public FileObject openFileObject(String fileName, String mode) throws IOException {
        FileObjectDisk f;
        fileName = this.translateFileName(fileName);
        try {
            f = new FileObjectDisk(fileName, mode);
            this.trace("openRandomAccessFile", fileName, f);
        }
        catch (IOException e) {
            this.freeMemoryAndFinalize();
            f = new FileObjectDisk(fileName, mode);
        }
        return f;
    }
}

