/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.sql.SQLException;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;
import org.h2.value.DataType;
import org.h2.value.Value;

public class TriggerObject
extends SchemaObjectBase {
    public static final int DEFAULT_QUEUE_SIZE = 1024;
    private boolean before;
    private int typeMask;
    private boolean rowBased;
    private int queueSize = 1024;
    private boolean noWait;
    private Table table;
    private String triggerClassName;
    private Trigger triggerCallback;

    public TriggerObject(Schema schema, int id, String name, Table table) {
        super(schema, id, name, "trigger");
        this.table = table;
        this.setTemporary(table.getTemporary());
    }

    public void setBefore(boolean before) {
        this.before = before;
    }

    private synchronized void load(Session session) throws SQLException {
        if (this.triggerCallback != null) {
            return;
        }
        try {
            JdbcConnection c2 = session.createConnection(false);
            Object obj = session.getDatabase().loadUserClass(this.triggerClassName).newInstance();
            this.triggerCallback = (Trigger)obj;
            this.triggerCallback.init(c2, this.getSchema().getName(), this.getName(), this.table.getName(), this.before, this.typeMask);
        }
        catch (Throwable e) {
            throw Message.getSQLException(90043, new String[]{this.getName(), this.triggerClassName, e.toString()}, e);
        }
    }

    public void setTriggerClassName(Session session, String triggerClassName, boolean force) throws SQLException {
        block2: {
            this.triggerClassName = triggerClassName;
            try {
                this.load(session);
            }
            catch (SQLException e) {
                if (force) break block2;
                throw e;
            }
        }
    }

    public void fire(Session session, boolean beforeAction) throws SQLException {
        if (this.rowBased || this.before != beforeAction) {
            return;
        }
        this.load(session);
        JdbcConnection c2 = session.createConnection(false);
        boolean old = session.setCommitOrRollbackDisabled(true);
        try {
            this.triggerCallback.fire(c2, null, null);
        }
        catch (Throwable e) {
            throw Message.getSQLException(90044, new String[]{this.getName(), this.triggerClassName, e.toString()}, e);
        }
        finally {
            session.setCommitOrRollbackDisabled(old);
        }
    }

    private Object[] convertToObjectList(Row row) throws SQLException {
        if (row == null) {
            return null;
        }
        int len = row.getColumnCount();
        Object[] list = new Object[len];
        for (int i = 0; i < len; ++i) {
            list[i] = row.getValue(i).getObject();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRow(Session session, Row oldRow, Row newRow, boolean beforeAction) throws SQLException {
        Object[] newListBackup;
        if (!this.rowBased || this.before != beforeAction) {
            return;
        }
        boolean fire = false;
        if ((this.typeMask & 1) != 0 && oldRow == null && newRow != null) {
            fire = true;
        }
        if ((this.typeMask & 2) != 0 && oldRow != null && newRow != null) {
            fire = true;
        }
        if ((this.typeMask & 4) != 0 && oldRow != null && newRow == null) {
            fire = true;
        }
        if (!fire) {
            return;
        }
        Object[] oldList = this.convertToObjectList(oldRow);
        Object[] newList = this.convertToObjectList(newRow);
        if (this.before && newList != null) {
            newListBackup = new Object[newList.length];
            for (int i = 0; i < newList.length; ++i) {
                newListBackup[i] = newList[i];
            }
        } else {
            newListBackup = null;
        }
        JdbcConnection c2 = session.createConnection(false);
        boolean old = session.getAutoCommit();
        boolean oldDisabled = session.setCommitOrRollbackDisabled(true);
        try {
            session.setAutoCommit(false);
            this.triggerCallback.fire(c2, oldList, newList);
            if (newListBackup != null) {
                for (int i = 0; i < newList.length; ++i) {
                    Object o = newList[i];
                    if (o == newListBackup[i]) continue;
                    Value v = DataType.convertToValue(session, o, -1);
                    newRow.setValue(i, v);
                }
            }
        }
        finally {
            session.setCommitOrRollbackDisabled(oldDisabled);
            session.setAutoCommit(old);
        }
    }

    public void setTypeMask(int typeMask) {
        this.typeMask = typeMask;
    }

    public void setRowBased(boolean rowBased) {
        this.rowBased = rowBased;
    }

    public void setQueueSize(int size) {
        this.queueSize = size;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE FORCE TRIGGER ");
        buff.append(quotedName);
        if (this.before) {
            buff.append(" BEFORE ");
        } else {
            buff.append(" AFTER ");
        }
        buff.append(this.getTypeNameList());
        buff.append(" ON ");
        buff.append(table.getSQL());
        if (this.rowBased) {
            buff.append(" FOR EACH ROW");
        }
        if (this.noWait) {
            buff.append(" NOWAIT");
        } else {
            buff.append(" QUEUE ");
            buff.append(this.queueSize);
        }
        buff.append(" CALL ");
        buff.append(Parser.quoteIdentifier(this.triggerClassName));
        return buff.toString();
    }

    public String getTypeNameList() {
        StringBuffer buff = new StringBuffer();
        if ((this.typeMask & 1) != 0) {
            buff.append("INSERT");
        }
        if ((this.typeMask & 2) != 0) {
            if (buff.length() > 0) {
                buff.append(", ");
            }
            buff.append("UPDATE");
        }
        if ((this.typeMask & 4) != 0) {
            if (buff.length() > 0) {
                buff.append(", ");
            }
            buff.append("DELETE");
        }
        return buff.toString();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public int getType() {
        return 4;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeTrigger(session, this);
        this.database.removeMeta(session, this.getId());
        this.table = null;
        this.triggerClassName = null;
        this.triggerCallback = null;
        this.invalidate();
    }

    public void checkRename() {
    }

    public Table getTable() {
        return this.table;
    }

    public boolean getBefore() {
        return this.before;
    }

    public String getTriggerClassName() {
        return this.triggerClassName;
    }
}

