/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.constant.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.StringCache;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueStringBase;

public class ValueStringIgnoreCase
extends ValueStringBase {
    private static final ValueStringIgnoreCase EMPTY = new ValueStringIgnoreCase("");
    private int hash;

    protected ValueStringIgnoreCase(String value) {
        super(value);
    }

    public int getType() {
        return 14;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueStringIgnoreCase v = (ValueStringIgnoreCase)o;
        return mode.compareString(this.value, v.value, true);
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueStringBase && this.value.equalsIgnoreCase(((ValueStringBase)v).value);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.value.toUpperCase().hashCode();
        }
        return this.hash;
    }

    public String getSQL() {
        return "CAST(" + StringUtils.quoteStringSQL(this.value) + " AS VARCHAR_IGNORECASE)";
    }

    public static ValueStringIgnoreCase get(String s) {
        if (s.length() == 0) {
            return EMPTY;
        }
        ValueStringIgnoreCase obj = new ValueStringIgnoreCase(StringCache.get(s));
        if (s.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        ValueStringIgnoreCase cache = (ValueStringIgnoreCase)Value.cache(obj);
        if (cache.value.equals(s)) {
            return cache;
        }
        return obj;
    }

    public Value convertPrecision(long precision) {
        if (precision == 0L || (long)this.value.length() <= precision) {
            return this;
        }
        int p = MathUtils.convertLongToInt(precision);
        return ValueStringIgnoreCase.get(this.value.substring(0, p));
    }
}

