/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.h2.Driver;
import org.h2.api.DatabaseEventListener;
import org.h2.constant.SysProperties;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.WebSession;
import org.h2.server.web.WebThread;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.RandomUtils;
import org.h2.util.Resources;
import org.h2.util.SortedProperties;

public class WebServer
implements Service {
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String[][] LANGUAGES = new String[][]{{"de", "Deutsch"}, {"en", "English"}, {"es", "Espa\u00f1ol"}, {"fr", "Fran\u00e7ais"}, {"hu", "Magyar"}, {"in", "Indonesia"}, {"it", "Italiano"}, {"ja", "\u65e5\u672c\u8a9e"}, {"nl", "Nederlands"}, {"pl", "Polski"}, {"pt_BR", "Portugu\u00eas (Brasil)"}, {"pt_PT", "Portugu\u00eas (Europeu)"}, {"ru", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439"}, {"tr", "T\u00fcrk\u00e7e"}, {"uk", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"}, {"zh_CN", "\u4e2d\u6587"}};
    private static final String[] GENERIC = new String[]{"Generic JNDI Data Source|javax.naming.InitialContext|java:comp/env/jdbc/Test|sa", "Generic Firebird Server|org.firebirdsql.jdbc.FBDriver|jdbc:firebirdsql:localhost:c:/temp/firebird/test|sysdba", "Generic OneDollarDB|in.co.daffodil.db.jdbc.DaffodilDBDriver|jdbc:daffodilDB_embedded:school;path=C:/temp;create=true|sa", "Generic DB2|COM.ibm.db2.jdbc.net.DB2Driver|jdbc:db2://<host>/<db>|", "Generic Oracle|oracle.jdbc.driver.OracleDriver|jdbc:oracle:thin:@<host>:1521:<instance>|scott", "Generic MS SQL Server 2000|com.microsoft.jdbc.sqlserver.SQLServerDriver|jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=sqlexpress|sa", "Generic MS SQL Server 2005|com.microsoft.sqlserver.jdbc.SQLServerDriver|jdbc:sqlserver://localhost;DatabaseName=test|sa", "Generic PostgreSQL|org.postgresql.Driver|jdbc:postgresql:<db>|", "Generic MySQL|com.mysql.jdbc.Driver|jdbc:mysql://<host>:<port>/<db>|", "Generic Derby (Server)|org.apache.derby.jdbc.ClientDriver|jdbc:derby://localhost:1527/test;create=true|sa", "Generic Derby (Embedded)|org.apache.derby.jdbc.EmbeddedDriver|jdbc:derby:test;create=true|sa", "Generic HSQLDB|org.hsqldb.jdbcDriver|jdbc:hsqldb:test;hsqldb.default_table_type=cached|sa", "Generic H2|org.h2.Driver|jdbc:h2:~/test|sa"};
    private String driverList;
    private static int ticker;
    private int port;
    private boolean allowOthers;
    private Set running = Collections.synchronizedSet(new HashSet());
    private boolean ssl;
    private HashMap connInfoMap = new HashMap();
    private static final long SESSION_TIMEOUT = 1800000L;
    private long lastTimeoutCheck;
    private HashMap sessions = new HashMap();
    private HashSet languages = new HashSet();
    private String startDateTime;
    private ServerSocket serverSocket;
    private String url;
    private ShutdownHandler shutdownHandler;
    private Thread listenerThread;
    private boolean ifExists;
    private boolean allowScript;

    byte[] getFile(String file) throws IOException {
        this.trace("getFile <" + file + ">");
        byte[] data = Resources.get("/org/h2/server/web/res/" + file);
        if (data == null) {
            this.trace(" null");
        } else {
            this.trace(" size=" + data.length);
        }
        return data;
    }

    String getTextFile(String file) throws IOException {
        byte[] bytes = this.getFile(file);
        return new String(bytes);
    }

    synchronized void remove(WebThread t) {
        this.running.remove(t);
    }

    private String generateSessionId() {
        byte[] buff = RandomUtils.getSecureBytes(16);
        return ByteUtils.convertBytesToString(buff);
    }

    WebSession getSession(String sessionId) {
        WebSession session;
        long now = System.currentTimeMillis();
        if (this.lastTimeoutCheck + 1800000L < now) {
            Object[] list = this.sessions.keySet().toArray();
            for (int i = 0; i < list.length; ++i) {
                String id = (String)list[i];
                WebSession session2 = (WebSession)this.sessions.get(id);
                Long last = (Long)session2.get("lastAccess");
                if (last == null || last + 1800000L >= now) continue;
                this.trace("timeout for " + id);
                this.sessions.remove(id);
            }
            this.lastTimeoutCheck = now;
        }
        if ((session = (WebSession)this.sessions.get(sessionId)) != null) {
            session.lastAccess = System.currentTimeMillis();
        }
        return session;
    }

    WebSession createNewSession(String hostname) {
        String newId;
        while (this.sessions.get(newId = this.generateSessionId()) != null) {
        }
        WebSession session = new WebSession(this);
        session.put("sessionId", newId);
        session.put("ip", hostname);
        session.put("language", DEFAULT_LANGUAGE);
        this.sessions.put(newId, session);
        this.readTranslations(session, DEFAULT_LANGUAGE);
        return this.getSession(newId);
    }

    String getStartDateTime() {
        return this.startDateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String[] args) throws Exception {
        Object a;
        Properties prop = this.loadProperties();
        this.driverList = prop.getProperty("drivers");
        this.port = FileUtils.getIntProperty(prop, "webPort", 8082);
        this.ssl = FileUtils.getBooleanProperty(prop, "webSSL", false);
        this.allowOthers = FileUtils.getBooleanProperty(prop, "webAllowOthers", false);
        for (int i = 0; args != null && i < args.length; ++i) {
            a = args[i];
            if ("-webPort".equals(a)) {
                this.port = MathUtils.decodeInt(args[++i]);
                continue;
            }
            if ("-webSSL".equals(a)) {
                this.ssl = Boolean.valueOf(args[++i]);
                continue;
            }
            if ("-webAllowOthers".equals(a)) {
                this.allowOthers = Boolean.valueOf(args[++i]);
                continue;
            }
            if ("-webScript".equals(a)) {
                this.allowScript = Boolean.valueOf(args[++i]);
                continue;
            }
            if ("-baseDir".equals(a)) {
                String baseDir = args[++i];
                SysProperties.setBaseDir(baseDir);
                continue;
            }
            if (!"-ifExists".equals(a)) continue;
            this.ifExists = Boolean.valueOf(args[++i]);
        }
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", new Locale(DEFAULT_LANGUAGE, ""));
        a = format;
        synchronized (a) {
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.startDateTime = format.format(new Date());
        }
        this.trace(this.startDateTime);
        for (int i = 0; i < LANGUAGES.length; ++i) {
            this.languages.add(LANGUAGES[i][0]);
        }
        this.url = (this.ssl ? "https" : "http") + "://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    public String getURL() {
        return this.url;
    }

    public void start() throws SQLException {
        this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
    }

    public void listen() {
        this.listenerThread = Thread.currentThread();
        try {
            while (this.serverSocket != null) {
                Socket s = this.serverSocket.accept();
                WebThread c = new WebThread(s, this);
                this.running.add(c);
                c.start();
            }
        }
        catch (Exception e) {
            this.trace(e.toString());
        }
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, this.ssl);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void stop() {
        int i;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.serverSocket = null;
        if (this.listenerThread != null) {
            try {
                this.listenerThread.join(1000L);
            }
            catch (InterruptedException e) {
                TraceSystem.traceThrowable(e);
            }
        }
        ArrayList<Object> list = new ArrayList(this.sessions.values());
        for (i = 0; i < list.size(); ++i) {
            WebSession session = (WebSession)list.get(i);
            Statement stat = session.executingStatement;
            if (stat == null) continue;
            try {
                stat.cancel();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        list = new ArrayList(this.running);
        for (i = 0; i < list.size(); ++i) {
            WebThread c = (WebThread)list.get(i);
            try {
                c.stopNow();
                c.join(100L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void trace(String s) {
    }

    public void traceError(Exception e) {
        e.printStackTrace();
    }

    public boolean supportsLanguage(String language) {
        return this.languages.contains(language);
    }

    public void readTranslations(WebSession session, String language) {
        Properties text = new Properties();
        try {
            this.trace("translation: " + language);
            byte[] trans = this.getFile("_text_" + language + ".properties");
            this.trace("  " + new String(trans));
            text.load(new ByteArrayInputStream(trans));
        }
        catch (IOException e) {
            TraceSystem.traceThrowable(e);
        }
        session.put("text", new HashMap<Object, Object>(text));
    }

    public String[][] getLanguageArray() {
        return LANGUAGES;
    }

    public ArrayList getSessions() {
        ArrayList list = new ArrayList(this.sessions.values());
        for (int i = 0; i < list.size(); ++i) {
            WebSession s = (WebSession)list.get(i);
            list.set(i, s.getInfo());
        }
        return list;
    }

    public String getType() {
        return "Web";
    }

    public String getName() {
        return "H2 Console Server";
    }

    void setAllowOthers(boolean b) {
        this.allowOthers = b;
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    void setSSL(boolean b) {
        this.ssl = b;
    }

    void setPort(int port) {
        this.port = port;
    }

    boolean getSSL() {
        return this.ssl;
    }

    int getPort() {
        return this.port;
    }

    ConnectionInfo getSetting(String name) {
        return (ConnectionInfo)this.connInfoMap.get(name);
    }

    void updateSetting(ConnectionInfo info) {
        this.connInfoMap.put(info.name, info);
        info.lastAccess = ticker++;
    }

    void removeSetting(String name) {
        this.connInfoMap.remove(name);
    }

    private String getPropertiesFileName() {
        return FileUtils.getFileInUserHome(".h2.server.properties");
    }

    Properties loadProperties() {
        String fileName = this.getPropertiesFileName();
        try {
            return FileUtils.loadProperties(fileName);
        }
        catch (IOException e) {
            return new Properties();
        }
    }

    String[] getSettingNames() {
        ArrayList list = this.getSettings();
        String[] names = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            names[i] = ((ConnectionInfo)list.get((int)i)).name;
        }
        return names;
    }

    synchronized ArrayList getSettings() {
        ArrayList<ConnectionInfo> settings = new ArrayList<ConnectionInfo>();
        if (this.connInfoMap.size() == 0) {
            Properties prop = this.loadProperties();
            if (prop.size() == 0) {
                for (int i = 0; i < GENERIC.length; ++i) {
                    ConnectionInfo info = new ConnectionInfo(GENERIC[i]);
                    settings.add(info);
                    this.updateSetting(info);
                }
            } else {
                String data;
                int i = 0;
                while ((data = prop.getProperty(String.valueOf(i))) != null) {
                    ConnectionInfo info = new ConnectionInfo(data);
                    settings.add(info);
                    this.updateSetting(info);
                    ++i;
                }
            }
        } else {
            settings.addAll(this.connInfoMap.values());
        }
        this.sortConnectionInfo(settings);
        return settings;
    }

    void sortConnectionInfo(ArrayList list) {
        for (int i = 1; i < list.size(); ++i) {
            int j;
            ConnectionInfo t = (ConnectionInfo)list.get(i);
            for (j = i - 1; j >= 0 && ((ConnectionInfo)list.get((int)j)).lastAccess < t.lastAccess; --j) {
                list.set(j + 1, list.get(j));
            }
            list.set(j + 1, t);
        }
    }

    synchronized void saveSettings() {
        try {
            SortedProperties prop = new SortedProperties();
            if (this.driverList != null) {
                prop.setProperty("drivers", this.driverList);
            }
            prop.setProperty("webPort", String.valueOf(this.port));
            prop.setProperty("webAllowOthers", String.valueOf(this.allowOthers));
            prop.setProperty("webSSL", String.valueOf(this.ssl));
            ArrayList settings = this.getSettings();
            int len = settings.size();
            for (int i = 0; i < len; ++i) {
                ConnectionInfo info = (ConnectionInfo)settings.get(i);
                if (info == null) continue;
                prop.setProperty(String.valueOf(len - i - 1), info.getString());
            }
            OutputStream out = FileUtils.openFileOutputStream(this.getPropertiesFileName(), false);
            prop.store(out, "H2 Server Properties");
            out.close();
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
        }
    }

    Connection getConnection(String driver, String url, String user, String password, DatabaseEventListener listener) throws Exception {
        driver = driver.trim();
        url = url.trim();
        Driver.load();
        Properties p = new Properties();
        p.setProperty("user", user.trim());
        p.setProperty("password", password.trim());
        if (url.startsWith("jdbc:h2:")) {
            if (this.ifExists) {
                url = url + ";IFEXISTS=TRUE";
            }
            p.put("DATABASE_EVENT_LISTENER_OBJECT", listener);
            return Driver.load().connect(url, p);
        }
        return JdbcUtils.getConnection(driver, url, p);
    }

    void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    public boolean getAllowScript() {
        return this.allowScript;
    }
}

