/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Function;
import org.h2.expression.FunctionCall;
import org.h2.expression.FunctionInfo;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.table.Column;
import org.h2.tools.SimpleResultSet;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class TableFunction
extends Function
implements FunctionCall {
    private boolean distinct;
    private Column[] columnList;

    TableFunction(Database database, FunctionInfo info) {
        super(database, info);
        this.distinct = info.type == 224;
    }

    public Value getValue(Session session) throws SQLException {
        return this.getTable(session, this.args, false, this.distinct);
    }

    protected void checkParameterCount(int len) throws SQLException {
        if (len < 1) {
            throw Message.getSQLException(7001, new String[]{this.getName(), ">0"});
        }
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName());
        buff.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.columnList[i].getCreateSQL());
            buff.append("=");
            Expression e = this.args[i];
            buff.append(e.getSQL());
        }
        buff.append(')');
        return buff.toString();
    }

    public String getName() {
        return this.distinct ? "TABLE_DISTINCT" : "TABLE";
    }

    public int getRowCount(Session session) throws SQLException {
        int len = this.columnList.length;
        int rowCount = 0;
        for (int i = 0; i < len; ++i) {
            Value v;
            Expression expr = this.args[i];
            if (!expr.isConstant() || (v = expr.getValue(session)) == ValueNull.INSTANCE) continue;
            ValueArray array = (ValueArray)v.convertTo(17);
            Value[] l = array.getList();
            rowCount = Math.max(rowCount, l.length);
        }
        return rowCount;
    }

    public ValueResultSet getValueForColumnList(Session session, Expression[] nullArgs) throws SQLException {
        return this.getTable(session, this.args, true, false);
    }

    public void setColumns(ObjectArray columns) {
        this.columnList = new Column[columns.size()];
        columns.toArray(this.columnList);
    }

    public ValueResultSet getTable(Session session, Expression[] args, boolean onlyColumnList, boolean distinct) throws SQLException {
        int len = this.columnList.length;
        Expression[] header = new Expression[len];
        Database db = session.getDatabase();
        for (int i = 0; i < len; ++i) {
            Column c = this.columnList[i];
            ExpressionColumn col = new ExpressionColumn(db, c);
            header[i] = col;
        }
        LocalResult result = new LocalResult(session, header, len);
        if (distinct) {
            result.setDistinct();
        }
        if (!onlyColumnList) {
            Value[] l;
            Value[][] list = new Value[len][];
            int rowCount = 0;
            for (int i = 0; i < len; ++i) {
                Value v = args[i].getValue(session);
                if (v == ValueNull.INSTANCE) {
                    list[i] = new Value[0];
                    continue;
                }
                ValueArray array = (ValueArray)v.convertTo(17);
                l = array.getList();
                list[i] = l;
                rowCount = Math.max(rowCount, l.length);
            }
            for (int row = 0; row < rowCount; ++row) {
                Value[] r = new Value[len];
                for (int j = 0; j < len; ++j) {
                    Value v;
                    l = list[j];
                    if (l.length <= row) {
                        v = ValueNull.INSTANCE;
                    } else {
                        Column c = this.columnList[j];
                        v = l[row];
                        v = v.convertTo(c.getType());
                        v = v.convertPrecision(c.getPrecision());
                        v = v.convertScale(true, c.getScale());
                    }
                    r[j] = v;
                }
                result.addRow(r);
            }
        }
        result.done();
        ValueResultSet vr = ValueResultSet.get(this.getSimpleResultSet(result, Integer.MAX_VALUE));
        return vr;
    }

    SimpleResultSet getSimpleResultSet(LocalResult rs, int maxrows) throws SQLException {
        int i;
        int columnCount = rs.getVisibleColumnCount();
        SimpleResultSet simple = new SimpleResultSet();
        for (i = 0; i < columnCount; ++i) {
            String name = rs.getColumnName(i);
            int sqlType = DataType.convertTypeToSQLType(rs.getColumnType(i));
            int precision = MathUtils.convertLongToInt(rs.getColumnPrecision(i));
            int scale = rs.getColumnScale(i);
            simple.addColumn(name, sqlType, precision, scale);
        }
        rs.reset();
        for (i = 0; i < maxrows && rs.next(); ++i) {
            Object[] list = new Object[columnCount];
            for (int j = 0; j < columnCount; ++j) {
                list[j] = rs.currentRow()[j].getObject();
            }
            simple.addRow(list);
        }
        return simple;
    }
}

