/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        if (this.dropAllObjects) {
            this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0;
    }

    private void dropAllObjects() throws SQLException {
        String sql;
        DbObject obj;
        Table t;
        int i;
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        ObjectArray list = db.getAllSchemas();
        for (i = 0; i < list.size(); ++i) {
            Schema schema = (Schema)list.get(i);
            if (!schema.canDrop()) continue;
            db.removeDatabaseObject(this.session, schema);
        }
        list = db.getAllSchemaObjects(0);
        for (i = 0; i < list.size(); ++i) {
            t = (Table)list.get(i);
            if (t.getName() == null || !"VIEW".equals(t.getTableType())) continue;
            db.removeSchemaObject(this.session, t);
        }
        for (i = 0; i < list.size(); ++i) {
            t = (Table)list.get(i);
            if (t.getName() == null || !"TABLE LINK".equals(t.getTableType())) continue;
            db.removeSchemaObject(this.session, t);
        }
        for (i = 0; i < list.size(); ++i) {
            t = (Table)list.get(i);
            if (t.getName() == null || !"TABLE".equals(t.getTableType())) continue;
            db.removeSchemaObject(this.session, t);
        }
        this.session.findLocalTempTable(null);
        list = db.getAllSchemaObjects(3);
        list.addAll(db.getAllSchemaObjects(5));
        list.addAll(db.getAllSchemaObjects(4));
        list.addAll(db.getAllSchemaObjects(11));
        for (i = 0; i < list.size(); ++i) {
            obj = (SchemaObject)list.get(i);
            db.removeSchemaObject(this.session, (SchemaObject)obj);
        }
        list = db.getAllUsers();
        for (i = 0; i < list.size(); ++i) {
            User user = (User)list.get(i);
            if (user == this.session.getUser()) continue;
            db.removeDatabaseObject(this.session, user);
        }
        list = db.getAllRoles();
        for (i = 0; i < list.size(); ++i) {
            Role role = (Role)list.get(i);
            sql = role.getCreateSQL();
            if (sql == null) continue;
            db.removeDatabaseObject(this.session, role);
        }
        list = db.getAllRights();
        list.addAll(db.getAllFunctionAliases());
        list.addAll(db.getAllAggregates());
        list.addAll(db.getAllUserDataTypes());
        for (i = 0; i < list.size(); ++i) {
            obj = (DbObject)list.get(i);
            sql = obj.getCreateSQL();
            if (sql == null) continue;
            db.removeDatabaseObject(this.session, obj);
        }
    }

    public void setDropAllObjects(boolean b) {
        this.dropAllObjects = b;
    }

    public void setDeleteFiles(boolean b) {
        this.deleteFiles = b;
    }
}

