/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;
import org.h2.util.StringUtils;

public class RuleElement
implements Rule {
    private boolean keyword;
    private String name;
    private Rule link;
    private int type;
    private String topic;

    RuleElement(String name, String topic) {
        this.name = name;
        this.topic = topic;
        if (name.length() == 1 || name.equals(StringUtils.toUpperEnglish(name))) {
            this.keyword = true;
        }
        this.type = (topic = StringUtils.toLowerEnglish(topic)).startsWith("function") ? 2 : 1;
    }

    RuleElement merge(RuleElement rule) {
        return new RuleElement(this.name + " " + rule.name, this.topic);
    }

    public String random(Bnf config, int level) {
        if (this.keyword) {
            return this.name.length() > 1 ? " " + this.name + " " : this.name;
        }
        if (this.link != null) {
            return this.link.random(config, level + 1);
        }
        throw new Error(">>>" + this.name + "<<<");
    }

    public String name() {
        return this.name;
    }

    public Rule last() {
        return this;
    }

    public void setLinks(HashMap ruleMap) {
        if (this.link != null) {
            this.link.setLinks(ruleMap);
        }
        if (this.keyword) {
            return;
        }
        for (int i = 0; i < this.name.length() && this.link == null; ++i) {
            String test = StringUtils.toLowerEnglish(this.name.substring(i));
            RuleHead r = (RuleHead)ruleMap.get(test);
            if (r == null) continue;
            this.link = r.getRule();
            return;
        }
        if (this.link == null) {
            throw new Error(">>>" + this.name + "<<<");
        }
    }

    public String matchRemove(String query, Sentence sentence) {
        if (sentence.stop()) {
            return null;
        }
        if (query.length() == 0) {
            return null;
        }
        if (this.keyword) {
            String up = StringUtils.toUpperEnglish(query);
            if (up.startsWith(this.name)) {
                query = query.substring(this.name.length());
                while (!"_".equals(this.name) && query.length() > 0 && Character.isWhitespace(query.charAt(0))) {
                    query = query.substring(1);
                }
                return query;
            }
            return null;
        }
        if (!((query = this.link.matchRemove(query, sentence)) == null || this.name.startsWith("@") || this.link.name() != null && this.link.name().startsWith("@"))) {
            while (query.length() > 0 && Character.isWhitespace(query.charAt(0))) {
                query = query.substring(1);
            }
        }
        return query;
    }

    public void addNextTokenList(String query, Sentence sentence) {
        if (sentence.stop()) {
            return;
        }
        if (this.keyword) {
            String q = query.trim();
            String up = StringUtils.toUpperEnglish(q);
            if ((q.length() == 0 || this.name.startsWith(up)) && q.length() < this.name.length()) {
                sentence.add(this.name, this.name.substring(q.length()), this.type);
            }
            return;
        }
        this.link.addNextTokenList(query, sentence);
    }

    boolean isKeyword() {
        return this.keyword;
    }
}

