/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.h2.api.DatabaseEventListener;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.util.FileUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;

public class ConnectionInfo {
    private static final HashSet KNOWN_SETTINGS = new HashSet();
    private final Properties prop = new Properties();
    private String originalURL;
    private String url;
    private String user;
    private byte[] filePasswordHash;
    private byte[] userPasswordHash;
    private String name;
    private boolean remote;
    private boolean ssl;
    private boolean persistent;
    private boolean unnamed;

    public ConnectionInfo(String name) {
        this.name = name;
        this.parseName();
    }

    public ConnectionInfo(String u, Properties info) throws SQLException {
        this.originalURL = u;
        if (!u.startsWith("jdbc:h2:")) {
            throw Message.getInvalidValueException(u, "url");
        }
        this.url = u;
        this.readProperties(info);
        this.readSettingsFromURL();
        this.setUserName(this.removeProperty("USER", ""));
        this.readPasswords();
        this.name = this.url.substring("jdbc:h2:".length());
        this.parseName();
    }

    private void parseName() {
        if (".".equals(this.name)) {
            this.name = "mem:";
        }
        if (this.name.startsWith("tcp:")) {
            this.remote = true;
            this.name = this.name.substring("tcp:".length());
        } else if (this.name.startsWith("ssl:")) {
            this.remote = true;
            this.ssl = true;
            this.name = this.name.substring("ssl:".length());
        } else if (this.name.startsWith("mem:")) {
            this.persistent = false;
            if ("mem:".equals(this.name)) {
                this.unnamed = true;
            }
        } else if (this.name.startsWith("file:")) {
            this.name = this.name.substring("file:".length());
            this.persistent = true;
        } else {
            this.persistent = true;
        }
    }

    public String getDatabaseName() {
        if (this.remote) {
            if (this.ssl) {
                return "ssl:" + this.name;
            }
            return "tcp:" + this.name;
        }
        if (this.persistent) {
            return "file:" + this.name;
        }
        return this.name;
    }

    public void setBaseDir(String dir) {
        if (this.persistent) {
            this.name = dir + SysProperties.FILE_SEPARATOR + this.name;
        }
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isUnnamed() {
        return this.unnamed;
    }

    private void readProperties(Properties info) throws SQLException {
        Object[] list = new Object[info.size()];
        info.keySet().toArray(list);
        for (int i = 0; i < list.length; ++i) {
            String key = StringUtils.toUpperEnglish(list[i].toString());
            if (this.prop.containsKey(key)) {
                throw Message.getSQLException(90066, key);
            }
            if (!KNOWN_SETTINGS.contains(key)) continue;
            this.prop.put(key, info.get(list[i]));
        }
    }

    private void readSettingsFromURL() throws SQLException {
        int idx = this.url.indexOf(59);
        if (idx >= 0) {
            String settings = this.url.substring(idx + 1);
            this.url = this.url.substring(0, idx);
            String[] list = StringUtils.arraySplit(settings, ';', false);
            for (int i = 0; i < list.length; ++i) {
                String setting = list[i];
                int equal = setting.indexOf(61);
                if (equal < 0) {
                    throw this.getFormatException();
                }
                String value = setting.substring(equal + 1);
                String key = setting.substring(0, equal);
                if (!KNOWN_SETTINGS.contains(key = StringUtils.toUpperEnglish(key))) {
                    throw Message.getSQLException(90113, key);
                }
                String old = this.prop.getProperty(key);
                if (old != null && !old.equals(value)) {
                    throw Message.getSQLException(90066, key);
                }
                this.prop.setProperty(key, value);
            }
        }
    }

    DatabaseEventListener removeDatabaseEventListenerObject() throws SQLException {
        Object p = this.prop.remove("DATABASE_EVENT_LISTENER_OBJECT");
        if (p == null) {
            return null;
        }
        if (p instanceof DatabaseEventListener) {
            return (DatabaseEventListener)p;
        }
        throw Message.getSQLException(90021, p.getClass().getName());
    }

    private char[] removePassword() {
        Object p = this.prop.remove("PASSWORD");
        if (p == null) {
            return new char[0];
        }
        if (p instanceof char[]) {
            return (char[])p;
        }
        return p.toString().toCharArray();
    }

    public void readPasswords() throws SQLException {
        char[] password = this.removePassword();
        SHA256 sha = new SHA256();
        if (this.getProperty("CIPHER", null) != null) {
            int space = -1;
            for (int i = 0; i < password.length; ++i) {
                if (password[i] != ' ') continue;
                space = i;
                break;
            }
            if (space < 0) {
                throw Message.getSQLException(90050);
            }
            char[] np = new char[password.length - space - 1];
            char[] filePassword = new char[space];
            System.arraycopy(password, space + 1, np, 0, np.length);
            System.arraycopy(password, 0, filePassword, 0, space);
            Arrays.fill(password, '\u0000');
            password = np;
            this.filePasswordHash = sha.getKeyPasswordHash("file", filePassword);
        }
        this.userPasswordHash = sha.getKeyPasswordHash(this.user, password);
    }

    public boolean removeProperty(String key, boolean defaultValue) {
        String x = this.removeProperty(key, null);
        return x == null ? defaultValue : Boolean.valueOf(x);
    }

    public String removeProperty(String key, String defaultValue) {
        if (SysProperties.CHECK && !KNOWN_SETTINGS.contains(key)) {
            throw Message.getInternalError(key);
        }
        Object x = this.prop.remove(key);
        return x == null ? defaultValue : x.toString();
    }

    public String getName() throws SQLException {
        if (this.persistent) {
            String n = FileUtils.normalize(this.name + ".data.db");
            n = n.substring(0, n.length() - ".data.db".length());
            return FileUtils.normalize(n);
        }
        return this.name;
    }

    public byte[] getFilePasswordHash() {
        return this.filePasswordHash;
    }

    public String getUserName() {
        return this.user;
    }

    public byte[] getUserPasswordHash() {
        return this.userPasswordHash;
    }

    public String[] getKeys() {
        String[] keys = new String[this.prop.size()];
        this.prop.keySet().toArray(keys);
        return keys;
    }

    public String getProperty(String key) {
        return this.prop.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (SysProperties.CHECK && !KNOWN_SETTINGS.contains(key)) {
            throw Message.getInternalError(key);
        }
        String s = this.getProperty(key);
        return s == null ? defaultValue : s;
    }

    public String getProperty(int setting, String defaultValue) {
        String key = SetTypes.getTypeName(setting);
        String s = this.getProperty(key);
        return s == null ? defaultValue : s;
    }

    public int getIntProperty(int setting, int defaultValue) {
        String key = SetTypes.getTypeName(setting);
        String s = this.getProperty(key, null);
        try {
            return s == null ? defaultValue : MathUtils.decodeInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public void setUserName(String name) {
        this.user = StringUtils.toUpperEnglish(name);
    }

    public void setUserPasswordHash(byte[] bs) {
        this.userPasswordHash = bs;
    }

    public void setFilePasswordHash(byte[] bs) {
        this.filePasswordHash = bs;
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.prop.setProperty(key, value);
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getOriginalURL() {
        return this.originalURL;
    }

    public void setOriginalURL(String url) {
        this.originalURL = url;
    }

    boolean getTextStorage() throws SQLException {
        String storage = this.removeProperty("STORAGE", "BINARY");
        if ("BINARY".equalsIgnoreCase(storage)) {
            return false;
        }
        if ("TEXT".equalsIgnoreCase(storage)) {
            return true;
        }
        throw Message.getInvalidValueException(storage, "storage");
    }

    public SQLException getFormatException() {
        String format = "jdbc:h2:{ {.|mem:}[name] | [file:]fileName | {tcp|ssl}:[//]server[:port][,server2[:port]]/name }[;key=value...]";
        return Message.getSQLException(90046, new String[]{format, this.url});
    }

    static {
        ObjectArray list = SetTypes.getSettings();
        for (int i = 0; i < list.size(); ++i) {
            KNOWN_SETTINGS.add(list.get(i));
        }
        String[] connectionTime = new String[]{"ACCESS_MODE_LOG", "ACCESS_MODE_DATA", "AUTOCOMMIT", "CIPHER", "CREATE", "CACHE_TYPE", "DB_CLOSE_ON_EXIT", "FILE_LOCK", "IGNORE_UNKNOWN_SETTINGS", "IFEXISTS", "PASSWORD", "RECOVER", "STORAGE", "USER", "DATABASE_EVENT_LISTENER_OBJECT"};
        for (int i = 0; i < connectionTime.length; ++i) {
            String key = connectionTime[i];
            if (SysProperties.CHECK && KNOWN_SETTINGS.contains(key)) {
                throw Message.getInternalError(key);
            }
            KNOWN_SETTINGS.add(key);
        }
    }
}

