/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.command.dml.Select;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Function;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.FunctionTable;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionIn
extends Condition {
    private final Database database;
    private Expression left;
    private final ObjectArray values;
    private Value min;
    private Value max;
    private int queryLevel;

    public ConditionIn(Database database, Expression left, ObjectArray values) {
        this.database = database;
        this.left = left;
        this.values = values;
    }

    public Value getValue(Session session) throws SQLException {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return l;
        }
        boolean result = false;
        boolean hasNull = false;
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            Value r = e.getValue(session);
            if (r == ValueNull.INSTANCE) {
                hasNull = true;
                continue;
            }
            result = Comparison.compareNotNull(this.database, l, r, 0);
            if (result) break;
        }
        if (!result && hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(result);
    }

    public void mapColumns(ColumnResolver resolver, int queryLevel) throws SQLException {
        this.left.mapColumns(resolver, queryLevel);
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            e.mapColumns(resolver, queryLevel);
        }
        this.queryLevel = Math.max(queryLevel, this.queryLevel);
    }

    public Expression optimize(Session session) throws SQLException {
        this.left = this.left.optimize(session);
        boolean constant = this.left.isConstant();
        if (constant && this.left == ValueExpression.NULL) {
            return this.left;
        }
        boolean allValuesConstant = true;
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            e = e.optimize(session);
            if (allValuesConstant && !e.isConstant()) {
                allValuesConstant = false;
            }
            this.values.set(i, e);
        }
        if (constant && allValuesConstant) {
            return ValueExpression.get(this.getValue(session));
        }
        if (this.values.size() == 1) {
            Expression right = (Expression)this.values.get(0);
            Expression expr = new Comparison(session, 0, this.left, right);
            expr = ((Expression)expr).optimize(session);
            return expr;
        }
        if (SysProperties.OPTIMIZE_IN) {
            int dataType = this.left.getType();
            ExpressionVisitor independent = ExpressionVisitor.get(0);
            independent.queryLevel = this.queryLevel;
            if (this.areAllValues(independent) && this.left instanceof ExpressionColumn) {
                Column column = ((ExpressionColumn)this.left).getColumn();
                boolean nullable = column.getNullable();
                CompareMode mode = session.getDatabase().getCompareMode();
                for (int i = 0; i < this.values.size(); ++i) {
                    Expression e = (Expression)this.values.get(i);
                    Value v = e.getValue(session);
                    v = v.convertTo(dataType);
                    this.values.set(i, ValueExpression.get(v));
                    if (!(this.min != null && this.min.compareTo(v, mode) <= 0 || v == ValueNull.INSTANCE && !nullable)) {
                        this.min = v;
                    }
                    if (this.max != null && this.max.compareTo(v, mode) >= 0) continue;
                    this.max = v;
                }
            }
        }
        return this;
    }

    public void createIndexConditions(Session session, TableFilter filter) {
        if (!SysProperties.OPTIMIZE_IN) {
            return;
        }
        if (this.min == null && this.max == null) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        filter.addIndexCondition(new IndexCondition(1, l, ValueExpression.get(this.min)));
        filter.addIndexCondition(new IndexCondition(3, l, ValueExpression.get(this.max)));
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            e.setEvaluatable(tableFilter, b);
        }
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer("(");
        buff.append(this.left.getSQL());
        buff.append(" IN(");
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            Expression e = (Expression)this.values.get(i);
            buff.append(e.getSQL());
        }
        buff.append("))");
        return buff.toString();
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            e.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        if (!this.left.isEverything(visitor)) {
            return false;
        }
        return this.areAllValues(visitor);
    }

    private boolean areAllValues(ExpressionVisitor visitor) {
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            if (e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        int cost = this.left.getCost();
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e = (Expression)this.values.get(i);
            cost += e.getCost();
        }
        return cost;
    }

    public Expression optimizeInJoin(Session session, Select select) throws SQLException {
        if (!this.areAllValues(ExpressionVisitor.get(3))) {
            return this;
        }
        Database db = session.getDatabase();
        Schema mainSchema = db.getSchema("PUBLIC");
        Function function = Function.getFunction(this.database, "TABLE_DISTINCT");
        Expression[] array = new Expression[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            Expression e;
            array[i] = e = (Expression)this.values.get(i);
        }
        ExpressionList list = new ExpressionList(array);
        function.setParameter(0, list);
        function.doneWithParameters();
        ObjectArray columns = new ObjectArray();
        int dataType = this.left.getType();
        String columnName = session.getNextTempViewName() + "_X";
        Column col = new Column(columnName, dataType);
        columns.add(col);
        function.setColumns(columns);
        FunctionTable table = new FunctionTable(mainSchema, session, function);
        String viewName = session.getNextTempViewName();
        TableFilter filter = new TableFilter(session, table, viewName, false, select);
        select.addTableFilter(filter, true);
        ExpressionColumn column = new ExpressionColumn(db, null, viewName, columnName);
        Comparison on = new Comparison(session, 0, this.left, column);
        on.mapColumns(filter, 0);
        filter.addFilterCondition(on, true);
        return ValueExpression.get(ValueBoolean.get(true));
    }
}

