/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.ScanCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Storage;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class ScanIndex
extends BaseIndex {
    private int firstFree = -1;
    private ObjectArray rows = new ObjectArray();
    private Storage storage;
    private TableData tableData;
    private boolean containsLargeObject;
    private int rowCountDiff;
    private HashMap sessionRowCount;
    private HashSet delta;

    public ScanIndex(TableData table, int id, IndexColumn[] columns, IndexType indexType) throws SQLException {
        super(table, id, table.getName() + "_TABLE_SCAN", columns, indexType);
        if (this.database.isMultiVersion()) {
            this.sessionRowCount = new HashMap();
        }
        this.tableData = table;
        if (!this.database.isPersistent() || id < 0) {
            return;
        }
        this.storage = this.database.getStorage(table, id, true);
        int count = this.storage.getRecordCount();
        this.rowCount = count;
        table.setRowCount(count);
        this.trace.info("open existing " + table.getName() + " rows: " + count);
        for (int i = 0; i < columns.length; ++i) {
            if (!DataType.isLargeObject(columns[i].column.getType())) continue;
            this.containsLargeObject = true;
        }
    }

    public void remove(Session session) throws SQLException {
        this.truncate(session);
        if (this.storage != null) {
            this.storage.delete(session);
        }
    }

    public void truncate(Session session) throws SQLException {
        if (this.storage == null) {
            this.rows = new ObjectArray();
            this.firstFree = -1;
        } else {
            this.storage.truncate(session);
        }
        if (this.containsLargeObject && this.tableData.isPersistent()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        this.tableData.setRowCount(0);
        this.rowCount = 0L;
        if (this.database.isMultiVersion()) {
            this.sessionRowCount.clear();
        }
    }

    public String getCreateSQL() {
        return null;
    }

    public void close(Session session) throws SQLException {
        if (this.storage != null) {
            this.storage = null;
        }
    }

    public Row getRow(Session session, int key) throws SQLException {
        if (this.storage != null) {
            return (Row)this.storage.getRecord(session, key);
        }
        return (Row)this.rows.get(key);
    }

    public void add(Session session, Row row) throws SQLException {
        if (this.storage != null) {
            if (this.containsLargeObject) {
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    Value v = row.getValue(i);
                    Value v2 = v.link(this.database, this.getId());
                    session.unlinkAtCommitStop(v2);
                    if (v == v2) continue;
                    row.setValue(i, v2);
                }
            }
            this.storage.addRecord(session, row, -1);
        } else {
            int key;
            if (this.firstFree == -1) {
                key = this.rows.size();
                row.setPos(key);
                this.rows.add(row);
            } else {
                key = this.firstFree;
                Row free = (Row)this.rows.get(key);
                this.firstFree = free.getPos();
                row.setPos(key);
                this.rows.set(key, row);
            }
            row.setDeleted(false);
        }
        if (this.database.isMultiVersion()) {
            boolean wasDeleted;
            if (this.delta == null) {
                this.delta = new HashSet();
            }
            if (!(wasDeleted = this.delta.remove(row))) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), 1);
        }
        ++this.rowCount;
    }

    public void commit(int operation, Row row) throws SQLException {
        if (this.database.isMultiVersion()) {
            if (this.delta != null && operation == 1) {
                this.delta.remove(row);
            }
            this.incrementRowCount(row.getSessionId(), operation == 1 ? 1 : -1);
        }
    }

    private void incrementRowCount(int sessionId, int count) {
        if (this.database.isMultiVersion()) {
            Integer id = ObjectUtils.getInteger(sessionId);
            Integer c = (Integer)this.sessionRowCount.get(id);
            int current = c == null ? 0 : c;
            this.sessionRowCount.put(id, ObjectUtils.getInteger(current + count));
            this.rowCountDiff += count;
        }
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.storage != null) {
            this.storage.removeRecord(session, row.getPos());
            if (this.containsLargeObject) {
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    Value v = row.getValue(i);
                    if (!v.isLinked()) continue;
                    session.unlinkAtCommit(v);
                }
            }
        } else {
            Row free = new Row(null, 0);
            free.setPos(this.firstFree);
            int key = row.getPos();
            this.rows.set(key, free);
            this.firstFree = key;
        }
        if (this.database.isMultiVersion()) {
            boolean wasAdded;
            row.setDeleted(true);
            if (this.delta == null) {
                this.delta = new HashSet();
            }
            if (!(wasAdded = this.delta.remove(row))) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), -1);
        }
        --this.rowCount;
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) throws SQLException {
        return new ScanCursor(session, this, this.database.isMultiVersion());
    }

    public double getCost(Session session, int[] masks) throws SQLException {
        long cost = this.tableData.getRowCount(session) + 1000L;
        if (this.storage != null) {
            cost *= 10L;
        }
        return cost;
    }

    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            Integer i = (Integer)this.sessionRowCount.get(ObjectUtils.getInteger(session.getId()));
            long count = i == null ? 0L : (long)i.intValue();
            count += super.getRowCount(session);
            return count -= (long)this.rowCountDiff;
        }
        return super.getRowCount(session);
    }

    Row getNextRow(Session session, Row row) throws SQLException {
        if (this.storage == null) {
            int key = row == null ? -1 : row.getPos();
            do {
                if (++key < this.rows.size()) continue;
                return null;
            } while ((row = (Row)this.rows.get(key)).isEmpty());
            return row;
        }
        int pos = this.storage.getNext(row);
        if (pos < 0) {
            return null;
        }
        return (Row)this.storage.getRecord(session, pos);
    }

    public int getColumnIndex(Column col) {
        return -1;
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public SearchRow findFirstOrLast(Session session, boolean first) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Iterator getDelta() {
        return this.delta == null ? Collections.EMPTY_LIST.iterator() : this.delta.iterator();
    }
}

