/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.value.Value;

public class JdbcClob
extends TraceObject
implements Clob {
    private Value value;
    private JdbcConnection conn;

    public JdbcClob(SessionInterface session, JdbcConnection conn, Value value, int id) {
        this.setTrace(session.getTrace(), 10, id);
        this.conn = conn;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        long l;
        long precision;
        this.debugCodeCall("length");
        this.checkClosed();
        if (this.value.getType() == 16 && (precision = this.value.getPrecision()) > 0L) {
            return precision;
        }
        Reader in = this.value.getReader();
        try {
            int len;
            long size = 0L;
            char[] buff = new char[16];
            while ((len = in.read(buff, 0, 16)) > 0) {
                size += (long)len;
            }
            l = size;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw Message.convert(e);
            }
        }
        in.close();
        return l;
    }

    public void truncate(long len) throws SQLException {
        this.debugCodeCall("truncate", len);
        throw Message.getUnsupportedException();
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream");
            this.checkClosed();
            String s = this.value.getString();
            return IOUtils.getInputStream(s);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.debugCodeCall("setAsciiStream", pos);
        throw Message.getUnsupportedException();
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream");
            this.checkClosed();
            return this.value.getReader();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        this.debugCodeCall("setCharacterStream", pos);
        throw Message.getUnsupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long pos, int length) throws SQLException {
        try {
            this.debugCode("getSubString(" + pos + ", " + length + ");");
            this.checkClosed();
            if (pos < 1L) {
                throw Message.getInvalidValueException("pos", "" + pos);
            }
            if (length < 0) {
                throw Message.getInvalidValueException("length", "" + length);
            }
            StringBuffer buff = new StringBuffer(length);
            Reader reader = this.value.getReader();
            try {
                IOUtils.skipFully(reader, pos - 1L);
                for (int i = 0; i < length; ++i) {
                    int ch = reader.read();
                    if (ch < 0) {
                        break;
                    }
                    buff.append((char)ch);
                }
            }
            finally {
                reader.close();
            }
            return buff.toString();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int setString(long pos, String str) throws SQLException {
        this.debugCode("setString(" + pos + ", " + this.quote(str) + ");");
        throw Message.getUnsupportedException();
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.debugCode("setString(" + pos + ", " + this.quote(str) + ", " + offset + ", " + len + ");");
        throw Message.getUnsupportedException();
    }

    public long position(String pattern, long start) throws SQLException {
        this.debugCode("position(" + this.quote(pattern) + ", " + start + ");");
        throw Message.getUnsupportedException();
    }

    public long position(Clob clobPattern, long start) throws SQLException {
        this.debugCode("position(clobPattern, " + start + ");");
        throw Message.getUnsupportedException();
    }

    public void free() throws SQLException {
        this.debugCodeCall("free");
        this.value = null;
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.debugCode("getCharacterStream(" + pos + ", " + length + ");");
        throw Message.getUnsupportedException();
    }

    private void checkClosed() throws SQLException {
        this.conn.checkClosed();
        if (this.value == null) {
            throw Message.getSQLException(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.value.getSQL();
    }
}

