/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.h2.compress.CompressLZF;
import org.h2.message.Message;
import org.h2.util.MathUtils;

public class MemoryFile {
    private static final int CACHE_SIZE = 8;
    private static final int BLOCK_SIZE_SHIFT = 16;
    private static final int BLOCK_SIZE = 65536;
    private static final int BLOCK_SIZE_MASK = 65535;
    private String name;
    private final boolean compress;
    private byte[] magic;
    private long length;
    private long pos;
    private byte[][] data;
    private static final CompressLZF LZF = new CompressLZF();
    private static final byte[] BUFFER = new byte[131072];
    private static final byte[] COMPRESSED_BLOCK;
    private static final Cache COMPRESS_LATER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressLater(byte[][] data, int l) {
        CompressItem c = new CompressItem();
        c.data = data;
        c.l = l;
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            COMPRESS_LATER.put(c, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(byte[][] data, int i) {
        byte[] d = data[i];
        if (d.length == 65536) {
            return;
        }
        byte[] out = new byte[65536];
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            LZF.expand(d, 0, d.length, out, 0, 65536);
        }
        data[i] = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(byte[][] data, int i) {
        byte[] d = data[i];
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            int len = LZF.compress(d, 65536, BUFFER, 0);
            if (len <= 65536) {
                d = new byte[len];
                System.arraycopy(BUFFER, 0, d, 0, len);
                data[i] = d;
            }
        }
    }

    MemoryFile(String name, boolean compress) {
        this.name = name;
        this.compress = compress;
        this.data = new byte[0][];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long length() {
        return this.length;
    }

    public void setLength(long l) {
        if (l < this.length) {
            this.pos = Math.min(this.pos, l);
            this.changeLength(l);
            long end = MathUtils.roundUpLong(l, 65536L);
            if (end != l) {
                int lastBlock = (int)(l >>> 16);
                MemoryFile.expand(this.data, lastBlock);
                byte[] d = this.data[lastBlock];
                for (int i = (int)(l & 0xFFFFL); i < 65536; ++i) {
                    d[i] = 0;
                }
                if (this.compress) {
                    MemoryFile.compressLater(this.data, lastBlock);
                }
            }
        } else {
            this.changeLength(l);
        }
    }

    public void seek(long pos) {
        this.pos = (int)pos;
    }

    private void changeLength(long len) {
        this.length = len;
        int blocks = (int)((len = MathUtils.roundUpLong(len, 65536L)) >>> 16);
        if (blocks != this.data.length) {
            byte[][] n = new byte[blocks][];
            System.arraycopy(this.data, 0, n, 0, Math.min(this.data.length, n.length));
            for (int i = this.data.length; i < blocks; ++i) {
                n[i] = COMPRESSED_BLOCK;
            }
            this.data = n;
        }
    }

    private void readWrite(byte[] b, int off, int len, boolean write) throws SQLException {
        long end = this.pos + (long)len;
        if (end > this.length) {
            if (write) {
                this.changeLength(end);
            } else {
                if (len == 0) {
                    return;
                }
                throw Message.getSQLException(90028, "EOF");
            }
        }
        while (len > 0) {
            int l = (int)Math.min((long)len, 65536L - (this.pos & 0xFFFFL));
            int id = (int)(this.pos >>> 16);
            MemoryFile.expand(this.data, id);
            byte[] block = this.data[id];
            int blockOffset = (int)(this.pos & 0xFFFFL);
            if (write) {
                System.arraycopy(b, off, block, blockOffset, l);
            } else {
                System.arraycopy(block, blockOffset, b, off, l);
            }
            if (this.compress) {
                MemoryFile.compressLater(this.data, id);
            }
            off += l;
            this.pos += (long)l;
            len -= l;
        }
    }

    public void write(byte[] b, int off, int len) throws SQLException {
        this.readWrite(b, off, len, true);
    }

    public void readFully(byte[] b, int off, int len) throws SQLException {
        this.readWrite(b, off, len, false);
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void setMagic(byte[] magic) {
        this.magic = magic;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public void close() {
        this.pos = 0L;
    }

    public void open() {
    }

    static {
        COMPRESS_LATER = new Cache(8);
        byte[] n = new byte[65536];
        int len = LZF.compress(n, 65536, BUFFER, 0);
        COMPRESSED_BLOCK = new byte[len];
        System.arraycopy(BUFFER, 0, COMPRESSED_BLOCK, 0, len);
    }

    static class CompressItem {
        byte[][] data;
        int l;

        CompressItem() {
        }

        public int hashCode() {
            return this.data.hashCode() ^ this.l;
        }

        public boolean equals(Object o) {
            if (o instanceof CompressItem) {
                CompressItem c = (CompressItem)o;
                return c.data == this.data && c.l == this.l;
            }
            return false;
        }
    }

    static class Cache
    extends LinkedHashMap {
        private static final long serialVersionUID = 5549197956072850355L;
        private int size;

        public Cache(int size) {
            this.size = size;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            if (this.size() < this.size) {
                return false;
            }
            CompressItem c = (CompressItem)eldest.getKey();
            MemoryFile.compress(c.data, c.l);
            return true;
        }
    }
}

