/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.store.FileLister;
import org.h2.util.FileUtils;

public class DeleteDbFiles {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [-dir <dir>] [-db <database>] [-quiet]");
    }

    public static void main(String[] args) throws SQLException {
        new DeleteDbFiles().run(args);
    }

    private void run(String[] args) throws SQLException {
        String dir = ".";
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (args[i].equals("-db")) {
                db = args[++i];
                continue;
            }
            if (args[i].equals("-quiet")) {
                quiet = true;
                continue;
            }
            this.showUsage();
            return;
        }
        DeleteDbFiles.execute(dir, db, quiet);
    }

    public static void execute(String dir, String db, boolean quiet) throws SQLException {
        DeleteDbFiles delete = new DeleteDbFiles();
        ArrayList files = FileLister.getDatabaseFiles(dir, db, true);
        for (int i = 0; i < files.size(); ++i) {
            String fileName = (String)files.get(i);
            delete.process(fileName, quiet);
            if (quiet) continue;
            System.out.println("processed: " + fileName);
        }
        if (files.size() == 0 && !quiet) {
            System.out.println("No database files found");
        }
    }

    private void process(String fileName, boolean quiet) throws SQLException {
        if (quiet || fileName.endsWith(".temp.db") || fileName.endsWith(".trace.db")) {
            FileUtils.tryDelete(fileName);
        } else {
            FileUtils.delete(fileName);
        }
    }
}

