/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.store.DataPage;
import org.h2.util.CacheObject;

public abstract class Record
extends CacheObject {
    private boolean deleted;
    private int sessionId;
    private int storageId;
    private int lastLog = -1;
    private int lastPos = -1;

    public abstract int getByteCount(DataPage var1) throws SQLException;

    public void prepareWrite() throws SQLException {
    }

    public abstract void write(DataPage var1) throws SQLException;

    public boolean isEmpty() {
        return false;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void commit() {
        this.sessionId = 0;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setStorageId(int storageId) {
        this.storageId = storageId;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public void setLastLog(int log, int pos) {
        this.lastLog = log;
        this.lastPos = pos;
    }

    public void setLogWritten(int log, int pos) {
        if (log < this.lastLog) {
            return;
        }
        if (log > this.lastLog || pos >= this.lastPos) {
            this.lastLog = -1;
            this.lastPos = -1;
        }
    }

    public boolean canRemove() {
        if (this.isChanged() && !this.isLogWritten() || this.isPinned()) {
            return false;
        }
        return this.sessionId == 0;
    }

    public boolean isLogWritten() {
        return this.lastLog == -1;
    }
}

