/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.h2.engine.Session;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class CompareLike
extends Condition {
    private final CompareMode compareMode;
    private final boolean regexp;
    private Expression left;
    private Expression right;
    private Expression escape;
    private boolean isInit;
    private char[] pattern;
    private String patternString;
    private Pattern patternRegexp;
    private int[] types;
    private int patternLength;
    private static final int MATCH = 0;
    private static final int ONE = 1;
    private static final int ANY = 2;
    private boolean ignoreCase;

    public CompareLike(CompareMode compareMode, Expression left, Expression right, Expression escape, boolean regexp) {
        this.compareMode = compareMode;
        this.regexp = regexp;
        this.left = left;
        this.right = right;
        this.escape = escape;
    }

    public String getSQL() {
        String sql;
        if (this.regexp) {
            sql = this.left.getSQL() + " REGEXP " + this.right.getSQL();
        } else {
            sql = this.left.getSQL() + " LIKE " + this.right.getSQL();
            if (this.escape != null) {
                sql = sql + " ESCAPE " + this.escape.getSQL();
            }
        }
        return "(" + sql + ")";
    }

    public Expression optimize(Session session) throws SQLException {
        Value l;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.getType() == 14) {
            this.ignoreCase = true;
        }
        if (this.left.isConstant() && (l = this.left.getValue(session)) == ValueNull.INSTANCE) {
            return ValueExpression.NULL;
        }
        if (this.escape != null) {
            this.escape = this.escape.optimize(session);
        }
        if (this.right.isConstant() && (this.escape == null || this.escape.isConstant())) {
            Value e;
            if (this.left.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
            Value r = this.right.getValue(session);
            if (r == ValueNull.INSTANCE) {
                return ValueExpression.NULL;
            }
            Value value = e = this.escape == null ? null : this.escape.getValue(session);
            if (e == ValueNull.INSTANCE) {
                return ValueExpression.NULL;
            }
            String pattern = r.getString();
            this.initPattern(pattern, this.getEscapeChar(e));
            this.isInit = true;
        }
        return this;
    }

    private char getEscapeChar(Value e) throws SQLException {
        if (e == null) {
            return '\\';
        }
        String es = e.getString();
        char esc = es == null || es.length() == 0 ? (char)'\\' : es.charAt(0);
        return esc;
    }

    public void createIndexConditions(Session session, TableFilter filter) throws SQLException {
        Value e;
        if (this.regexp) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        if (!this.right.isConstant()) {
            return;
        }
        if (this.escape != null && !this.escape.isConstant()) {
            return;
        }
        String p = this.right.getValue(session).getString();
        Value value = e = this.escape == null ? null : this.escape.getValue(session);
        if (e == ValueNull.INSTANCE) {
            throw Message.getInternalError();
        }
        this.initPattern(p, this.getEscapeChar(e));
        if (this.patternLength <= 0 || this.types[0] != 0) {
            return;
        }
        int dataType = l.getColumn().getType();
        if (dataType != 13 && dataType != 14 && dataType != 21) {
            return;
        }
        int maxMatch = 0;
        StringBuffer buff = new StringBuffer();
        while (maxMatch < this.patternLength && this.types[maxMatch] == 0) {
            buff.append(this.pattern[maxMatch++]);
        }
        String begin = buff.toString();
        if (maxMatch == this.patternLength) {
            filter.addIndexCondition(new IndexCondition(0, l, ValueExpression.get(ValueString.get(begin))));
        } else if (begin.length() > 0) {
            filter.addIndexCondition(new IndexCondition(1, l, ValueExpression.get(ValueString.get(begin))));
            char next = begin.charAt(begin.length() - 1);
            for (int i = 1; i < 2000; ++i) {
                String end = begin.substring(0, begin.length() - 1) + (char)(next + i);
                if (this.compareMode.compareString(begin, end, this.ignoreCase) != -1) continue;
                filter.addIndexCondition(new IndexCondition(4, l, ValueExpression.get(ValueString.get(end))));
                break;
            }
        }
    }

    public Value getValue(Session session) throws SQLException {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return l;
        }
        if (!this.isInit) {
            Value e;
            Value r = this.right.getValue(session);
            if (r == ValueNull.INSTANCE) {
                return r;
            }
            String pattern = r.getString();
            Value value = e = this.escape == null ? null : this.escape.getValue(session);
            if (e == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            this.initPattern(pattern, this.getEscapeChar(e));
        }
        String value = l.getString();
        boolean result = this.regexp ? this.patternRegexp.matcher(value).find() : this.compareAt(value, 0, 0, value.length());
        return ValueBoolean.get(result);
    }

    private boolean compare(String s, int pi, int si) {
        return this.compareMode.compareString(this.patternString.substring(pi, pi + 1), s.substring(si, si + 1), this.ignoreCase) == 0;
    }

    private boolean compareAt(String s, int pi, int si, int sLen) {
        while (pi < this.patternLength) {
            int type = this.types[pi];
            switch (type) {
                case 0: {
                    if (si < sLen && this.compare(s, pi, si++)) break;
                    return false;
                }
                case 1: {
                    if (si++ < sLen) break;
                    return false;
                }
                case 2: {
                    if (++pi >= this.patternLength) {
                        return true;
                    }
                    while (si < sLen) {
                        if (this.compare(s, pi, si) && this.compareAt(s, pi, si, sLen)) {
                            return true;
                        }
                        ++si;
                    }
                    return false;
                }
                default: {
                    throw Message.getInternalError("type=" + type);
                }
            }
            ++pi;
        }
        return si == sLen;
    }

    public boolean test(String pattern, String value, char escape) throws SQLException {
        this.initPattern(pattern, escape);
        return this.compareAt(value, 0, 0, value.length());
    }

    private void initPattern(String p, char escape) throws SQLException {
        int i;
        if (this.regexp) {
            this.patternString = p;
            this.patternRegexp = this.ignoreCase ? Pattern.compile(p, 2) : Pattern.compile(p);
            return;
        }
        this.patternLength = 0;
        if (p == null) {
            this.types = null;
            this.pattern = null;
            return;
        }
        int len = p.length();
        this.pattern = new char[len];
        this.types = new int[len];
        boolean lastAny = false;
        for (i = 0; i < len; ++i) {
            int type;
            char c = p.charAt(i);
            if (escape == c) {
                if (i >= len - 1) {
                    throw Message.getSQLException(22025, StringUtils.addAsterisk(p, i));
                }
                if ((c = p.charAt(++i)) != '_' && c != '%' && c != escape) {
                    throw Message.getSQLException(22025, StringUtils.addAsterisk(p, i));
                }
                type = 0;
                lastAny = false;
            } else if (c == '%') {
                if (lastAny) continue;
                type = 2;
                lastAny = true;
            } else if (c == '_') {
                type = 1;
            } else {
                type = 0;
                lastAny = false;
            }
            this.types[this.patternLength] = type;
            this.pattern[this.patternLength++] = c;
        }
        for (i = 0; i < this.patternLength - 1; ++i) {
            if (this.types[i] != 2 || this.types[i + 1] != 1) continue;
            this.types[i] = 1;
            this.types[i + 1] = 2;
        }
        this.patternString = new String(this.pattern);
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        this.left.mapColumns(resolver, level);
        this.right.mapColumns(resolver, level);
        if (this.escape != null) {
            this.escape.mapColumns(resolver, level);
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
        if (this.escape != null) {
            this.escape.setEvaluatable(tableFilter, b);
        }
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
        if (this.escape != null) {
            this.escape.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor) && (this.escape == null || this.escape.isEverything(visitor));
    }

    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 3;
    }
}

