/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.i18n;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Properties;
import org.h2.tools.code.CheckTextFiles;
import org.h2.tools.indexer.HtmlConverter;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;

public class PropertiesToUTF8 {
    public static void main(String[] args) throws Exception {
        PropertiesToUTF8.convert("bin/org/h2/server/web/res", ".");
    }

    static void propertiesToTextUTF8(String source, String target) throws Exception {
        if (!new File(source).exists()) {
            return;
        }
        Properties prop = FileUtils.loadProperties(source);
        FileOutputStream out = new FileOutputStream(target);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        Enumeration<Object> en = prop.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = prop.getProperty(key, null);
            writer.println("@" + key);
            writer.println(value);
            writer.println();
        }
        writer.close();
    }

    static void textUTF8ToProperties(String source, String target) throws Exception {
        String line;
        if (!new File(source).exists()) {
            return;
        }
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(source), "UTF-8"));
        SortedProperties prop = new SortedProperties();
        StringBuffer buff = new StringBuffer();
        String key = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            if (line.startsWith("@")) {
                if (key != null) {
                    prop.setProperty(key, buff.toString());
                    buff.setLength(0);
                }
                key = line.substring(1);
                continue;
            }
            if (buff.length() > 0) {
                buff.append(System.getProperty("line.separator"));
            }
            buff.append(line);
        }
        if (key != null) {
            prop.setProperty(key, buff.toString());
        }
        PropertiesToUTF8.storeProperties(prop, target);
    }

    private static void convert(String source, String target) throws Exception {
        File[] list = new File(source).listFiles();
        for (int i = 0; list != null && i < list.length; ++i) {
            Closeable out;
            File f = list[i];
            if (!f.getName().endsWith(".properties")) continue;
            FileInputStream in = new FileInputStream(f);
            InputStreamReader r = new InputStreamReader((InputStream)in, "UTF-8");
            String s = IOUtils.readStringAndClose(r, -1);
            in.close();
            String name = f.getName();
            if (name.startsWith("utf8")) {
                s = HtmlConverter.convertStringToHtml((String)s);
                out = new RandomAccessFile(name.substring(4), "rw");
                ((RandomAccessFile)out).write(s.getBytes());
                ((RandomAccessFile)out).close();
                continue;
            }
            new CheckTextFiles().checkOrFixFile(f, false, false);
            s = HtmlConverter.convertHtmlToString((String)s);
            s = StringUtils.javaDecode(s);
            out = new FileOutputStream("utf8" + f.getName());
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
            w.write(s);
            w.close();
            ((FileOutputStream)out).close();
        }
    }

    static void storeProperties(Properties p, String fileName) throws IOException {
        String line;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        p.store(out, null);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader((InputStream)in, "ISO8859-1");
        LineNumberReader r = new LineNumberReader(reader);
        FileWriter w = new FileWriter(fileName);
        PrintWriter writer = new PrintWriter(new BufferedWriter(w));
        while ((line = r.readLine()) != null) {
            if (line.startsWith("#")) continue;
            writer.println(line);
        }
        writer.close();
    }
}

