/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.h2.command.Parser;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.MetaRecord;
import org.h2.message.Message;
import org.h2.result.SimpleRow;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.util.RandomUtils;
import org.h2.value.Value;

public class Recover
implements DataHandler {
    private String databaseName;
    private boolean textStorage;
    private int block;
    private int blockCount;
    private int storageId;
    private int recordLength;
    private int valueId;
    private boolean log;

    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [-dir <dir>] [-db <database>] [-log true]");
    }

    public static void main(String[] args) throws SQLException {
        new Recover().run(args);
    }

    private void run(String[] args) throws SQLException {
        String dir = ".";
        String db = null;
        boolean removePassword = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("-dir".equals(args[i])) {
                dir = args[++i];
                continue;
            }
            if ("-db".equals(args[i])) {
                db = args[++i];
                continue;
            }
            if ("-removePassword".equals(args[i])) {
                removePassword = true;
                continue;
            }
            if ("-log".equals(args[i])) {
                this.log = Boolean.valueOf(args[++i]);
                continue;
            }
            this.showUsage();
            return;
        }
        if (removePassword) {
            this.removePassword(dir, db);
        } else {
            this.process(dir, db);
        }
    }

    private void removePassword(String dir, String db) throws SQLException {
        ArrayList list = FileLister.getDatabaseFiles(dir, db, true);
        for (int i = 0; i < list.size(); ++i) {
            String fileName = (String)list.get(i);
            if (!fileName.endsWith(".data.db")) continue;
            this.removePassword(fileName);
        }
    }

    private void logError(String message, Throwable t) {
        System.out.println(message + ": " + t.toString());
        if (this.log) {
            t.printStackTrace();
        }
    }

    private void removePassword(String fileName) throws SQLException {
        this.databaseName = fileName.substring(fileName.length() - ".data.db".length());
        this.textStorage = Database.isTextStorage(fileName, false);
        byte[] magic = Database.getMagic(this.textStorage);
        FileStore store = FileStore.open(null, fileName, "rw", magic);
        long length = store.length();
        int offset = 48;
        int blockSize = 128;
        int blocks = (int)(length / (long)blockSize);
        this.blockCount = 1;
        for (int block = 0; block < blocks; block += this.blockCount) {
            Value[] data;
            store.seek((long)offset + (long)block * (long)blockSize);
            byte[] bytes = new byte[blockSize];
            DataPage s = DataPage.create((DataHandler)this, bytes);
            long start = store.getFilePointer();
            store.readFully(bytes, 0, blockSize);
            this.blockCount = s.readInt();
            this.storageId = -1;
            this.recordLength = -1;
            this.valueId = -1;
            if (this.blockCount == 0) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount < 0) {
                this.blockCount = 1;
                continue;
            }
            try {
                s.checkCapacity(this.blockCount * blockSize);
            }
            catch (OutOfMemoryError e) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount > 1) {
                store.readFully(s.getBytes(), blockSize, this.blockCount * blockSize - blockSize);
            }
            try {
                s.check(this.blockCount * blockSize);
            }
            catch (SQLException e) {
                this.blockCount = 1;
                continue;
            }
            this.storageId = s.readInt();
            if (this.storageId != 0) continue;
            this.recordLength = s.readInt();
            if (this.recordLength <= 0) continue;
            try {
                data = new Value[this.recordLength];
            }
            catch (Throwable e) {
                continue;
            }
            this.valueId = 0;
            while (this.valueId < this.recordLength) {
                try {
                    data[this.valueId] = s.readValue();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                ++this.valueId;
            }
            if (this.storageId != 0) continue;
            try {
                int idx;
                String sql = data[3].getString();
                if (!sql.startsWith("CREATE USER ") || (idx = sql.indexOf("SALT")) < 0) continue;
                String userName = sql.substring("CREATE USER ".length(), idx - 1);
                if (userName.startsWith("\"")) {
                    userName = userName.substring(1, userName.length() - 1);
                }
                SHA256 sha = new SHA256();
                byte[] userPasswordHash = sha.getKeyPasswordHash(userName, "".toCharArray());
                byte[] salt = RandomUtils.getSecureBytes(8);
                byte[] passwordHash = sha.getHashWithSalt(userPasswordHash, salt);
                boolean admin = sql.indexOf("ADMIN") >= 0;
                StringBuffer buff = new StringBuffer();
                buff.append("CREATE USER ");
                buff.append(Parser.quoteIdentifier(userName));
                buff.append(" SALT '");
                buff.append(ByteUtils.convertBytesToString(salt));
                buff.append("' HASH '");
                buff.append(ByteUtils.convertBytesToString(passwordHash));
                buff.append("'");
                if (admin) {
                    buff.append(" ADMIN");
                }
                byte[] replacement = buff.toString().getBytes();
                int at = ByteUtils.indexOf(s.getBytes(), "CREATE USER ".getBytes(), 0);
                System.arraycopy(replacement, 0, s.getBytes(), at, replacement.length);
                s.fill(this.blockCount * blockSize);
                s.updateChecksum();
                store.seek(start);
                store.write(s.getBytes(), 0, s.length());
                System.out.println("User: " + userName);
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.closeSilently(store);
    }

    public static void execute(String dir, String db) throws SQLException {
        new Recover().process(dir, db);
    }

    private void process(String dir, String db) throws SQLException {
        ArrayList list = FileLister.getDatabaseFiles(dir, db, true);
        for (int i = 0; i < list.size(); ++i) {
            String fileName = (String)list.get(i);
            if (fileName.endsWith(".data.db")) {
                this.dumpData(fileName);
                continue;
            }
            if (fileName.endsWith(".index.db")) {
                this.dumpIndex(fileName);
                continue;
            }
            if (fileName.endsWith(".log.db")) {
                this.dumpLog(fileName);
                continue;
            }
            if (!fileName.endsWith(".lob.db")) continue;
            this.dumpLob(fileName, true);
            this.dumpLob(fileName, false);
        }
    }

    private static PrintWriter getWriter(String fileName, String suffix) throws IOException {
        fileName = fileName.substring(0, fileName.length() - 3);
        String outputFile = fileName + suffix;
        System.out.println("Created file: " + outputFile);
        return new PrintWriter(new BufferedWriter(FileUtils.openFileWriter(outputFile, false)));
    }

    private void writeDataError(PrintWriter writer, String error, byte[] data, int dumpBlocks) throws IOException {
        int x;
        int i;
        writer.println("-- ERROR:" + error + " block:" + this.block + " blockCount:" + this.blockCount + " storageId:" + this.storageId + " recordLength: " + this.recordLength + " valueId:" + this.valueId);
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < dumpBlocks * 128; ++i) {
            x = data[i] & 0xFF;
            if (x >= 32 && x < 128) {
                sb.append((char)x);
                continue;
            }
            sb.append('?');
        }
        writer.println("-- dump: " + sb.toString());
        sb = new StringBuffer();
        for (i = 0; i < dumpBlocks * 128; ++i) {
            x = data[i] & 0xFF;
            sb.append(' ');
            if (x < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(x));
        }
        writer.println("-- dump: " + sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLob(String fileName, boolean lobCompression) {
        FileOutputStream out = null;
        FileStore store = null;
        int size = 0;
        String n = fileName + (lobCompression ? ".comp" : "") + ".txt";
        BufferedInputStream in = null;
        try {
            int l;
            out = FileUtils.openFileOutputStream(n);
            this.textStorage = Database.isTextStorage(fileName, false);
            byte[] magic = Database.getMagic(this.textStorage);
            store = FileStore.open(null, fileName, "r", magic);
            store.init();
            in = new BufferedInputStream(new FileStoreInputStream(store, this, lobCompression, false));
            byte[] buffer = new byte[4096];
            while ((l = ((InputStream)in).read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, l);
                size += l;
            }
        }
        catch (Throwable e) {
            try {
                if (this.log) {
                    this.logError(fileName, e);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeSilently(out);
                IOUtils.closeSilently(in);
                this.closeSilently(store);
            }
        }
        IOUtils.closeSilently(out);
        IOUtils.closeSilently(in);
        this.closeSilently(store);
        if (size == 0) {
            try {
                FileUtils.delete(n);
            }
            catch (SQLException e) {
                this.logError(n, e);
            }
        }
    }

    private void writeLogRecord(PrintWriter writer, DataPage s) {
        try {
            this.recordLength = s.readInt();
            if (this.recordLength <= 0) {
                this.writeDataError(writer, "recordLength<0", s.getBytes(), this.blockCount);
                return;
            }
            try {
                Value[] data = new Value[this.recordLength];
            }
            catch (OutOfMemoryError e) {
                this.writeDataError(writer, "out of memory", s.getBytes(), this.blockCount);
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("//     data: ");
            this.valueId = 0;
            while (this.valueId < this.recordLength) {
                try {
                    Value v;
                    data[this.valueId] = v = s.readValue();
                    if (this.valueId > 0) {
                        sb.append(", ");
                    }
                    sb.append(v.getSQL());
                }
                catch (Exception e) {
                    if (this.log) {
                        this.logError("log data", e);
                    }
                    this.writeDataError(writer, "exception " + e, s.getBytes(), this.blockCount);
                }
                catch (OutOfMemoryError e) {
                    this.writeDataError(writer, "out of memory", s.getBytes(), this.blockCount);
                }
                ++this.valueId;
            }
            writer.println(sb.toString());
            writer.flush();
        }
        catch (IOException e) {
            try {
                this.writeDataError(writer, "error: " + e.toString(), s.getBytes(), this.blockCount);
            }
            catch (IOException e2) {
                this.writeError(writer, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLog(String fileName) throws SQLException {
        block22: {
            int len;
            DataPage s;
            byte[] buff;
            int blocks;
            int blockSize;
            int offset;
            long length;
            FileStore store;
            PrintWriter writer;
            block21: {
                writer = null;
                store = null;
                this.databaseName = fileName.substring(fileName.length() - ".log.db".length());
                writer = Recover.getWriter(fileName, ".txt");
                this.textStorage = Database.isTextStorage(fileName, false);
                byte[] magic = Database.getMagic(this.textStorage);
                store = FileStore.open(null, fileName, "r", magic);
                length = store.length();
                writer.println("// length: " + length);
                offset = 48;
                blockSize = 16;
                blocks = (int)(length / (long)blockSize);
                buff = new byte[blockSize];
                s = DataPage.create((DataHandler)this, buff);
                s.fill(3 * blockSize);
                len = s.length();
                s.reset();
                if (length >= (long)(48 + len)) break block21;
                writer.println("// empty file");
                IOUtils.closeSilently(writer);
                this.closeSilently(store);
                return;
            }
            try {
                int pos;
                store.seek(offset);
                store.readFully(s.getBytes(), 0, len);
                int id = s.readInt();
                int firstUncommittedPos = s.readInt();
                int firstUnwrittenPos = s.readInt();
                writer.println("// id:" + id);
                writer.println("// firstUncommittedPos:" + firstUncommittedPos);
                writer.println("// firstUnwrittenPos:" + firstUnwrittenPos);
                int max = (int)(length / (long)blockSize);
                writer.println("// max:" + max);
                block14: while ((long)(pos = (int)(store.getFilePointer() / (long)blockSize)) * (long)blockSize < length) {
                    buff = new byte[blockSize];
                    store.readFully(buff, 0, blockSize);
                    s = DataPage.create((DataHandler)this, buff);
                    blocks = Math.abs(s.readInt());
                    if (blocks > 1) {
                        byte[] b2 = new byte[blocks * blockSize];
                        System.arraycopy(buff, 0, b2, 0, blockSize);
                        buff = b2;
                        try {
                            store.readFully(buff, blockSize, blocks * blockSize - blockSize);
                        }
                        catch (SQLException e) {
                            break;
                        }
                        s = DataPage.create((DataHandler)this, buff);
                        s.check(blocks * blockSize);
                    }
                    s.reset();
                    blocks = Math.abs(s.readInt());
                    if (blocks == 0) {
                        writer.println("// [" + pos + "] blocks: " + blocks + " (end)");
                        break;
                    }
                    char type = (char)s.readByte();
                    int sessionId = s.readInt();
                    if (type == 'P') {
                        String transaction = s.readString();
                        writer.println("//   prepared session:" + sessionId + " tx:" + transaction);
                        continue;
                    }
                    if (type == 'C') {
                        writer.println("//   commit session:" + sessionId);
                        continue;
                    }
                    int storageId = s.readInt();
                    int recId = s.readInt();
                    int blockCount = s.readInt();
                    if (type != 'T') {
                        s.readDataPageNoSize();
                    }
                    switch (type) {
                        case 'S': {
                            char fileType = (char)s.readByte();
                            int sumLength = s.readInt();
                            byte[] summary = new byte[sumLength];
                            if (sumLength > 0) {
                                s.read(summary, 0, sumLength);
                            }
                            writer.println("//   summary session:" + sessionId + " fileType:" + fileType + " sumLength:" + sumLength);
                            this.dumpSummary(writer, summary);
                            continue block14;
                        }
                        case 'T': {
                            writer.println("//   truncate session:" + sessionId + " storage:" + storageId + " pos:" + recId + " blockCount:" + blockCount);
                            continue block14;
                        }
                        case 'I': {
                            writer.println("//   insert session:" + sessionId + " storage:" + storageId + " pos:" + recId + " blockCount:" + blockCount);
                            this.writeLogRecord(writer, s);
                            continue block14;
                        }
                        case 'D': {
                            writer.println("//   delete session:" + sessionId + " storage:" + storageId + " pos:" + recId + " blockCount:" + blockCount);
                            this.writeLogRecord(writer, s);
                            continue block14;
                        }
                    }
                    writer.println("//   type?:" + type + " session:" + sessionId + " storage:" + storageId + " pos:" + recId + " blockCount:" + blockCount);
                }
            }
            catch (Throwable e) {
                try {
                    this.writeError(writer, e);
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.closeSilently(writer);
                    this.closeSilently(store);
                }
            }
            IOUtils.closeSilently(writer);
            this.closeSilently(store);
        }
    }

    private void dumpSummary(PrintWriter writer, byte[] summary) throws SQLException {
        if (summary == null || summary.length == 0) {
            writer.println("//     summary is empty");
            return;
        }
        try {
            int s;
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(summary));
            int b2 = in.readInt();
            for (int i = 0; i < b2 / 8; ++i) {
                int x = in.read();
                if (i % 8 == 0) {
                    writer.print("//  ");
                }
                writer.print(" " + Long.toString(i * 8) + ":");
                for (int j = 0; j < 8; ++j) {
                    writer.print((x & 1) == 1 ? "1" : "0");
                    x >>>= 1;
                }
                if (i % 8 != 7) continue;
                writer.println("");
            }
            writer.println("//");
            int len = in.readInt();
            for (int i = 0; i < len; ++i) {
                int storageId = in.readInt();
                if (storageId == -1) continue;
                writer.println("//     pos:" + i * 64 + " storage:" + storageId);
            }
            while ((s = in.readInt()) >= 0) {
                int recordCount = in.readInt();
                writer.println("//     storage:" + s + " recordCount:" + recordCount);
            }
        }
        catch (Throwable e) {
            this.writeError(writer, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpIndex(String fileName) throws SQLException {
        PrintWriter writer = null;
        FileStore store = null;
        try {
            this.databaseName = fileName.substring(fileName.length() - ".index.db".length());
            writer = Recover.getWriter(fileName, ".txt");
            this.textStorage = Database.isTextStorage(fileName, false);
            byte[] magic = Database.getMagic(this.textStorage);
            store = FileStore.open(null, fileName, "r", magic);
            long length = store.length();
            int offset = 48;
            int blockSize = 128;
            int blocks = (int)(length / (long)blockSize);
            this.blockCount = 1;
            int[] pageOwners = new int[blocks / 64];
            for (int block = 0; block < blocks; block += this.blockCount) {
                store.seek((long)offset + (long)block * (long)blockSize);
                byte[] buff = new byte[blockSize];
                DataPage s = DataPage.create((DataHandler)this, buff);
                store.readFully(buff, 0, blockSize);
                this.blockCount = s.readInt();
                this.storageId = -1;
                this.recordLength = -1;
                this.valueId = -1;
                if (this.blockCount == 0) {
                    this.blockCount = 1;
                    continue;
                }
                if (this.blockCount < 0) {
                    this.writeDataError(writer, "blockCount<0", s.getBytes(), 1);
                    this.blockCount = 1;
                    continue;
                }
                if (this.blockCount * blockSize >= 0x1FFFFFFF) {
                    this.writeDataError(writer, "blockCount=" + this.blockCount, s.getBytes(), 1);
                    this.blockCount = 1;
                    continue;
                }
                try {
                    s.checkCapacity(this.blockCount * blockSize);
                }
                catch (OutOfMemoryError e) {
                    this.writeDataError(writer, "out of memory", s.getBytes(), 1);
                    this.blockCount = 1;
                    continue;
                }
                if (this.blockCount > 1) {
                    store.readFully(s.getBytes(), blockSize, this.blockCount * blockSize - blockSize);
                }
                try {
                    s.check(this.blockCount * blockSize);
                }
                catch (SQLException e) {
                    this.writeDataError(writer, "wrong checksum", s.getBytes(), 1);
                    this.blockCount = 1;
                    continue;
                }
                this.storageId = s.readInt();
                if (this.storageId < 0) {
                    this.writeDataError(writer, "storageId<0", s.getBytes(), this.blockCount);
                    continue;
                }
                int page = block / 64;
                if (pageOwners[page] != 0 && pageOwners[page] != this.storageId) {
                    this.writeDataError(writer, "double allocation, previous=" + pageOwners[page] + " now=" + this.storageId, s.getBytes(), this.blockCount);
                } else {
                    pageOwners[page] = this.storageId;
                }
                writer.println("// [" + block + "] page:" + page + " blocks:" + this.blockCount + " storage:" + this.storageId);
            }
        }
        catch (Throwable e) {
            try {
                this.writeError(writer, e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeSilently(writer);
                this.closeSilently(store);
            }
        }
        IOUtils.closeSilently(writer);
        this.closeSilently(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpData(String fileName) throws SQLException {
        PrintWriter writer = null;
        FileStore store = null;
        try {
            this.databaseName = fileName.substring(0, fileName.length() - ".data.db".length());
            writer = Recover.getWriter(fileName, ".sql");
            ObjectArray schema = new ObjectArray();
            HashSet<Integer> objectIdSet = new HashSet<Integer>();
            HashMap<Integer, String> tableMap = new HashMap<Integer, String>();
            this.textStorage = Database.isTextStorage(fileName, false);
            byte[] magic = Database.getMagic(this.textStorage);
            store = FileStore.open(null, fileName, "r", magic);
            long length = store.length();
            int offset = 48;
            int blockSize = 128;
            int blocks = (int)(length / (long)blockSize);
            this.blockCount = 1;
            int[] pageOwners = new int[blocks / 64];
            for (int block = 0; block < blocks; block += this.blockCount) {
                StringBuffer sb;
                Value[] data;
                store.seek((long)offset + (long)block * (long)blockSize);
                byte[] buff = new byte[blockSize];
                DataPage s = DataPage.create((DataHandler)this, buff);
                store.readFully(buff, 0, blockSize);
                this.blockCount = s.readInt();
                this.storageId = -1;
                this.recordLength = -1;
                this.valueId = -1;
                if (this.blockCount == 0) {
                    this.blockCount = 1;
                    continue;
                }
                if (this.blockCount < 0) {
                    this.writeDataError(writer, "blockCount<0", s.getBytes(), 1);
                    this.blockCount = 1;
                    continue;
                }
                if (this.blockCount * blockSize >= 0x1FFFFFFF) {
                    this.writeDataError(writer, "blockCount=" + this.blockCount, s.getBytes(), 1);
                    this.blockCount = 1;
                    continue;
                }
                writer.println("-- block " + block + " - " + (block + this.blockCount - 1));
                try {
                    s.checkCapacity(this.blockCount * blockSize);
                }
                catch (OutOfMemoryError e) {
                    this.writeDataError(writer, "out of memory", s.getBytes(), 1);
                    this.blockCount = 1;
                    continue;
                }
                if (this.blockCount > 1) {
                    if (this.blockCount * blockSize < 0) {
                        this.writeDataError(writer, "wrong blockCount", s.getBytes(), 1);
                        this.blockCount = 1;
                    } else {
                        store.readFully(s.getBytes(), blockSize, this.blockCount * blockSize - blockSize);
                    }
                }
                try {
                    s.check(this.blockCount * blockSize);
                }
                catch (SQLException e) {
                    this.writeDataError(writer, "wrong checksum", s.getBytes(), 1);
                    this.blockCount = 1;
                    continue;
                }
                this.storageId = s.readInt();
                if (this.storageId < 0) {
                    this.writeDataError(writer, "storageId<0", s.getBytes(), this.blockCount);
                    continue;
                }
                int page = block / 64;
                if (pageOwners[page] != 0 && pageOwners[page] != this.storageId) {
                    this.writeDataError(writer, "double allocation, previous=" + pageOwners[page] + " now=" + this.storageId, s.getBytes(), this.blockCount);
                } else {
                    pageOwners[page] = this.storageId;
                }
                this.recordLength = s.readInt();
                if (this.recordLength <= 0) {
                    this.writeDataError(writer, "recordLength<0", s.getBytes(), this.blockCount);
                    continue;
                }
                try {
                    data = new Value[this.recordLength];
                }
                catch (OutOfMemoryError e) {
                    this.writeDataError(writer, "out of memory", s.getBytes(), this.blockCount);
                    continue;
                }
                if (!objectIdSet.contains(ObjectUtils.getInteger(this.storageId))) {
                    objectIdSet.add(ObjectUtils.getInteger(this.storageId));
                    sb = new StringBuffer();
                    sb.append("CREATE TABLE O_" + this.storageId + "(");
                    for (int i = 0; i < this.recordLength; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append("C");
                        sb.append(i);
                        sb.append(" VARCHAR");
                    }
                    sb.append(");");
                    writer.println(sb.toString());
                    writer.flush();
                }
                sb = new StringBuffer();
                sb.append("INSERT INTO O_" + this.storageId + " VALUES(");
                this.valueId = 0;
                while (this.valueId < this.recordLength) {
                    try {
                        Value v;
                        data[this.valueId] = v = s.readValue();
                        if (this.valueId > 0) {
                            sb.append(", ");
                        }
                        sb.append(v.getSQL());
                    }
                    catch (Exception e) {
                        this.writeDataError(writer, "exception " + e, s.getBytes(), this.blockCount);
                    }
                    catch (OutOfMemoryError e) {
                        this.writeDataError(writer, "out of memory", s.getBytes(), this.blockCount);
                    }
                    ++this.valueId;
                }
                sb.append(");");
                writer.println(sb.toString());
                writer.flush();
                if (this.storageId != 0) continue;
                try {
                    String sql;
                    int end;
                    SimpleRow r = new SimpleRow(data);
                    MetaRecord meta = new MetaRecord(r);
                    schema.add(meta);
                    if (meta.getObjectType() != 0 || (end = (sql = data[3].getString()).indexOf(40)) < 0) continue;
                    int start = sql.lastIndexOf(32, end);
                    String name = sql.substring(start, end).trim();
                    tableMap.put(ObjectUtils.getInteger(meta.getId()), name);
                    continue;
                }
                catch (Throwable t) {
                    this.writeError(writer, t);
                }
            }
            MetaRecord.sort(schema);
            for (int i = 0; i < schema.size(); ++i) {
                MetaRecord m = (MetaRecord)schema.get(i);
                writer.println(m.getSQL() + ";");
            }
            Iterator it = tableMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Integer objectId = (Integer)entry.getKey();
                String name = (String)entry.getValue();
                writer.println("INSERT INTO " + name + " SELECT * FROM O_" + objectId + ";");
            }
            it = objectIdSet.iterator();
            while (it.hasNext()) {
                Integer objectId = (Integer)((Object)it.next());
                writer.println("DROP TABLE O_" + objectId + ";");
            }
        }
        catch (Throwable e) {
            try {
                this.writeError(writer, e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeSilently(writer);
                this.closeSilently(store);
            }
        }
        IOUtils.closeSilently(writer);
        this.closeSilently(store);
    }

    private void closeSilently(FileStore store) {
        if (store != null) {
            store.closeSilently();
            store = null;
        }
    }

    private void writeError(PrintWriter writer, Throwable e) {
        if (writer != null) {
            writer.println("// error: " + e);
        }
        this.logError("Error", e);
    }

    public boolean getTextStorage() {
        return this.textStorage;
    }

    public String getDatabasePath() {
        return this.databaseName;
    }

    public FileStore openFile(String name, String mode, boolean mustExist) throws SQLException {
        return FileStore.open(this, name, "rw", Constants.MAGIC_FILE_HEADER.getBytes());
    }

    public int getChecksum(byte[] data, int start, int end) {
        int x = 0;
        while (start < end) {
            x += data[start++];
        }
        return x;
    }

    public void checkPowerOff() throws SQLException {
    }

    public void checkWritingAllowed() throws SQLException {
    }

    public void freeUpDiskSpace() throws SQLException {
    }

    public void handleInvalidChecksum() throws SQLException {
        throw new SQLException("Invalid Checksum");
    }

    public int compareTypeSave(Value a, Value b) throws SQLException {
        throw Message.getInternalError();
    }

    public int getMaxLengthInplaceLob() {
        throw Message.getInternalError();
    }

    public int allocateObjectId(boolean b, boolean c) {
        throw Message.getInternalError();
    }

    public String createTempFile() throws SQLException {
        throw Message.getInternalError();
    }

    public String getLobCompressionAlgorithm(int type) {
        return null;
    }

    public Object getLobSyncObject() {
        return this;
    }
}

