/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Comparator;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.log.LogSystem;
import org.h2.log.RedoLogRecord;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DataPageText;
import org.h2.store.FileStore;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.store.Storage;
import org.h2.util.BitField;
import org.h2.util.Cache;
import org.h2.util.Cache2Q;
import org.h2.util.CacheLRU;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.FileUtils;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;

public class DiskFile
implements CacheWriter {
    public static final int BLOCK_SIZE = 128;
    static final int BLOCK_PAGE_PAGE_SHIFT = 6;
    public static final int BLOCKS_PER_PAGE = 64;
    public static final int OFFSET = 48;
    private Database database;
    private String fileName;
    private FileStore file;
    private BitField used;
    private BitField deleted;
    private int fileBlockCount;
    private IntArray pageOwners;
    private Cache cache;
    private LogSystem log;
    private DataPage rowBuff;
    private DataPage freeBlock;
    private boolean dataFile;
    private boolean logChanges;
    private int recordOverhead;
    private boolean init;
    private boolean initAlreadyTried;
    private ObjectArray redoBuffer;
    private int redoBufferSize;
    private int readCount;
    private int writeCount;
    private String mode;

    public DiskFile(Database database, String fileName, String mode, boolean dataFile, boolean logChanges, int cacheSize) throws SQLException {
        this.reset();
        this.database = database;
        this.log = database.getLog();
        this.fileName = fileName;
        this.mode = mode;
        this.dataFile = dataFile;
        this.logChanges = logChanges;
        String cacheType = database.getCacheType();
        this.cache = "TQ".equals(cacheType) ? new Cache2Q(this, cacheSize) : new CacheLRU(this, cacheSize);
        this.rowBuff = DataPage.create((DataHandler)database, 128);
        this.recordOverhead = 4 * this.rowBuff.getIntLen() + 1 + this.rowBuff.getFillerLength();
        this.freeBlock = DataPage.create((DataHandler)database, 128);
        this.freeBlock.fill(128);
        this.freeBlock.updateChecksum();
        try {
            if (FileUtils.exists(fileName)) {
                this.file = database.openFile(fileName, mode, true);
                long length = this.file.length();
                database.notifyFileSize(length);
                int blocks = (int)((length - 48L) / 128L);
                this.setBlockCount(blocks);
            } else {
                this.create();
            }
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
    }

    private void reset() {
        this.used = new BitField();
        this.deleted = new BitField();
        this.pageOwners = new IntArray();
        this.setBlockCount(this.fileBlockCount);
        this.redoBuffer = new ObjectArray();
    }

    private void setBlockCount(int count) {
        this.fileBlockCount = count;
        int pages = this.getPage(count);
        while (pages >= this.pageOwners.size()) {
            this.pageOwners.add(-1);
        }
    }

    int getBlockCount() {
        return this.fileBlockCount;
    }

    private void create() throws SQLException {
        this.file = this.database.openFile(this.fileName, this.mode, false);
        DataPage header = DataPage.create((DataHandler)this.database, 48);
        this.file.seek(48L);
        header.fill(48);
        header.updateChecksum();
        this.file.write(header.getBytes(), 0, 48);
    }

    private void freeUnusedPages() throws SQLException {
        for (int i = 0; i < this.pageOwners.size(); ++i) {
            if (this.pageOwners.get(i) == -1 || !this.isPageFree(i)) continue;
            this.setPageOwner(i, -1);
        }
    }

    public synchronized byte[] getSummary() throws SQLException {
        try {
            int i;
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(buff);
            int blocks = (int)((this.file.length() - 48L) / 128L);
            out.writeInt(blocks);
            int x = 0;
            for (int i2 = 0; i2 < blocks / 8; ++i2) {
                int mask = 0;
                for (int j = 0; j < 8; ++j) {
                    if (this.used.get(x)) {
                        mask |= 1 << j;
                    }
                    ++x;
                }
                out.write(mask);
            }
            out.writeInt(this.pageOwners.size());
            ObjectArray storages = new ObjectArray();
            for (i = 0; i < this.pageOwners.size(); ++i) {
                int s = this.pageOwners.get(i);
                out.writeInt(s);
                if (s < 0 || s < storages.size() && storages.get(s) != null) continue;
                Storage storage = this.database.getStorage(s, this);
                while (storages.size() <= s) {
                    storages.add(null);
                }
                storages.set(s, storage);
            }
            for (i = 0; i < storages.size(); ++i) {
                Storage storage = (Storage)storages.get(i);
                if (storage == null) continue;
                out.writeInt(i);
                out.writeInt(storage.getRecordCount());
            }
            out.writeInt(-1);
            out.close();
            byte[] b2 = buff.toByteArray();
            return b2;
        }
        catch (IOException e) {
            return null;
        }
    }

    boolean isPageFree(int page) {
        for (int i = page * 64; i < (page + 1) * 64; ++i) {
            if (!this.used.get(i)) continue;
            return false;
        }
        return true;
    }

    public synchronized void initFromSummary(byte[] summary) {
        if (summary == null || summary.length == 0) {
            ObjectArray list = this.database.getAllStorages();
            for (int i = 0; i < list.size(); ++i) {
                Storage s = (Storage)list.get(i);
                if (s == null || s.getDiskFile() != this) continue;
                this.database.removeStorage(s.getId(), this);
            }
            this.reset();
            this.initAlreadyTried = false;
            this.init = false;
            return;
        }
        if (this.database.getRecovery() || this.initAlreadyTried) {
            return;
        }
        this.initAlreadyTried = true;
        int stage = 0;
        try {
            int s;
            Storage storage;
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(summary));
            int b2 = in.readInt();
            if (b2 > this.fileBlockCount) {
                this.database.getTrace("database").info("unexpected size " + b2 + " when initializing summary for " + this.fileName + " expected:" + this.fileBlockCount);
                return;
            }
            ++stage;
            int x = 0;
            for (int i = 0; i < b2 / 8; ++i) {
                int mask = in.read();
                for (int j = 0; j < 8; ++j) {
                    if ((mask & 1 << j) != 0) {
                        this.used.set(x);
                    }
                    ++x;
                }
            }
            ++stage;
            int len = in.readInt();
            ObjectArray storages = new ObjectArray();
            for (int i = 0; i < len; ++i) {
                int s2 = in.readInt();
                if (s2 >= 0) {
                    storage = this.database.getStorage(s2, this);
                    while (storages.size() <= s2) {
                        storages.add(null);
                    }
                    storages.set(s2, storage);
                    storage.addPage(i);
                }
                this.setPageOwner(i, s2);
            }
            ++stage;
            while ((s = in.readInt()) >= 0) {
                int recordCount = in.readInt();
                storage = (Storage)storages.get(s);
                storage.setRecordCount(recordCount);
            }
            ++stage;
            this.freeUnusedPages();
            this.init = true;
        }
        catch (Exception e) {
            this.database.getTrace("database").error("error initializing summary for " + this.fileName + " size:" + summary.length + " stage:" + stage, e);
        }
    }

    public synchronized void init() throws SQLException {
        if (this.init) {
            return;
        }
        ObjectArray storages = this.database.getAllStorages();
        for (int i = 0; i < storages.size(); ++i) {
            Storage s = (Storage)storages.get(i);
            if (s == null || s.getDiskFile() != this) continue;
            s.setRecordCount(0);
        }
        int blockHeaderLen = Math.max(16, 2 * this.rowBuff.getIntLen());
        byte[] buff = new byte[blockHeaderLen];
        DataPage s = DataPage.create((DataHandler)this.database, buff);
        long time = 0L;
        int i = 0;
        while (i < this.fileBlockCount) {
            long t2 = System.currentTimeMillis();
            if (t2 > time + 10L) {
                time = t2;
                this.database.setProgress(0, this.fileName, i, this.fileBlockCount);
            }
            this.go(i);
            this.file.readFully(buff, 0, blockHeaderLen);
            s.reset();
            int blockCount = s.readInt();
            if (SysProperties.CHECK && blockCount < 0) {
                throw Message.getInternalError();
            }
            if (blockCount == 0) {
                this.setUnused(i, 1);
                ++i;
                continue;
            }
            int id = s.readInt();
            if (SysProperties.CHECK && id < 0) {
                throw Message.getInternalError();
            }
            Storage storage = this.database.getStorage(id, this);
            this.setBlockOwner(storage, i, blockCount, true);
            storage.incrementRecordCount();
            i += blockCount;
        }
        this.database.setProgress(0, this.fileName, this.fileBlockCount, this.fileBlockCount);
        this.init = true;
    }

    public synchronized void flush() throws SQLException {
        int i;
        this.database.checkPowerOff();
        ObjectArray list = this.cache.getAllChanged();
        CacheObject.sort(list);
        for (i = 0; i < list.size(); ++i) {
            Record rec = (Record)list.get(i);
            this.writeBack(rec);
        }
        for (i = 0; i < this.fileBlockCount && (i = this.deleted.nextSetBit(i)) >= 0; ++i) {
            if (!this.deleted.get(i)) continue;
            this.writeDirectDeleted(i, 1);
            this.deleted.clear(i);
        }
    }

    public synchronized void close() throws SQLException {
        SQLException closeException = null;
        if (!this.database.getReadOnly()) {
            try {
                this.flush();
            }
            catch (SQLException e) {
                closeException = e;
            }
        }
        this.cache.clear();
        if (this.file != null) {
            this.file.closeSilently();
            this.file = null;
        }
        if (closeException != null) {
            throw closeException;
        }
        this.writeCount = 0;
        this.readCount = 0;
    }

    private void go(int block) throws SQLException {
        this.file.seek(this.getFilePos(block));
    }

    private long getFilePos(int block) {
        return (long)block * 128L + 48L;
    }

    synchronized Record getRecordIfStored(Session session, int pos, RecordReader reader, int storageId) throws SQLException {
        try {
            int owner = this.getPageOwner(this.getPage(pos));
            if (owner != storageId) {
                return null;
            }
            this.go(pos);
            this.rowBuff.reset();
            byte[] buff = this.rowBuff.getBytes();
            this.file.readFully(buff, 0, 128);
            DataPage s = DataPage.create((DataHandler)this.database, buff);
            s.readInt();
            int id = s.readInt();
            if (id != storageId) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.getRecord(session, pos, reader, storageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Record getRecord(Session session, int pos, RecordReader reader, int storageId) throws SQLException {
        if (this.file == null) {
            throw Message.getSQLException(90098);
        }
        DiskFile diskFile = this;
        synchronized (diskFile) {
            Record record = (Record)this.cache.get(pos);
            if (record != null) {
                return record;
            }
            ++this.readCount;
            this.go(pos);
            this.rowBuff.reset();
            byte[] buff = this.rowBuff.getBytes();
            this.file.readFully(buff, 0, 128);
            DataPage s = DataPage.create((DataHandler)this.database, buff);
            int blockCount = s.readInt();
            int id = s.readInt();
            if (SysProperties.CHECK && storageId != id) {
                throw Message.getInternalError("File ID mismatch got=" + id + " expected=" + storageId + " pos=" + pos + " " + this.logChanges + " " + this + " blockCount:" + blockCount);
            }
            if (SysProperties.CHECK && blockCount == 0) {
                throw Message.getInternalError("0 blocks to read pos=" + pos);
            }
            if (blockCount > 1) {
                byte[] b2 = new byte[blockCount * 128];
                System.arraycopy(buff, 0, b2, 0, 128);
                buff = b2;
                this.file.readFully(buff, 128, blockCount * 128 - 128);
                s = DataPage.create((DataHandler)this.database, buff);
                s.readInt();
                s.readInt();
            }
            s.check(blockCount * 128);
            Record r = reader.read(session, s);
            r.setStorageId(storageId);
            r.setPos(pos);
            r.setBlockCount(blockCount);
            this.cache.put(r);
            return r;
        }
    }

    synchronized int allocate(Storage storage, int blockCount) throws SQLException {
        int i;
        if (this.file == null) {
            throw Message.getSQLException(90098);
        }
        blockCount = this.getPage(blockCount + 64 - 1) * 64;
        int lastPage = this.getPage(this.getBlockCount());
        int pageCount = this.getPage(blockCount);
        int pos = -1;
        boolean found = false;
        for (i = 0; i < lastPage; ++i) {
            found = true;
            for (int j = i; j < i + pageCount; ++j) {
                if (j < lastPage && this.getPageOwner(j) == -1) continue;
                found = false;
                break;
            }
            if (!found) continue;
            pos = i * 64;
            break;
        }
        if (!found) {
            int max = this.getBlockCount();
            pos = MathUtils.roundUp(max, 64);
            if (this.rowBuff instanceof DataPageText) {
                if (pos > max) {
                    this.writeDirectDeleted(max, pos - max);
                }
                this.writeDirectDeleted(pos, blockCount);
            } else {
                long min = ((long)pos + (long)blockCount) * 128L;
                if ((min = MathUtils.scaleUp50Percent(131072L, min, 8192L, 0x2000000L) + 48L) > this.file.length()) {
                    this.file.setLength(min);
                    this.database.notifyFileSize(min);
                }
            }
        }
        this.setBlockOwner(storage, pos, blockCount, false);
        for (i = 0; i < blockCount; ++i) {
            storage.free(i + pos, 1);
        }
        return pos;
    }

    private void setBlockOwner(Storage storage, int pos, int blockCount, boolean inUse) throws SQLException {
        if (pos + blockCount > this.fileBlockCount) {
            this.setBlockCount(pos + blockCount);
        }
        if (!inUse) {
            this.setUnused(pos, blockCount);
        }
        for (int i = this.getPage(pos); i <= this.getPage(pos + blockCount - 1); ++i) {
            this.setPageOwner(i, storage.getId());
        }
        if (inUse) {
            this.used.setRange(pos, blockCount, true);
            this.deleted.setRange(pos, blockCount, false);
        }
    }

    private void setUnused(int pos, int blockCount) throws SQLException {
        if (pos + blockCount > this.fileBlockCount) {
            this.setBlockCount(pos + blockCount);
        }
        for (int i = pos; i < pos + blockCount; ++i) {
            this.used.clear(i);
            if (i % 64 != 0 || pos + blockCount < i + 64) continue;
            this.setPageOwner(this.getPage(i), -1);
        }
    }

    int getPage(int pos) {
        return pos >>> 6;
    }

    int getPageOwner(int page) {
        if (page * 64 > this.fileBlockCount || page >= this.pageOwners.size()) {
            return -1;
        }
        return this.pageOwners.get(page);
    }

    public void setPageOwner(int page, int storageId) throws SQLException {
        int old = this.pageOwners.get(page);
        if (old == storageId) {
            return;
        }
        if (SysProperties.CHECK && old >= 0 && storageId >= 0 && old != storageId) {
            for (int i = 0; i < 64; ++i) {
                if (!this.used.get(i + page * 64)) continue;
                throw Message.getInternalError("double allocation");
            }
        }
        if (old >= 0) {
            this.database.getStorage(old, this).removePage(page);
            if (!this.logChanges) {
                this.writeDirectDeleted(page * 64, 64);
            }
        }
        if (storageId >= 0) {
            this.database.getStorage(storageId, this).addPage(page);
        }
        this.pageOwners.set(page, storageId);
    }

    synchronized void setUsed(int pos, int blockCount) {
        if (pos + blockCount > this.fileBlockCount) {
            this.setBlockCount(pos + blockCount);
        }
        this.used.setRange(pos, blockCount, true);
        this.deleted.setRange(pos, blockCount, false);
    }

    public synchronized void delete() throws SQLException {
        try {
            this.cache.clear();
            this.file.close();
            FileUtils.delete(this.fileName);
        }
        catch (IOException e) {
            throw Message.convertIOException(e, this.fileName);
        }
        finally {
            this.file = null;
            this.fileName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeBack(CacheObject obj) throws SQLException {
        ++this.writeCount;
        Record record = (Record)obj;
        DiskFile diskFile = this;
        synchronized (diskFile) {
            int blockCount = record.getBlockCount();
            record.prepareWrite();
            this.go(record.getPos());
            DataPage buff = this.rowBuff;
            buff.reset();
            buff.checkCapacity(blockCount * 128);
            buff.writeInt(blockCount);
            buff.writeInt(record.getStorageId());
            record.write(buff);
            buff.fill(blockCount * 128);
            buff.updateChecksum();
            this.file.write(buff.getBytes(), 0, buff.length());
        }
        record.setChanged(false);
    }

    BitField getUsed() {
        return this.used;
    }

    synchronized void updateRecord(Session session, Record record) throws SQLException {
        record.setChanged(true);
        int pos = record.getPos();
        Record old = (Record)this.cache.update(pos, record);
        if (SysProperties.CHECK && old != null) {
            if (old != record) {
                this.database.checkPowerOff();
                throw Message.getInternalError("old != record old=" + old + " new=" + record);
            }
            int blockCount = record.getBlockCount();
            for (int i = 0; i < blockCount; ++i) {
                if (!this.deleted.get(i + pos)) continue;
                throw Message.getInternalError("update marked as deleted: " + (i + pos));
            }
        }
        if (this.logChanges) {
            this.log.add(session, this, record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void writeDirectDeleted(int recordId, int blockCount) throws SQLException {
        DiskFile diskFile = this;
        synchronized (diskFile) {
            this.go(recordId);
            for (int i = 0; i < blockCount; ++i) {
                this.file.write(this.freeBlock.getBytes(), 0, this.freeBlock.length());
            }
            this.free(recordId, blockCount);
        }
    }

    synchronized void writeDirect(Storage storage, int pos, byte[] data, int offset) throws SQLException {
        this.go(pos);
        this.file.write(data, offset, 128);
        this.setBlockOwner(storage, pos, 1, true);
    }

    public synchronized int copyDirect(int pos, OutputStream out) throws SQLException {
        try {
            if (pos < 0) {
                byte[] buffer = new byte[48];
                this.file.seek(0L);
                this.file.readFullyDirect(buffer, 0, 48);
                out.write(buffer);
                return 0;
            }
            if (pos >= this.fileBlockCount) {
                return -1;
            }
            int blockSize = 128;
            byte[] buff = new byte[blockSize];
            DataPage s = DataPage.create((DataHandler)this.database, buff);
            this.database.setProgress(3, this.fileName, pos, this.fileBlockCount);
            this.go(pos);
            this.file.readFully(buff, 0, blockSize);
            s.reset();
            int blockCount = s.readInt();
            if (SysProperties.CHECK && blockCount < 0) {
                throw Message.getInternalError();
            }
            if (blockCount == 0) {
                blockCount = 1;
            }
            int id = s.readInt();
            if (SysProperties.CHECK && id < 0) {
                throw Message.getInternalError();
            }
            s.checkCapacity(blockCount * blockSize);
            if (blockCount > 1) {
                this.file.readFully(s.getBytes(), blockSize, blockCount * blockSize - blockSize);
            }
            if (this.file.isEncrypted()) {
                s.reset();
                this.go(pos);
                this.file.readFullyDirect(s.getBytes(), 0, blockCount * blockSize);
            }
            out.write(s.getBytes(), 0, blockCount * blockSize);
            return pos + blockCount;
        }
        catch (IOException e) {
            throw Message.convertIOException(e, this.fileName);
        }
    }

    synchronized void removeRecord(Session session, int pos, Record record, int blockCount) throws SQLException {
        if (this.logChanges) {
            this.log.add(session, this, record);
        }
        this.cache.remove(pos);
        this.deleted.setRange(pos, blockCount, true);
        this.setUnused(pos, blockCount);
    }

    synchronized void addRecord(Session session, Record record) throws SQLException {
        if (this.logChanges) {
            this.log.add(session, this, record);
        }
        this.cache.put(record);
    }

    public Cache getCache() {
        return this.cache;
    }

    synchronized void free(int pos, int blockCount) {
        this.used.setRange(pos, blockCount, false);
    }

    public int getRecordOverhead() {
        return this.recordOverhead;
    }

    public synchronized void truncateStorage(Session session, Storage storage, IntArray pages) throws SQLException {
        int storageId = storage.getId();
        ObjectArray list = this.cache.getAllChanged();
        for (int i = 0; i < list.size(); ++i) {
            Record r = (Record)list.get(i);
            if (r.getStorageId() != storageId) continue;
            r.setChanged(false);
        }
        int[] pagesCopy = new int[pages.size()];
        pages.toArray(pagesCopy);
        for (int i = 0; i < pagesCopy.length; ++i) {
            int page = pagesCopy[i];
            if (this.logChanges) {
                this.log.addTruncate(session, this, storageId, page * 64, 64);
            }
            for (int j = 0; j < 64; ++j) {
                Record r = (Record)this.cache.find(page * 64 + j);
                if (r == null) continue;
                this.cache.remove(r.getPos());
            }
            this.deleted.setRange(page * 64, 64, true);
            this.setUnused(page * 64, 64);
        }
    }

    public synchronized void sync() {
        if (this.file != null) {
            this.file.sync();
        }
    }

    public boolean isDataFile() {
        return this.dataFile;
    }

    public synchronized void setLogChanges(boolean b) {
        this.logChanges = b;
    }

    public synchronized void addRedoLog(Storage storage, int recordId, int blockCount, DataPage rec) throws SQLException {
        byte[] data = null;
        if (rec != null) {
            DataPage all = this.rowBuff;
            all.reset();
            all.writeInt(blockCount);
            all.writeInt(storage.getId());
            all.writeDataPageNoSize(rec);
            all.fill(blockCount * 128);
            all.updateChecksum();
            if (SysProperties.CHECK && all.length() != 128 * blockCount) {
                throw Message.getInternalError("blockCount:" + blockCount + " length: " + all.length() * 128);
            }
            data = new byte[all.length()];
            System.arraycopy(all.getBytes(), 0, data, 0, all.length());
        }
        for (int i = 0; i < blockCount; ++i) {
            RedoLogRecord log = new RedoLogRecord();
            log.recordId = recordId + i;
            log.offset = i * 128;
            log.storage = storage;
            log.data = data;
            log.sequenceId = this.redoBuffer.size();
            this.redoBuffer.add(log);
            this.redoBufferSize += log.getSize();
        }
        if (this.redoBufferSize > SysProperties.REDO_BUFFER_SIZE) {
            this.flushRedoLog();
        }
    }

    public synchronized void flushRedoLog() throws SQLException {
        if (this.redoBuffer.size() == 0) {
            return;
        }
        this.redoBuffer.sort(new Comparator(){

            public int compare(Object o1, Object o2) {
                RedoLogRecord e1 = (RedoLogRecord)o1;
                RedoLogRecord e2 = (RedoLogRecord)o2;
                int comp = e1.recordId - e2.recordId;
                if (comp == 0) {
                    comp = e1.sequenceId - e2.sequenceId;
                }
                return comp;
            }
        });
        RedoLogRecord last = null;
        for (int i = 0; i < this.redoBuffer.size(); ++i) {
            RedoLogRecord entry = (RedoLogRecord)this.redoBuffer.get(i);
            if (last != null && entry.recordId != last.recordId) {
                this.writeRedoLog(last);
            }
            last = entry;
        }
        if (last != null) {
            this.writeRedoLog(last);
        }
        this.redoBuffer.clear();
        this.redoBufferSize = 0;
    }

    private void writeRedoLog(RedoLogRecord entry) throws SQLException {
        if (entry.data == null) {
            this.writeDirectDeleted(entry.recordId, 1);
        } else {
            this.writeDirect(entry.storage, entry.recordId, entry.data, entry.offset);
        }
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public void flushLog() throws SQLException {
        if (this.log != null) {
            this.log.flush();
        }
    }
}

