/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.Message;
import org.h2.schema.Sequence;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public class SequenceValue
extends Expression {
    private Sequence sequence;

    public SequenceValue(Sequence sequence) {
        this.sequence = sequence;
    }

    public Value getValue(Session session) throws SQLException {
        long value = this.sequence.getNext();
        session.setLastIdentity(ValueLong.get(value));
        return ValueLong.get(value);
    }

    public int getType() {
        return 5;
    }

    public void mapColumns(ColumnResolver resolver, int level) {
    }

    public void checkMapped() {
    }

    public Expression optimize(Session session) {
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
    }

    public int getScale() {
        return 0;
    }

    public long getPrecision() {
        return 10L;
    }

    public String getSQL() {
        return "(NEXT VALUE FOR " + this.sequence.getSQL() + ")";
    }

    public void updateAggregate(Session session) {
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.type) {
            case 1: {
                return true;
            }
            case 2: 
            case 5: {
                return false;
            }
            case 0: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                visitor.addDataModificationId(this.sequence.getModificationId());
                return true;
            }
            case 6: {
                return true;
            }
        }
        throw Message.getInternalError("type=" + visitor.type);
    }

    public int getCost() {
        return 1;
    }
}

