/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.StringUtils;

public class Comment
extends DbObjectBase {
    private final int objectType;
    private final String objectName;
    private String commentText;

    public Comment(Database database, int id, DbObject obj) {
        super(database, id, Comment.getKey(obj), "database");
        this.objectType = obj.getType();
        this.objectName = obj.getSQL();
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw Message.getInternalError();
    }

    private static String getTypeName(int type) {
        switch (type) {
            case 11: {
                return "CONSTANT";
            }
            case 5: {
                return "CONSTRAINT";
            }
            case 9: {
                return "ALIAS";
            }
            case 1: {
                return "INDEX";
            }
            case 7: {
                return "ROLE";
            }
            case 10: {
                return "SCHEMA";
            }
            case 3: {
                return "SEQUENCE";
            }
            case 0: {
                return "TABLE";
            }
            case 4: {
                return "TRIGGER";
            }
            case 2: {
                return "USER";
            }
            case 12: {
                return "DOMAIN";
            }
        }
        return "type" + type;
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("COMMENT ON ");
        buff.append(Comment.getTypeName(this.objectType));
        buff.append(' ');
        buff.append(this.objectName);
        buff.append(" IS ");
        if (this.commentText == null) {
            buff.append("NULL");
        } else {
            buff.append(StringUtils.quoteStringSQL(this.commentText));
        }
        return buff.toString();
    }

    public int getType() {
        return 13;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
    }

    public void checkRename() throws SQLException {
        throw Message.getInternalError();
    }

    public static String getKey(DbObject obj) {
        return Comment.getTypeName(obj.getType()) + " " + obj.getSQL();
    }

    public void setCommentText(String comment) {
        this.commentText = comment;
    }
}

