/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.log.LogFile;
import org.h2.log.LogSystem;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.store.DiskFile;
import org.h2.store.FileLister;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.ObjectArray;

public class BackupCommand
extends Prepared {
    private String fileName;

    public BackupCommand(Session session) {
        super(session);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.backupTo(this.fileName);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String fileName) throws SQLException {
        Database db = this.session.getDatabase();
        if (!db.isPersistent()) {
            throw Message.getSQLException(90126);
        }
        try {
            String name = db.getName();
            name = FileUtils.getFileName(name);
            FileOutputStream zip = FileUtils.openFileOutputStream(fileName);
            ZipOutputStream out = new ZipOutputStream(zip);
            LogSystem log = db.getLog();
            try {
                log.flush();
                log.updateKeepFiles(1);
                String fn = db.getName() + ".data.db";
                this.backupDiskFile(out, fn, db.getDataFile());
                fn = db.getName() + ".index.db";
                String base = FileUtils.getParent(fn);
                this.backupDiskFile(out, fn, db.getIndexFile());
                ObjectArray list = log.getActiveLogFiles();
                int max = list.size();
                Object object = db.getLobSyncObject();
                synchronized (object) {
                    for (int i = 0; i < list.size(); ++i) {
                        LogFile lf = (LogFile)list.get(i);
                        fn = lf.getFileName();
                        this.backupFile(out, base, fn);
                        db.setProgress(3, name, i, max);
                    }
                    String prefix = db.getDatabasePath();
                    String dir = FileUtils.getParent(prefix);
                    ArrayList fileList = FileLister.getDatabaseFiles(dir, name, true);
                    for (int i = 0; i < fileList.size(); ++i) {
                        fn = (String)fileList.get(i);
                        if (!fn.endsWith(".hash.db") && !fn.endsWith(".lob.db")) continue;
                        this.backupFile(out, base, fn);
                    }
                }
                out.close();
                ((OutputStream)zip).close();
            }
            finally {
                log.updateKeepFiles(-1);
            }
        }
        catch (IOException e) {
            throw Message.convertIOException(e, fileName);
        }
    }

    private void backupDiskFile(ZipOutputStream out, String fileName, DiskFile file) throws SQLException, IOException {
        Database db = this.session.getDatabase();
        fileName = FileUtils.getFileName(fileName);
        out.putNextEntry(new ZipEntry(fileName));
        int pos = -1;
        int max = file.getReadCount();
        while ((pos = file.copyDirect(pos, out)) >= 0) {
            db.setProgress(3, fileName, pos, max);
        }
        out.closeEntry();
    }

    private void backupFile(ZipOutputStream out, String base, String fn) throws SQLException, IOException {
        String f = FileUtils.getAbsolutePath(fn);
        if (!f.startsWith(base = FileUtils.getAbsolutePath(base))) {
            throw Message.getInternalError(f + " does not start with " + base);
        }
        f = f.substring(base.length());
        out.putNextEntry(new ZipEntry(f));
        FileInputStream in = FileUtils.openFileInputStream(fn);
        IOUtils.copyAndCloseInput(in, out);
        out.closeEntry();
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean needRecompile() {
        return false;
    }

    public LocalResult queryMeta() {
        return null;
    }
}

