/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.h2.Driver;
import org.h2.constant.SysProperties;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.WebSession;
import org.h2.server.web.WebThread;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.RandomUtils;
import org.h2.util.Resources;
import org.h2.util.SortedProperties;

public class WebServer
implements Service {
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String[][] LANGUAGES = new String[][]{{"en", "English"}, {"de", "Deutsch"}, {"fr", "Fran\u00e7ais"}, {"es", "Espa\u00f1ol"}, {"zh_CN", "\u4e2d\u6587"}, {"ja", "\u65e5\u672c\u8a9e"}, {"hu", "Magyar"}, {"in", "Indonesia"}, {"pt_PT", "Portugu\u00eas (Europeu)"}, {"pl", "Polski"}};
    private static final String[] GENERIC = new String[]{"Generic JNDI Data Source|javax.naming.InitialContext|java:comp/env/jdbc/Test|sa", "Generic Firebird Server|org.firebirdsql.jdbc.FBDriver|jdbc:firebirdsql:localhost:c:/temp/firebird/test|sysdba", "Generic OneDollarDB|in.co.daffodil.db.jdbc.DaffodilDBDriver|jdbc:daffodilDB_embedded:school;path=C:/temp;create=true|sa", "Generic DB2|COM.ibm.db2.jdbc.net.DB2Driver|jdbc:db2://<host>/<db>|", "Generic Oracle|oracle.jdbc.driver.OracleDriver|jdbc:oracle:thin:@<host>:1521:<instance>|scott", "Generic PostgreSQL|org.postgresql.Driver|jdbc:postgresql:<db>|", "Generic MS SQL Server|com.microsoft.jdbc.sqlserver.SQLServerDriver|jdbc:Microsoft:sqlserver://localhost:1433;DatabaseName=sqlexpress|sa", "Generic MS SQL Server 2005|com.microsoft.sqlserver.jdbc.SQLServerDriver|jdbc:sqlserver://localhost;DatabaseName=test|sa", "Generic MySQL|com.mysql.jdbc.Driver|jdbc:mysql://<host>:<port>/<db>|", "Generic Derby (Embedded)|org.apache.derby.jdbc.EmbeddedDriver|jdbc:derby:test;create=true|sa", "Generic Derby (Server)|org.apache.derby.jdbc.ClientDriver|jdbc:derby://localhost:1527/test;create=true|sa", "Generic HSQLDB|org.hsqldb.jdbcDriver|jdbc:hsqldb:test;hsqldb.default_table_type=cached|sa", "Generic H2|org.h2.Driver|jdbc:h2:~/test|sa"};
    private String driverList;
    private static int ticker;
    private int port;
    private boolean allowOthers;
    private boolean ssl;
    private HashMap connInfoMap = new HashMap();
    private static final long SESSION_TIMEOUT = 1800000L;
    private long lastTimeoutCheck;
    private HashMap sessions = new HashMap();
    private HashSet languages = new HashSet();
    private String startDateTime;
    private ServerSocket serverSocket;
    private String url;
    private boolean allowShutdown = true;
    private Thread listenerThread;

    byte[] getFile(String file) throws IOException {
        this.trace("getFile <" + file + ">");
        byte[] data = Resources.get("/org/h2/server/web/res/" + file);
        if (data == null) {
            this.trace(" null");
        } else {
            this.trace(" size=" + data.length);
        }
        return data;
    }

    String getTextFile(String file) throws IOException {
        byte[] bytes = this.getFile(file);
        return new String(bytes);
    }

    private String generateSessionId() {
        byte[] buff = RandomUtils.getSecureBytes(16);
        return ByteUtils.convertBytesToString(buff);
    }

    WebSession getSession(String sessionId) {
        WebSession session;
        long now = System.currentTimeMillis();
        if (this.lastTimeoutCheck + 1800000L < now) {
            Object[] list = this.sessions.keySet().toArray();
            for (int i = 0; i < list.length; ++i) {
                String id = (String)list[i];
                WebSession session2 = (WebSession)this.sessions.get(id);
                Long last = (Long)session2.get("lastAccess");
                if (last == null || last + 1800000L >= now) continue;
                this.trace("timeout for " + id);
                this.sessions.remove(id);
            }
            this.lastTimeoutCheck = now;
        }
        if ((session = (WebSession)this.sessions.get(sessionId)) != null) {
            session.lastAccess = System.currentTimeMillis();
        }
        return session;
    }

    WebSession createNewSession(String hostname) {
        String newId;
        while (this.sessions.get(newId = this.generateSessionId()) != null) {
        }
        WebSession session = new WebSession(this);
        session.put("sessionId", newId);
        session.put("ip", hostname);
        session.put("language", DEFAULT_LANGUAGE);
        this.sessions.put(newId, session);
        this.readTranslations(session, DEFAULT_LANGUAGE);
        return this.getSession(newId);
    }

    String getStartDateTime() {
        return this.startDateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String[] args) throws Exception {
        Object baseDir;
        Properties prop = this.loadProperties();
        this.driverList = prop.getProperty("drivers");
        this.port = FileUtils.getIntProperty(prop, "webPort", 8082);
        this.ssl = FileUtils.getBooleanProperty(prop, "webSSL", false);
        this.allowOthers = FileUtils.getBooleanProperty(prop, "webAllowOthers", false);
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("-webPort".equals(args[i])) {
                this.port = MathUtils.decodeInt(args[++i]);
                continue;
            }
            if ("-webSSL".equals(args[i])) {
                this.ssl = Boolean.valueOf(args[++i]);
                continue;
            }
            if ("-webAllowOthers".equals(args[i])) {
                this.allowOthers = Boolean.valueOf(args[++i]);
                continue;
            }
            if (!"-baseDir".equals(args[i])) continue;
            baseDir = args[++i];
            SysProperties.setBaseDir((String)baseDir);
        }
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", new Locale(DEFAULT_LANGUAGE, ""));
        baseDir = format;
        synchronized (baseDir) {
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.startDateTime = format.format(new Date());
        }
        this.trace(this.startDateTime);
        for (int i = 0; i < LANGUAGES.length; ++i) {
            this.languages.add(LANGUAGES[i][0]);
        }
        this.url = (this.ssl ? "https" : "http") + "://localhost:" + this.port;
    }

    public String getURL() {
        return this.url;
    }

    public void start() throws SQLException {
        this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
    }

    public void listen() {
        this.listenerThread = Thread.currentThread();
        try {
            while (this.serverSocket != null) {
                Socket s = this.serverSocket.accept();
                WebThread c = new WebThread(s, this);
                c.start();
            }
        }
        catch (Exception e) {
            this.trace(e.toString());
        }
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, this.ssl);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.serverSocket = null;
        if (this.listenerThread != null) {
            try {
                this.listenerThread.join(1000L);
            }
            catch (InterruptedException e) {
                TraceSystem.traceThrowable(e);
            }
        }
    }

    void trace(String s) {
    }

    public void traceError(Exception e) {
        e.printStackTrace();
    }

    public boolean supportsLanguage(String language) {
        return this.languages.contains(language);
    }

    public void readTranslations(WebSession session, String language) {
        Properties text = new Properties();
        try {
            this.trace("translation: " + language);
            byte[] trans = this.getFile("_text_" + language + ".properties");
            this.trace("  " + new String(trans));
            text.load(new ByteArrayInputStream(trans));
        }
        catch (IOException e) {
            TraceSystem.traceThrowable(e);
        }
        session.put("text", new HashMap<Object, Object>(text));
    }

    public String[][] getLanguageArray() {
        return LANGUAGES;
    }

    public ArrayList getSessions() {
        ArrayList list = new ArrayList(this.sessions.values());
        for (int i = 0; i < list.size(); ++i) {
            WebSession s = (WebSession)list.get(i);
            list.set(i, s.getInfo());
        }
        return list;
    }

    public String getType() {
        return "Web";
    }

    void setAllowOthers(boolean b) {
        this.allowOthers = b;
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    void setSSL(boolean b) {
        this.ssl = b;
    }

    void setPort(int port) {
        this.port = port;
    }

    boolean getSSL() {
        return this.ssl;
    }

    int getPort() {
        return this.port;
    }

    ConnectionInfo getSetting(String name) {
        return (ConnectionInfo)this.connInfoMap.get(name);
    }

    void updateSetting(ConnectionInfo info) {
        this.connInfoMap.put(info.name, info);
        info.lastAccess = ticker++;
    }

    void removeSetting(String name) {
        this.connInfoMap.remove(name);
    }

    private String getPropertiesFileName() {
        return FileUtils.getFileInUserHome(".h2.server.properties");
    }

    Properties loadProperties() {
        String fileName = this.getPropertiesFileName();
        try {
            return FileUtils.loadProperties(fileName);
        }
        catch (IOException e) {
            return new Properties();
        }
    }

    String[] getSettingNames() {
        ArrayList list = this.getSettings();
        String[] names = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            names[i] = ((ConnectionInfo)list.get((int)i)).name;
        }
        return names;
    }

    synchronized ArrayList getSettings() {
        ArrayList<ConnectionInfo> settings = new ArrayList<ConnectionInfo>();
        if (this.connInfoMap.size() == 0) {
            Properties prop = this.loadProperties();
            if (prop.size() == 0) {
                for (int i = 0; i < GENERIC.length; ++i) {
                    ConnectionInfo info = new ConnectionInfo(GENERIC[i]);
                    settings.add(info);
                    this.updateSetting(info);
                }
            } else {
                String data;
                int i = 0;
                while ((data = prop.getProperty(String.valueOf(i))) != null) {
                    ConnectionInfo info = new ConnectionInfo(data);
                    settings.add(info);
                    this.updateSetting(info);
                    ++i;
                }
            }
        } else {
            settings.addAll(this.connInfoMap.values());
        }
        this.sortConnectionInfo(settings);
        return settings;
    }

    void sortConnectionInfo(ArrayList list) {
        for (int i = 1; i < list.size(); ++i) {
            int j;
            ConnectionInfo t = (ConnectionInfo)list.get(i);
            for (j = i - 1; j >= 0 && ((ConnectionInfo)list.get((int)j)).lastAccess < t.lastAccess; --j) {
                list.set(j + 1, list.get(j));
            }
            list.set(j + 1, t);
        }
    }

    synchronized void saveSettings() {
        try {
            SortedProperties prop = new SortedProperties();
            if (this.driverList != null) {
                prop.setProperty("drivers", this.driverList);
            }
            prop.setProperty("webPort", String.valueOf(this.port));
            prop.setProperty("webAllowOthers", String.valueOf(this.allowOthers));
            prop.setProperty("webSSL", String.valueOf(this.ssl));
            ArrayList settings = this.getSettings();
            int len = settings.size();
            for (int i = 0; i < len; ++i) {
                ConnectionInfo info = (ConnectionInfo)settings.get(i);
                if (info == null) continue;
                prop.setProperty(String.valueOf(len - i - 1), info.getString());
            }
            FileOutputStream out = FileUtils.openFileOutputStream(this.getPropertiesFileName());
            prop.store(out, "H2 Server Properties");
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
        }
    }

    Connection getConnection(String driver, String url, String user, String password) throws Exception {
        driver = driver.trim();
        url = url.trim();
        user = user.trim();
        password = password.trim();
        Driver.load();
        return JdbcUtils.getConnection(driver, url, user, password);
    }

    public void setAllowShutdown(boolean b) {
        this.allowShutdown = b;
    }

    boolean getAllowShutdown() {
        return this.allowShutdown;
    }
}

