/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.ScanCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Storage;
import org.h2.table.Column;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class ScanIndex
extends Index {
    private int firstFree = -1;
    private ObjectArray rows = new ObjectArray();
    private Storage storage;
    private TableData tableData;
    private boolean containsLargeObject;

    public ScanIndex(TableData table, int id, Column[] columns, IndexType indexType) throws SQLException {
        super(table, id, table.getName() + "_TABLE_SCAN", columns, indexType);
        this.tableData = table;
        Database db = table.getDatabase();
        if (!db.isPersistent() || id < 0) {
            return;
        }
        this.storage = db.getStorage(table, id, true);
        int count = this.storage.getRecordCount();
        this.rowCount = count;
        table.setRowCount(count);
        this.trace.info("open existing " + table.getName() + " rows: " + count);
        for (int i = 0; i < columns.length; ++i) {
            if (!DataType.isLargeObject(columns[i].getType())) continue;
            this.containsLargeObject = true;
        }
    }

    public void remove(Session session) throws SQLException {
        this.truncate(session);
        if (this.storage != null) {
            this.storage.delete(session);
        }
    }

    public void truncate(Session session) throws SQLException {
        if (this.storage == null) {
            this.rows = new ObjectArray();
            this.firstFree = -1;
        } else {
            this.storage.truncate(session);
        }
        if (this.containsLargeObject && this.tableData.isPersistent()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        this.tableData.setRowCount(0);
        this.rowCount = 0L;
    }

    public String getCreateSQL() {
        return null;
    }

    public void close(Session session) throws SQLException {
        if (this.storage != null) {
            this.storage = null;
        }
    }

    public Row getRow(int key) throws SQLException {
        if (this.storage != null) {
            return (Row)this.storage.getRecord(key);
        }
        return (Row)this.rows.get(key);
    }

    public void add(Session session, Row row) throws SQLException {
        if (this.storage != null) {
            if (this.containsLargeObject) {
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    Value v = row.getValue(i);
                    Value v2 = v.link(this.database, this.getId());
                    session.unlinkAtCommitStop(v2);
                    if (v == v2) continue;
                    row.setValue(i, v2);
                }
            }
            this.storage.addRecord(session, row, -1);
        } else if (this.firstFree == -1) {
            int key = this.rows.size();
            row.setPos(key);
            this.rows.add(row);
        } else {
            int key = this.firstFree;
            Row free = (Row)this.rows.get(key);
            this.firstFree = free.getPos();
            row.setPos(key);
            this.rows.set(key, row);
        }
        ++this.rowCount;
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.storage != null) {
            this.storage.removeRecord(session, row.getPos());
            if (this.containsLargeObject) {
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    Value v = row.getValue(i);
                    if (!v.isLinked()) continue;
                    session.unlinkAtCommit(v);
                }
            }
        } else {
            Row free = new Row();
            free.setPos(this.firstFree);
            int key = row.getPos();
            this.rows.set(key, free);
            this.firstFree = key;
        }
        --this.rowCount;
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) throws SQLException {
        return new ScanCursor(this);
    }

    public long getCost(int[] masks) throws SQLException {
        long cost = this.tableData.getRowCount() + 1000L;
        if (this.storage != null) {
            cost *= 10L;
        }
        return cost;
    }

    Row getNextRow(Row row) throws SQLException {
        if (this.storage == null) {
            int key = row == null ? -1 : row.getPos();
            do {
                if (++key < this.rows.size()) continue;
                return null;
            } while ((row = (Row)this.rows.get(key)).isEmpty());
            return row;
        }
        int pos = this.storage.getNext(row);
        if (pos < 0) {
            return null;
        }
        return (Row)this.storage.getRecord(pos);
    }

    public int getColumnIndex(Column col) {
        return -1;
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast(boolean first) {
        return false;
    }

    public Value findFirstOrLast(Session session, boolean first) throws SQLException {
        throw Message.getUnsupportedException();
    }
}

