/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.message.Message;
import org.h2.util.ObjectArray;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

public class AggregateData {
    private int aggregateType;
    private long count;
    private ValueHashMap distinctValues;
    private Value value;
    private double sum;
    private double vpn;
    private ObjectArray list;

    AggregateData(int aggregateType) {
        this.aggregateType = aggregateType;
    }

    void add(Database database, boolean distinct, Value v) throws SQLException {
        if (this.aggregateType == 13) {
            int size;
            ++this.count;
            if (this.distinctValues == null) {
                this.distinctValues = new ValueHashMap(database);
            }
            if ((size = this.distinctValues.size()) > 10000) {
                this.distinctValues = new ValueHashMap(database);
                this.sum += (double)size;
            }
            this.distinctValues.put(v, this);
            return;
        }
        if (this.aggregateType == 0) {
            ++this.count;
            return;
        }
        if (v == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        if (distinct) {
            if (this.distinctValues == null) {
                this.distinctValues = new ValueHashMap(database);
            }
            this.distinctValues.put(v, this);
            return;
        }
        switch (this.aggregateType) {
            case 1: {
                return;
            }
            case 2: 
            case 5: {
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                v = v.convertTo(this.value.getType());
                this.value = this.value.add(v);
                break;
            }
            case 3: {
                if (this.value != null && database.compare(v, this.value) >= 0) break;
                this.value = v;
                break;
            }
            case 4: {
                if (this.value != null && database.compare(v, this.value) <= 0) break;
                this.value = v;
                break;
            }
            case 6: {
                if (this.list == null) {
                    this.list = new ObjectArray();
                }
                this.list.add(v);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                double x = v.getDouble();
                if (this.count == 1L) {
                    this.sum = x;
                    this.vpn = 0.0;
                    break;
                }
                double xs = this.sum - x * (double)(this.count - 1L);
                this.vpn += xs * xs / (double)this.count / (double)(this.count - 1L);
                this.sum += x;
                break;
            }
            case 12: {
                v = v.convertTo(1);
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() != false && v.getBoolean() != false);
                break;
            }
            case 11: {
                v = v.convertTo(1);
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() != false || v.getBoolean() != false);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.aggregateType);
            }
        }
    }

    ObjectArray getList() {
        return this.list;
    }

    Value getValue(Database database, boolean distinct) throws SQLException {
        if (distinct) {
            this.count = 0L;
            this.groupDistinct(database);
        }
        Value v = null;
        switch (this.aggregateType) {
            case 13: {
                int s = 0;
                if (this.count == 0L) {
                    s = 0;
                } else {
                    this.sum += (double)this.distinctValues.size();
                    this.sum = 100.0 * this.sum / (double)this.count;
                    s = (int)this.sum;
                    s = s <= 0 ? 1 : (s > 100 ? 100 : s);
                }
                v = ValueInt.get(s);
                break;
            }
            case 0: 
            case 1: {
                v = ValueLong.get(this.count);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                v = this.value;
                break;
            }
            case 5: {
                if (this.value == null) break;
                v = this.divide(this.value, this.count);
                break;
            }
            case 6: {
                return null;
            }
            case 7: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(Math.sqrt(this.vpn / (double)this.count));
                break;
            }
            case 8: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(Math.sqrt(this.vpn / (double)(this.count - 1L)));
                break;
            }
            case 9: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(this.vpn / (double)this.count);
                break;
            }
            case 10: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(this.vpn / (double)(this.count - 1L));
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.aggregateType);
            }
        }
        return v == null ? ValueNull.INSTANCE : v;
    }

    private Value divide(Value a, long count) throws SQLException {
        if (count == 0L) {
            return ValueNull.INSTANCE;
        }
        int type = Value.getHigherOrder(a.getType(), 5);
        Value b = ValueLong.get(count).convertTo(type);
        a = a.convertTo(type).divide(b);
        return a;
    }

    private void groupDistinct(Database database) throws SQLException {
        if (this.distinctValues == null) {
            return;
        }
        if (this.aggregateType == 1) {
            this.count = this.distinctValues.size();
        } else {
            this.count = 0L;
            ObjectArray l2 = this.distinctValues.keys();
            for (int i = 0; i < l2.size(); ++i) {
                this.add(database, false, (Value)l2.get(i));
            }
        }
    }
}

