/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class Insert
extends Prepared {
    private Table table;
    private Column[] columns;
    private ObjectArray list = new ObjectArray();
    private Query query;

    public Insert(Session session) {
        super(session);
    }

    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expr) {
        this.list.add(expr);
    }

    public int update() throws SQLException {
        int count;
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0);
        if (this.list.size() > 0) {
            count = 0;
            for (int x = 0; x < this.list.size(); ++x) {
                Expression[] expr = (Expression[])this.list.get(x);
                Row newRow = this.table.getTemplateRow();
                this.setCurrentRowNumber(x + 1);
                for (int i = 0; i < this.columns.length; ++i) {
                    Column c = this.columns[i];
                    int index = c.getColumnId();
                    Expression e = expr[i];
                    if (e == null) continue;
                    e = e.optimize(this.session);
                    Value v = e.getValue(this.session).convertTo(c.getType());
                    newRow.setValue(index, v);
                }
                this.checkCancelled();
                this.table.fireBefore(this.session);
                this.table.validateConvertUpdateSequence(this.session, newRow);
                this.table.fireBeforeRow(this.session, null, newRow);
                this.table.lock(this.session, true);
                this.table.addRow(this.session, newRow);
                this.session.log(this.table, (short)0, newRow);
                this.table.fireAfter(this.session);
                this.table.fireAfterRow(this.session, null, newRow);
                ++count;
            }
        } else {
            LocalResult rows = this.query.query(0);
            count = 0;
            this.table.fireBefore(this.session);
            this.table.lock(this.session, true);
            while (rows.next()) {
                this.checkCancelled();
                Value[] r = rows.currentRow();
                Row newRow = this.table.getTemplateRow();
                this.setCurrentRowNumber(++count);
                for (int j = 0; j < this.columns.length; ++j) {
                    Column c = this.columns[j];
                    int index = c.getColumnId();
                    Value v = r[j].convertTo(c.getType());
                    newRow.setValue(index, v);
                }
                this.table.validateConvertUpdateSequence(this.session, newRow);
                this.table.fireBeforeRow(this.session, null, newRow);
                this.table.addRow(this.session, newRow);
                this.session.log(this.table, (short)0, newRow);
                this.table.fireAfterRow(this.session, null, newRow);
            }
            rows.close();
            this.table.fireAfter(this.session);
        }
        return count;
    }

    public String getPlanSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("INSERT INTO ");
        buff.append(this.table.getSQL());
        buff.append('(');
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.columns[i].getSQL());
        }
        buff.append(")\n");
        if (this.list.size() > 0) {
            buff.append("VALUES ");
            for (int x = 0; x < this.list.size(); ++x) {
                Expression[] expr = (Expression[])this.list.get(x);
                if (x > 0) {
                    buff.append(", ");
                }
                buff.append("(");
                for (int i = 0; i < this.columns.length; ++i) {
                    Expression e;
                    if (i > 0) {
                        buff.append(", ");
                    }
                    if ((e = expr[i]) == null) {
                        buff.append("DEFAULT");
                        continue;
                    }
                    buff.append(StringUtils.unEnclose(e.getSQL()));
                }
                buff.append(')');
            }
        } else {
            buff.append(this.query.getPlanSQL());
        }
        return buff.toString();
    }

    public void prepare() throws SQLException {
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && ((Expression[])this.list.get(0)).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (int x = 0; x < this.list.size(); ++x) {
                Expression[] expr = (Expression[])this.list.get(x);
                if (expr.length != this.columns.length) {
                    throw Message.getSQLException(21002);
                }
                for (int i = 0; i < expr.length; ++i) {
                    Expression e = expr[i];
                    if (e == null) continue;
                    expr[i] = e.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw Message.getSQLException(21002);
            }
        }
    }

    public boolean isTransactional() {
        return true;
    }
}

