/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.MemoryFile;
import org.h2.util.StringUtils;

public class FileUtils {
    public static final HashMap memoryFiles = new HashMap();
    private static final String MEMORY_PREFIX = "inmemory:";
    private static final String MEMORY_PREFIX_2 = "mem:";
    private static final boolean isCaseInsensitiveFileSystem = File.separatorChar == '\\';

    public static RandomAccessFile openRandomAccessFile(String fileName, String mode) throws IOException {
        try {
            return new RandomAccessFile(fileName, mode);
        }
        catch (IOException e) {
            FileUtils.freeMemoryAndFinalize();
            return new RandomAccessFile(fileName, mode);
        }
    }

    public static void setLength(RandomAccessFile file, long newLength) throws IOException {
        try {
            file.setLength(newLength);
        }
        catch (IOException e) {
            int write;
            long remaining;
            long length = file.length();
            if (newLength < length) {
                throw e;
            }
            long pos = file.getFilePointer();
            file.seek(length);
            int maxSize = 0x100000;
            int block = (int)Math.min(remaining, (long)maxSize);
            byte[] buffer = new byte[block];
            for (remaining = newLength - length; remaining > 0L; remaining -= (long)write) {
                write = (int)Math.min(remaining, (long)maxSize);
                file.write(buffer, 0, write);
            }
            file.seek(pos);
        }
    }

    public static FileWriter openFileWriter(String fileName, boolean append) throws IOException {
        try {
            return new FileWriter(fileName, append);
        }
        catch (IOException e) {
            FileUtils.freeMemoryAndFinalize();
            return new FileWriter(fileName, append);
        }
    }

    public static boolean fileStartsWith(String fileName, String prefix) {
        if (isCaseInsensitiveFileSystem) {
            fileName = StringUtils.toUpperEnglish(fileName);
            prefix = StringUtils.toUpperEnglish(prefix);
        }
        return fileName.startsWith(prefix);
    }

    public static FileOutputStream openFileOutputStream(File file) throws IOException, SQLException {
        try {
            FileUtils.createDirs(file.getAbsolutePath());
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            FileUtils.freeMemoryAndFinalize();
            return new FileOutputStream(file);
        }
    }

    private static void freeMemoryAndFinalize() {
        long mem = Runtime.getRuntime().freeMemory();
        for (int i = 0; i < 16; ++i) {
            System.gc();
            long now = Runtime.getRuntime().freeMemory();
            Runtime.getRuntime().runFinalization();
            if (now == mem) break;
            mem = now;
        }
    }

    public static void rename(String oldName, String newName) throws SQLException {
        if (FileUtils.isInMemory(oldName)) {
            MemoryFile f = FileUtils.getMemoryFile(oldName);
            f.setName(newName);
            memoryFiles.put(newName, f);
            return;
        }
        File oldFile = new File(oldName);
        File newFile = new File(newName);
        if (oldFile.getName().equals(newFile.getName())) {
            throw Message.getInternalError("rename file old=new");
        }
        if (!oldFile.exists()) {
            throw Message.getSQLException(90024, new String[]{oldName, newName}, null);
        }
        if (newFile.exists()) {
            throw Message.getSQLException(90024, new String[]{oldName, newName}, null);
        }
        for (int i = 0; i < 16; ++i) {
            boolean ok = oldFile.renameTo(newFile);
            if (ok) {
                return;
            }
            FileUtils.wait(i);
        }
        throw Message.getSQLException(90024, new String[]{oldName, newName}, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Properties loadProperties(File file) throws IOException {
        Properties prop = new Properties();
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            try {
                prop.load(in);
            }
            finally {
                in.close();
            }
        }
        return prop;
    }

    public static boolean getBooleanProperty(Properties prop, String key, boolean def) {
        String value = prop.getProperty(key, "" + def);
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
            return def;
        }
    }

    public static int getIntProperty(Properties prop, String key, int def) {
        String value = prop.getProperty(key, "" + def);
        try {
            return MathUtils.decodeInt(value);
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
            return def;
        }
    }

    public static void createDirs(String fileName) throws SQLException {
        File f = new File(fileName);
        if (!f.exists()) {
            String parent = f.getParent();
            if (parent == null) {
                return;
            }
            File dir = new File(parent);
            for (int i = 0; i < 16; ++i) {
                if (dir.exists() || dir.mkdirs()) {
                    return;
                }
                FileUtils.wait(i);
            }
            throw Message.getSQLException(90062, parent);
        }
    }

    public static boolean createNewFile(String fileName) throws SQLException {
        if (FileUtils.isInMemory(fileName)) {
            if (FileUtils.exists(fileName)) {
                return false;
            }
            FileUtils.getMemoryFile(fileName);
            return true;
        }
        File file = new File(fileName);
        for (int i = 0; i < 8; ++i) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                FileUtils.wait(i);
                continue;
            }
        }
        return false;
    }

    public static void delete(String fileName) throws SQLException {
        if (FileUtils.isInMemory(fileName)) {
            memoryFiles.remove(fileName);
            return;
        }
        File file = new File(fileName);
        if (file.exists()) {
            for (int i = 0; i < 16; ++i) {
                boolean ok = file.delete();
                if (ok) {
                    return;
                }
                FileUtils.wait(i);
            }
            throw Message.getSQLException(90025, fileName);
        }
    }

    private static void wait(int i) {
        if (i > 8) {
            System.gc();
        }
        try {
            long sleep = (long)i * (long)i;
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getFileName(String name) throws SQLException {
        String separator = System.getProperty("file.separator");
        String path = FileUtils.getParent(name) + separator;
        String fullFileName = FileUtils.normalize(name);
        if (!fullFileName.startsWith(path)) {
            throw Message.getInternalError("file utils error: " + fullFileName + " does not start with " + path);
        }
        String fileName = fullFileName.substring(path.length());
        return fileName;
    }

    public static File getFileInUserHome(String filename) {
        String userDir = System.getProperty("user.home");
        if (userDir == null) {
            return new File(filename);
        }
        return new File(userDir, filename);
    }

    public static String normalize(String fileName) throws SQLException {
        if (FileUtils.isInMemory(fileName)) {
            return fileName;
        }
        File f = new File(fileName);
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public static void tryDelete(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            memoryFiles.remove(fileName);
            return;
        }
        new File(fileName).delete();
    }

    public static boolean isReadOnly(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            return false;
        }
        File f = new File(fileName);
        return f.exists() && !f.canWrite();
    }

    public static boolean exists(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            return memoryFiles.get(fileName) != null;
        }
        return new File(fileName).exists();
    }

    public static MemoryFile getMemoryFile(String fileName) {
        MemoryFile m = (MemoryFile)memoryFiles.get(fileName);
        if (m == null) {
            m = new MemoryFile(fileName);
            memoryFiles.put(fileName, m);
        }
        return m;
    }

    public static long length(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            return FileUtils.getMemoryFile(fileName).length();
        }
        return new File(fileName).length();
    }

    public static boolean isInMemory(String fileName) {
        return fileName.startsWith(MEMORY_PREFIX) || fileName.startsWith(MEMORY_PREFIX_2);
    }

    public static String createTempFile(String name, String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException, SQLException {
        File dir;
        if (FileUtils.isInMemory(name = name + ".")) {
            int i = 0;
            while (true) {
                String n;
                if (!FileUtils.exists(n = name + i + suffix)) {
                    FileUtils.getMemoryFile(n);
                    return n;
                }
                ++i;
            }
        }
        String prefix = new File(name).getName();
        if (inTempDir) {
            dir = null;
        } else {
            dir = new File(name).getAbsoluteFile().getParentFile();
            dir.mkdirs();
        }
        File f = File.createTempFile(prefix, suffix, dir);
        if (deleteOnExit) {
            f.deleteOnExit();
        }
        return f.getCanonicalPath();
    }

    public static String getParent(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            return MEMORY_PREFIX;
        }
        return new File(fileName).getParent();
    }

    public static String[] listFiles(String path) throws SQLException {
        if (FileUtils.isInMemory(path)) {
            String[] list = new String[memoryFiles.size()];
            MemoryFile[] l = new MemoryFile[memoryFiles.size()];
            memoryFiles.values().toArray(l);
            for (int i = 0; i < list.length; ++i) {
                list[i] = l[i].getName();
            }
            return list;
        }
        File f = new File(path);
        try {
            String[] list = f.list();
            if (list == null) {
                return new String[0];
            }
            String base = f.getCanonicalPath() + File.separator;
            for (int i = 0; i < list.length; ++i) {
                list[i] = base + list[i];
            }
            return list;
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public static boolean isDirectory(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            return false;
        }
        return new File(fileName).isDirectory();
    }

    public static void copy(String original, String copy) throws SQLException {
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            int len;
            out = FileUtils.openFileOutputStream(new File(copy));
            in = new FileInputStream(new File(original));
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            IOUtils.closeSilently(in);
            IOUtils.closeSilently(out);
            throw Message.convert(e);
        }
    }

    public static void deleteRecursive(String fileName) throws SQLException {
        if (FileUtils.isDirectory(fileName)) {
            String[] list = FileUtils.listFiles(fileName);
            for (int i = 0; list != null && i < list.length; ++i) {
                FileUtils.deleteRecursive(list[i]);
            }
        }
        FileUtils.delete(fileName);
    }
}

