/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.ResultDiskTape;
import org.h2.result.SortOrder;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

class ResultDiskBuffer {
    private static final int READ_AHEAD = 128;
    private DataPage rowBuff;
    private FileStore file;
    private ObjectArray tapes;
    private ResultDiskTape mainTape;
    private SortOrder sort;
    private int columnCount;

    public ResultDiskBuffer(Session session, SortOrder sort, int columnCount) throws SQLException {
        this.sort = sort;
        this.columnCount = columnCount;
        Database db = session.getDatabase();
        this.rowBuff = DataPage.create((DataHandler)db, 512);
        String fileName = session.getDatabase().createTempFile();
        this.file = session.getDatabase().openFile(fileName, false);
        this.file.setCheckedWriting(false);
        this.file.autoDelete();
        this.file.seek(48L);
        if (sort != null) {
            this.tapes = new ObjectArray();
        } else {
            this.mainTape = new ResultDiskTape();
            this.mainTape.pos = 48L;
        }
    }

    public void addRows(ObjectArray rows) throws SQLException {
        if (this.sort != null) {
            this.sort.sort(rows);
        }
        DataPage buff = this.rowBuff;
        long start = this.file.getFilePointer();
        for (int i = 0; i < rows.size(); ++i) {
            buff.reset();
            buff.writeInt(0);
            Value[] row = (Value[])rows.get(i);
            for (int j = 0; j < this.columnCount; ++j) {
                buff.writeValue(row[j]);
            }
            buff.fillAligned();
            int len = buff.length();
            buff.setInt(0, len);
            buff.updateChecksum();
            this.file.write(buff.getBytes(), 0, len);
        }
        if (this.sort != null) {
            ResultDiskTape tape = new ResultDiskTape();
            tape.start = start;
            tape.end = this.file.getFilePointer();
            this.tapes.add(tape);
        } else {
            this.mainTape.end = this.file.getFilePointer();
        }
    }

    public void done() throws SQLException {
        this.file.seek(48L);
    }

    public void reset() {
        if (this.sort != null) {
            for (int i = 0; i < this.tapes.size(); ++i) {
                ResultDiskTape tape = this.getTape(i);
                tape.pos = tape.start;
                tape.buffer = new ObjectArray();
            }
        } else {
            this.mainTape.pos = 48L;
        }
    }

    private void readRow(ResultDiskTape tape) throws SQLException {
        int min = 16;
        DataPage buff = this.rowBuff;
        buff.reset();
        this.file.readFully(buff.getBytes(), 0, min);
        int len = buff.readInt();
        buff.checkCapacity(len);
        if (len - min > 0) {
            this.file.readFully(buff.getBytes(), min, len - min);
        }
        buff.check(len);
        tape.pos += (long)len;
        Value[] row = new Value[this.columnCount];
        for (int k = 0; k < this.columnCount; ++k) {
            row[k] = buff.readValue();
        }
        tape.buffer.add(row);
    }

    public Value[] next() throws SQLException {
        return this.sort != null ? this.nextSorted() : this.nextUnsorted();
    }

    private Value[] nextUnsorted() throws SQLException {
        this.file.seek(this.mainTape.pos);
        if (this.mainTape.buffer.size() == 0) {
            for (int j = 0; this.mainTape.pos < this.mainTape.end && j < 128; ++j) {
                this.readRow(this.mainTape);
            }
        }
        Value[] row = (Value[])this.mainTape.buffer.get(0);
        this.mainTape.buffer.remove(0);
        return row;
    }

    private Value[] nextSorted() throws SQLException {
        int next = -1;
        for (int i = 0; i < this.tapes.size(); ++i) {
            ResultDiskTape tape = this.getTape(i);
            if (tape.buffer.size() == 0 && tape.pos < tape.end) {
                this.file.seek(tape.pos);
                for (int j = 0; tape.pos < tape.end && j < 128; ++j) {
                    this.readRow(tape);
                }
            }
            if (tape.buffer.size() <= 0) continue;
            if (next == -1) {
                next = i;
                continue;
            }
            if (this.compareTapes(tape, this.getTape(next)) >= 0) continue;
            next = i;
        }
        ResultDiskTape t = this.getTape(next);
        Value[] row = (Value[])t.buffer.get(0);
        t.buffer.remove(0);
        return row;
    }

    private ResultDiskTape getTape(int i) {
        return (ResultDiskTape)this.tapes.get(i);
    }

    private int compareTapes(ResultDiskTape a, ResultDiskTape b) throws SQLException {
        Value[] va = (Value[])a.buffer.get(0);
        Value[] vb = (Value[])b.buffer.get(0);
        return this.sort.compare(va, vb);
    }

    protected void finalize() {
        if (!Constants.RUN_FINALIZE) {
            return;
        }
        this.close();
    }

    public void close() {
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
        }
    }
}

