/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcArray;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.result.UpdatableRow;
import org.h2.util.ByteUtils;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class JdbcResultSet
extends TraceObject
implements ResultSet {
    private SessionInterface session;
    private ResultInterface result;
    private JdbcConnection conn;
    private JdbcStatement stat;
    private int columnCount;
    private boolean wasNull;
    private Value[] insertRow;
    private Value[] updateRow;
    private boolean closeStatement;

    public boolean next() throws SQLException {
        try {
            this.debugCodeCall("next");
            this.checkClosed();
            return this.result.next();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            int id = this.getNextId(5);
            if (this.debug()) {
                this.debugCodeAssign("ResultSetMetaData", 5, id);
                this.debugCodeCall("getMetaData");
            }
            this.checkClosed();
            JdbcResultSetMetaData meta = new JdbcResultSetMetaData(this, this.result, this.session.getTrace(), id);
            return meta;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            this.debugCodeCall("wasNull");
            this.checkClosed();
            return this.wasNull;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int findColumn(String columnName) throws SQLException {
        try {
            this.debugCodeCall("findColumn", columnName);
            return this.getColumnIndex(columnName);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.closeInternal();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal() throws SQLException {
        if (this.result != null) {
            try {
                this.result.close();
                if (this.closeStatement && this.stat != null) {
                    this.stat.close();
                }
                Object var2_1 = null;
                this.columnCount = 0;
                this.result = null;
                this.stat = null;
                this.conn = null;
                this.insertRow = null;
                this.updateRow = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.columnCount = 0;
                this.result = null;
                this.stat = null;
                this.conn = null;
                this.insertRow = null;
                this.updateRow = null;
                throw throwable;
            }
        }
    }

    public Statement getStatement() throws SQLException {
        try {
            this.debugCodeCall("getStatement");
            this.checkClosed();
            if (this.closeStatement) {
                return null;
            }
            return this.stat;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getString(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getString", columnIndex);
            return this.get(columnIndex).getString();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getString(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getString", columnName);
            return this.get(columnName).getString();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getInt(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getInt", columnIndex);
            return this.get(columnIndex).getInt();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getInt(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getInt", columnName);
            return this.get(columnName).getInt();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", columnIndex);
            return this.get(columnIndex).getBigDecimal();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Date getDate(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getDate", columnIndex);
            return this.get(columnIndex).getDate();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Time getTime(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getTime", columnIndex);
            return this.get(columnIndex).getTime();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", columnIndex);
            return this.get(columnIndex).getTimestamp();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", columnName);
            return this.get(columnName).getBigDecimal();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Date getDate(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getDate", columnName);
            return this.get(columnName).getDate();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Time getTime(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getTime", columnName);
            return this.get(columnName).getTime();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", columnName);
            return this.get(columnName).getTimestamp();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Object getObject(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getObject", columnIndex);
            Value v = this.get(columnIndex);
            if (v.getType() == 19) {
                return ByteUtils.deserialize(v.getBytesNoCopy());
            }
            return v.getObject();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Object getObject(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getObject", columnName);
            Value v = this.get(columnName);
            if (v.getType() == 19) {
                return ByteUtils.deserialize(v.getBytesNoCopy());
            }
            return v.getObject();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", columnIndex);
            Boolean v = this.get(columnIndex).getBoolean();
            return v == null ? false : v;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean getBoolean(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", columnName);
            Boolean v = this.get(columnName).getBoolean();
            return v == null ? false : v;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public byte getByte(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getByte", columnIndex);
            return this.get(columnIndex).getByte();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public byte getByte(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getByte", columnName);
            return this.get(columnName).getByte();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public short getShort(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getShort", columnIndex);
            return this.get(columnIndex).getShort();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public short getShort(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getShort", columnName);
            return this.get(columnName).getShort();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public long getLong(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getLong", columnIndex);
            return this.get(columnIndex).getLong();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public long getLong(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getLong", columnName);
            return this.get(columnName).getLong();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public float getFloat(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getFloat", columnIndex);
            return this.get(columnIndex).getFloat();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public float getFloat(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getFloat", columnName);
            return this.get(columnName).getFloat();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public double getDouble(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getDouble", columnIndex);
            return this.get(columnIndex).getDouble();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public double getDouble(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getDouble", columnName);
            return this.get(columnName).getDouble();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getBigDecimal(" + StringUtils.quoteJavaString(columnName) + ", " + scale + ");");
            }
            if (scale < 0) {
                throw Message.getInvalidValueException("" + scale, "scale");
            }
            BigDecimal bd = this.get(columnName).getBigDecimal();
            return bd == null ? null : MathUtils.setScale(bd, scale);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getBigDecimal(" + columnIndex + ", " + scale + ");");
            }
            if (scale < 0) {
                throw Message.getInvalidValueException("" + scale, "scale");
            }
            BigDecimal bd = this.get(columnIndex).getBigDecimal();
            return bd == null ? null : MathUtils.setScale(bd, scale);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getUnicodeStream", columnIndex);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getUnicodeStream", columnName);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getObject(" + columnIndex + ", map);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getObject(" + this.quote(columnName) + ", map);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Ref getRef(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getRef", columnIndex);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Ref getRef(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getRef", columnName);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getDate(" + columnIndex + ", calendar)");
            }
            Date x = this.get(columnIndex).getDate();
            return DateTimeUtils.convertDateToCalendar(x, calendar);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getDate(" + StringUtils.quoteJavaString(columnName) + ", calendar)");
            }
            Date x = this.get(columnName).getDate();
            return DateTimeUtils.convertDateToCalendar(x, calendar);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getTime(" + columnIndex + ", calendar)");
            }
            Time x = this.get(columnIndex).getTime();
            return DateTimeUtils.convertTimeToCalendar(x, calendar);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getTime(" + StringUtils.quoteJavaString(columnName) + ", calendar)");
            }
            Time x = this.get(columnName).getTime();
            return DateTimeUtils.convertTimeToCalendar(x, calendar);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getTimestamp(" + columnIndex + ", calendar)");
            }
            Timestamp x = this.get(columnIndex).getTimestamp();
            return DateTimeUtils.convertTimestampToCalendar(x, calendar);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getTimestamp(" + StringUtils.quoteJavaString(columnName) + ", calendar)");
            }
            Timestamp x = this.get(columnName).getTimestamp();
            return DateTimeUtils.convertTimestampToCalendar(x, calendar);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            int id = this.getNextId(9);
            this.debugCodeAssign("Blob", 9, id);
            this.debugCodeCall("getBlob", columnIndex);
            Value v = this.get(columnIndex);
            return v == ValueNull.INSTANCE ? null : new JdbcBlob(this.session, this.conn, v, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Blob getBlob(String columnName) throws SQLException {
        try {
            int id = this.getNextId(9);
            this.debugCodeAssign("Blob", 9, id);
            this.debugCodeCall("getBlob", columnName);
            Value v = this.get(columnName);
            return v == ValueNull.INSTANCE ? null : new JdbcBlob(this.session, this.conn, v, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBytes", columnIndex);
            return this.get(columnIndex).getBytes();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public byte[] getBytes(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getBytes", columnName);
            return this.get(columnName).getBytes();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", columnIndex);
            return this.get(columnIndex).getInputStream();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", columnName);
            return this.get(columnName).getInputStream();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Clob getClob(int columnIndex) throws SQLException {
        try {
            int id = this.getNextId(10);
            this.debugCodeAssign("Clob", 10, id);
            this.debugCodeCall("getClob", columnIndex);
            Value v = this.get(columnIndex);
            return v == ValueNull.INSTANCE ? null : new JdbcClob(this.session, this.conn, v, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Clob getClob(String columnName) throws SQLException {
        try {
            int id = this.getNextId(10);
            this.debugCodeAssign("Clob", 10, id);
            this.debugCodeCall("getClob", columnName);
            Value v = this.get(columnName);
            return v == ValueNull.INSTANCE ? null : new JdbcClob(this.session, this.conn, v, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Array getArray(int columnIndex) throws SQLException {
        try {
            int id = this.getNextId(15);
            this.debugCodeAssign("Clob", 15, id);
            this.debugCodeCall("getArray", columnIndex);
            Value v = this.get(columnIndex);
            return v == ValueNull.INSTANCE ? null : new JdbcArray(this.session, this.conn, v, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Array getArray(String columnName) throws SQLException {
        try {
            int id = this.getNextId(15);
            this.debugCodeAssign("Clob", 15, id);
            this.debugCodeCall("getArray", columnName);
            Value v = this.get(columnName);
            return v == ValueNull.INSTANCE ? null : new JdbcArray(this.session, this.conn, v, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", columnIndex);
            String s = this.get(columnIndex).getString();
            return s == null ? null : IOUtils.getInputStream(s);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", columnName);
            String s = this.get(columnName).getString();
            return IOUtils.getInputStream(s);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", columnIndex);
            return this.get(columnIndex).getReader();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", columnName);
            return this.get(columnName).getReader();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public URL getURL(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getURL", columnIndex);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public URL getURL(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getURL", columnName);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateNull(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("updateNull", columnIndex);
            this.update(columnIndex, (Value)ValueNull.INSTANCE);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateNull(String columnName) throws SQLException {
        try {
            this.debugCodeCall("updateNull", columnName);
            this.update(columnName, (Value)ValueNull.INSTANCE);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBoolean(" + columnIndex + ", " + x + ");");
            }
            this.update(columnIndex, (Value)ValueBoolean.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBoolean(" + this.quote(columnName) + ", " + x + ");");
            }
            this.update(columnName, (Value)ValueBoolean.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateByte(" + columnIndex + ", " + x + ");");
            }
            this.update(columnIndex, (Value)ValueByte.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateByte(" + columnName + ", " + x + ");");
            }
            this.update(columnName, (Value)ValueByte.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBytes(" + columnIndex + ", x);");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueBytes.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBytes(" + this.quote(columnName) + ", x);");
            }
            this.update(columnName, x == null ? ValueNull.INSTANCE : ValueBytes.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateShort(" + columnIndex + ", " + x + ");");
            }
            this.update(columnIndex, (Value)ValueShort.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateShort(String columnName, short x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateShort(" + this.quote(columnName) + ", " + x + ");");
            }
            this.update(columnName, (Value)ValueShort.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateInt(" + columnIndex + ", " + x + ");");
            }
            this.update(columnIndex, (Value)ValueInt.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateInt(String columnName, int x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateInt(" + this.quote(columnName) + ", " + x + ");");
            }
            this.update(columnName, (Value)ValueInt.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateLong(" + columnIndex + ", " + x + ");");
            }
            this.update(columnIndex, (Value)ValueLong.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateLong(String columnName, long x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateLong(" + this.quote(columnName) + ", " + x + ");");
            }
            this.update(columnName, (Value)ValueLong.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateFloat(" + columnIndex + ", " + x + "f);");
            }
            this.update(columnIndex, (Value)ValueFloat.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateFloat(" + this.quote(columnName) + ", " + x + "f);");
            }
            this.update(columnName, (Value)ValueFloat.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateDouble(" + columnIndex + ", " + x + ");");
            }
            this.update(columnIndex, (Value)ValueDouble.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateDouble(" + this.quote(columnName) + ", " + x + ");");
            }
            this.update(columnName, (Value)ValueDouble.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBigDecimal(" + columnIndex + ", x);");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueDecimal.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBigDecimal(" + this.quote(columnName) + ", x);");
            }
            this.update(columnName, x == null ? ValueNull.INSTANCE : ValueDecimal.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateString(" + columnIndex + ", " + this.quote(x) + ");");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueString.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateString(String columnName, String x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateString(" + this.quote(columnName) + ", " + this.quote(x) + ");");
            }
            this.update(columnName, x == null ? ValueNull.INSTANCE : ValueString.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateDate(" + columnIndex + ", x);");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueDate.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateDate(" + this.quote(columnName) + ", x);");
            }
            this.update(columnName, x == null ? ValueNull.INSTANCE : ValueDate.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateTime(" + columnIndex + ", x);");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueTime.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateTime(" + this.quote(columnName) + ", x);");
            }
            this.update(columnName, x == null ? ValueNull.INSTANCE : ValueTime.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateTimestamp(" + columnIndex + ", x);");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueTimestamp.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateTimestamp(" + this.quote(columnName) + ", x);");
            }
            this.update(columnName, x == null ? ValueNull.INSTANCE : ValueTimestamp.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(columnIndex, x, (long)length);
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateAsciiStream(columnIndex, x, -1);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateAsciiStream(" + columnIndex + ", x, " + length + ");");
            }
            this.checkClosed();
            Value v = this.conn.createClob(IOUtils.getAsciiReader(x), length);
            this.update(columnIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(columnName, x, (long)length);
    }

    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        this.updateAsciiStream(columnName, x, -1);
    }

    public void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateAsciiStream(" + this.quote(columnName) + ", x, " + length + ");");
            }
            this.checkClosed();
            Value v = this.conn.createClob(IOUtils.getAsciiReader(x), length);
            this.update(columnName, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(columnIndex, x, (long)length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.updateBinaryStream(columnIndex, x, -1);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBinaryStream(" + columnIndex + ", x, " + length + ");");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, length);
            this.update(columnIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBinaryStream(String columnName, InputStream x) throws SQLException {
        this.updateBinaryStream(columnName, x, -1);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(columnName, x, (long)length);
    }

    public void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBinaryStream(" + this.quote(columnName) + ", x, " + length + ");");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, length);
            this.update(columnName, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateCharacterStream(" + columnIndex + ", x, " + length + ");");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.update(columnIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.updateCharacterStream(columnIndex, x, (long)length);
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateCharacterStream(columnIndex, x, -1);
    }

    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateCharacterStream(columnName, x, (long)length);
    }

    public void updateCharacterStream(String columnName, Reader x) throws SQLException {
        this.updateCharacterStream(columnName, x, -1);
    }

    public void updateCharacterStream(String columnName, Reader x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateCharacterStream(" + this.quote(columnName) + ", x, " + length + ");");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.update(columnName, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateObject(" + columnIndex + ", x, " + scale + ");");
            }
            this.update(columnIndex, DataType.convertToValue(this.session, x, -1));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateObject(" + this.quote(columnName) + ", x, " + scale + ");");
            }
            this.update(columnName, DataType.convertToValue(this.session, x, -1));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateObject(" + columnIndex + ", x);");
            }
            this.update(columnIndex, DataType.convertToValue(this.session, x, -1));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateObject(" + this.quote(columnName) + ", x);");
            }
            this.update(columnName, DataType.convertToValue(this.session, x, -1));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateRef(" + columnIndex + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateRef(" + this.quote(columnName) + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        this.updateBlob(columnIndex, x, -1L);
    }

    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBlob(" + columnIndex + ", x, " + length + ");");
            }
            Value v = this.conn.createBlob(x, length);
            this.update(columnIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBlob(" + columnIndex + ", x);");
            }
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createBlob(x.getBinaryStream(), -1L);
            this.update(columnIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBlob(" + this.quote(columnName) + ", x);");
            }
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createBlob(x.getBinaryStream(), -1L);
            this.update(columnName, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateBlob(String columnName, InputStream x) throws SQLException {
        this.updateBlob(columnName, x, -1L);
    }

    public void updateBlob(String columnName, InputStream x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateBlob(" + this.quote(columnName) + ", x, " + length + ");");
            }
            Value v = this.conn.createBlob(x, -1L);
            this.update(columnName, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateClob(" + columnIndex + ", x);");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
            this.update(columnIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateClob(int columnIndex, Reader x) throws SQLException {
        this.updateClob(columnIndex, x, -1L);
    }

    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateClob(" + columnIndex + ", x, " + length + ");");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.update(columnIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateClob(" + this.quote(columnName) + ", x);");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
            this.update(columnName, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateClob(String columnName, Reader x) throws SQLException {
        this.updateClob(columnName, x, -1L);
    }

    public void updateClob(String columnName, Reader x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateClob(" + this.quote(columnName) + ", x);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.update(columnName, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateArray(" + columnIndex + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateArray(" + this.quote(columnName) + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getCursorName() throws SQLException {
        try {
            this.debugCodeCall("getCursorName");
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getRow() throws SQLException {
        try {
            this.debugCodeCall("getRow");
            this.checkClosed();
            int rowId = this.result.getRowId();
            if (rowId >= this.result.getRowCount()) {
                return 0;
            }
            return rowId + 1;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getConcurrency");
            this.checkClosed();
            UpdatableRow row = new UpdatableRow(this.conn, this.result, this.session);
            return row.isUpdatable() ? 1008 : 1007;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return 0;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setFetchSize(int rowCount) throws SQLException {
        try {
            int maxRows;
            this.debugCodeCall("setFetchSize", rowCount);
            this.checkClosed();
            if (rowCount < 0) {
                throw Message.getInvalidValueException("" + rowCount, "rowCount");
            }
            if (rowCount > 0 && this.stat != null && (maxRows = this.stat.getMaxRows()) > 0 && rowCount > maxRows) {
                throw Message.getInvalidValueException("" + rowCount, "rowCount");
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.debugCodeCall("setFetchDirection", direction);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getType() throws SQLException {
        try {
            this.debugCodeCall("getType");
            this.checkClosed();
            return this.stat == null ? 1003 : this.stat.resultSetType;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            this.debugCodeCall("isBeforeFirst");
            this.checkClosed();
            return this.result.getRowId() < 0;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isAfterLast() throws SQLException {
        try {
            this.debugCodeCall("isAfterLast");
            this.checkClosed();
            int row = this.result.getRowId();
            int count = this.result.getRowCount();
            return row >= count || count == 0;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            this.debugCodeCall("isFirst");
            this.checkClosed();
            int row = this.result.getRowId();
            return row == 0 && row < this.result.getRowCount();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isLast() throws SQLException {
        try {
            this.debugCodeCall("isLast");
            this.checkClosed();
            int row = this.result.getRowId();
            return row >= 0 && row == this.result.getRowCount() - 1;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            this.debugCodeCall("beforeFirst");
            this.checkClosed();
            this.result.reset();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void afterLast() throws SQLException {
        try {
            this.debugCodeCall("afterLast");
            this.checkClosed();
            while (this.result.next()) {
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean first() throws SQLException {
        try {
            this.debugCodeCall("first");
            this.checkClosed();
            this.result.reset();
            return this.result.next();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean last() throws SQLException {
        try {
            this.debugCodeCall("last");
            this.checkClosed();
            return this.absolute(-1);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean absolute(int rowNumber) throws SQLException {
        try {
            this.debugCodeCall("absolute", rowNumber);
            this.checkClosed();
            if (rowNumber < 0) {
                rowNumber = this.result.getRowCount() + rowNumber + 1;
            } else if (rowNumber > this.result.getRowCount() + 1) {
                rowNumber = this.result.getRowCount() + 1;
            }
            if (rowNumber <= this.result.getRowId()) {
                this.result.reset();
            }
            while (this.result.getRowId() + 1 < rowNumber) {
                this.result.next();
            }
            int row = this.result.getRowId();
            return row >= 0 && row < this.result.getRowCount();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean relative(int rowCount) throws SQLException {
        try {
            this.debugCodeCall("relative", rowCount);
            this.checkClosed();
            int row = this.result.getRowId() + 1 + rowCount;
            if (row < 0) {
                row = 0;
            } else if (row > this.result.getRowCount()) {
                row = this.result.getRowCount() + 1;
            }
            return this.absolute(row);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean previous() throws SQLException {
        try {
            this.debugCodeCall("previous");
            this.checkClosed();
            return this.relative(-1);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void moveToInsertRow() throws SQLException {
        try {
            this.debugCodeCall("moveToInsertRow");
            this.checkClosed();
            this.insertRow = new Value[this.columnCount];
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void moveToCurrentRow() throws SQLException {
        try {
            this.debugCodeCall("moveToCurrentRow");
            this.checkClosed();
            this.insertRow = null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean rowUpdated() throws SQLException {
        try {
            this.debugCodeCall("rowUpdated");
            return false;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean rowInserted() throws SQLException {
        try {
            this.debugCodeCall("rowInserted");
            return false;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean rowDeleted() throws SQLException {
        try {
            this.debugCodeCall("rowDeleted");
            return false;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void insertRow() throws SQLException {
        try {
            this.debugCodeCall("insertRow");
            this.checkClosed();
            if (this.insertRow == null) {
                throw Message.getSQLException(90029);
            }
            this.getUpdatableRow().insertRow(this.insertRow);
            this.insertRow = null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateRow() throws SQLException {
        try {
            this.debugCodeCall("updateRow");
            this.checkClosed();
            if (this.insertRow != null) {
                throw Message.getSQLException(90029);
            }
            this.checkOnValidRow();
            if (this.updateRow != null) {
                this.getUpdatableRow().updateRow(this.result.currentRow(), this.updateRow);
                this.updateRow = null;
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void deleteRow() throws SQLException {
        try {
            this.debugCodeCall("deleteRow");
            this.checkClosed();
            if (this.insertRow != null) {
                throw Message.getSQLException(90029);
            }
            this.checkOnValidRow();
            this.getUpdatableRow().deleteRow(this.result.currentRow());
            this.updateRow = null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void refreshRow() throws SQLException {
        try {
            this.debugCodeCall("refreshRow");
            this.checkClosed();
            if (this.insertRow != null) {
                throw Message.getSQLException(2000);
            }
            this.checkOnValidRow();
            this.getUpdatableRow().refreshRow(this.result.currentRow());
            this.updateRow = null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void cancelRowUpdates() throws SQLException {
        try {
            this.debugCodeCall("cancelRowUpdates");
            this.checkClosed();
            if (this.insertRow != null) {
                throw Message.getSQLException(2000);
            }
            this.updateRow = null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    JdbcResultSet(SessionInterface session, JdbcConnection conn, JdbcStatement stat, ResultInterface result, int id, boolean closeStatement) {
        this.setTrace(session.getTrace(), 4, id);
        this.session = session;
        this.conn = conn;
        this.stat = stat;
        this.result = result;
        this.columnCount = result.getVisibleColumnCount();
        this.closeStatement = closeStatement;
    }

    private UpdatableRow getUpdatableRow() throws SQLException {
        UpdatableRow row = new UpdatableRow(this.conn, this.result, this.session);
        if (!row.isUpdatable()) {
            throw Message.getSQLException(90029);
        }
        return row;
    }

    int getColumnIndex(String columnName) throws SQLException {
        this.checkClosed();
        if (columnName == null) {
            throw Message.getInvalidValueException("columnName", null);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (!columnName.equalsIgnoreCase(this.result.getAlias(i))) continue;
            return i + 1;
        }
        int idx = columnName.indexOf(46);
        if (idx > 0) {
            String table = columnName.substring(0, idx);
            String col = columnName.substring(idx + 1);
            for (int i = 0; i < this.columnCount; ++i) {
                if (!table.equals(this.result.getTableName(i)) || !col.equalsIgnoreCase(this.result.getColumnName(i))) continue;
                return i + 1;
            }
        }
        throw Message.getSQLException(42122, columnName);
    }

    void checkColumnIndex(int columnIndex) throws SQLException {
        this.checkClosed();
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw Message.getInvalidValueException("" + columnIndex, "columnIndex");
        }
    }

    void checkClosed() throws SQLException {
        if (this.result == null) {
            throw Message.getSQLException(90007);
        }
        if (this.stat != null) {
            this.stat.checkClosed();
        }
        if (this.conn != null) {
            this.conn.checkClosed();
        }
    }

    private void checkOnValidRow() throws SQLException {
        if (this.result.getRowId() < 0 || this.result.getRowId() >= this.result.getRowCount()) {
            throw Message.getSQLException(2000);
        }
    }

    private Value get(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkOnValidRow();
        Value[] list = this.result.currentRow();
        Value value = list[columnIndex - 1];
        this.wasNull = value == ValueNull.INSTANCE;
        return value;
    }

    private Value get(String columnName) throws SQLException {
        int columnIndex = this.getColumnIndex(columnName);
        return this.get(columnIndex);
    }

    private void update(String columnName, Value v) throws SQLException {
        int columnIndex = this.getColumnIndex(columnName);
        this.update(columnIndex, v);
    }

    private void update(int columnIndex, Value v) throws SQLException {
        this.checkColumnIndex(columnIndex);
        if (this.insertRow != null) {
            this.insertRow[columnIndex - 1] = v;
        } else {
            if (this.updateRow == null) {
                this.updateRow = new Value[this.columnCount];
            }
            this.updateRow[columnIndex - 1] = v;
        }
    }

    public int getTraceId() {
        return super.getTraceId();
    }

    JdbcConnection getConnection() {
        return this.conn;
    }

    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            return this.conn.getHoldability();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.result == null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateNString(int columnIndex, String x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateNString(" + columnIndex + ", " + this.quote(x) + ");");
            }
            this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueString.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateNString(String columnName, String x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateNString(" + this.quote(columnName) + ", " + this.quote(x) + ");");
            }
            this.update(columnName, x == null ? ValueNull.INSTANCE : ValueString.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getNString(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getNString", columnIndex);
            return this.get(columnIndex).getString();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getNString(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getNString", columnName);
            return this.get(columnName).getString();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getNCharacterStream", columnIndex);
            return this.get(columnIndex).getReader();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Reader getNCharacterStream(String columnName) throws SQLException {
        try {
            this.debugCodeCall("getNCharacterStream", columnName);
            return this.get(columnName).getReader();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateNCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.updateNCharacterStream(columnIndex, x, (long)length);
    }

    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateNCharacterStream(columnIndex, x, -1);
    }

    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateNCharacterStream(" + columnIndex + ", x, " + length + ");");
            }
            Value v = this.conn.createClob(x, length);
            this.update(columnIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void updateNCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateNCharacterStream(columnName, x, (long)length);
    }

    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        this.updateNCharacterStream(columnName, x, -1);
    }

    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("updateNCharacterStream(" + this.quote(columnName) + ", x, " + length + ");");
            }
            Value v = this.conn.createClob(x, length);
            this.update(columnName, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }
}

