/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.util.HashSet;
import org.h2.command.dml.Query;
import org.h2.engine.Constants;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public class SelectUnion
extends Query {
    public static final int UNION = 0;
    public static final int UNION_ALL = 1;
    public static final int EXCEPT = 2;
    public static final int INTERSECT = 3;
    private int unionType;
    private Query left;
    private Query right;
    private ObjectArray expressions;
    private ObjectArray orderList;
    private SortOrder sort;
    private boolean distinct;
    private boolean checkPrepared;
    private boolean checkInit;
    private boolean isForUpdate;

    public SelectUnion(Session session, Query query) {
        super(session);
        this.left = query;
    }

    public void setUnionType(int type) {
        this.unionType = type;
    }

    public void setRight(Query select) throws JdbcSQLException {
        this.right = select;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public void setOrder(ObjectArray order) {
        this.orderList = order;
    }

    private Value[] convert(Value[] values) throws SQLException {
        for (int i = 0; i < values.length; ++i) {
            Expression e = (Expression)this.expressions.get(i);
            values[i] = values[i].convertTo(e.getType());
        }
        return values;
    }

    public LocalResult queryWithoutCache(int maxrows) throws SQLException {
        if (maxrows != 0) {
            if (this.limit != null) {
                maxrows = Math.min(this.limit.getValue(this.session).getInt(), maxrows);
            }
            this.limit = ValueExpression.get(ValueInt.get(maxrows));
        }
        ObjectArray expressions = this.left.getExpressions();
        int columnCount = this.left.getColumnCount();
        LocalResult result = new LocalResult(this.session, expressions, columnCount);
        result.setSortOrder(this.sort);
        if (this.distinct) {
            this.left.setDistinct(true);
            this.right.setDistinct(true);
            result.setDistinct();
        }
        switch (this.unionType) {
            case 0: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                result.setDistinct();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                result.setDistinct();
            }
            case 3: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.unionType);
            }
        }
        LocalResult l = this.left.query(0);
        LocalResult r = this.right.query(0);
        l.reset();
        r.reset();
        switch (this.unionType) {
            case 0: 
            case 1: {
                while (l.next()) {
                    result.addRow(this.convert(l.currentRow()));
                }
                while (r.next()) {
                    result.addRow(this.convert(r.currentRow()));
                }
                break;
            }
            case 2: {
                while (l.next()) {
                    result.addRow(this.convert(l.currentRow()));
                }
                while (r.next()) {
                    result.removeDistinct(this.convert(r.currentRow()));
                }
                break;
            }
            case 3: {
                LocalResult temp = new LocalResult(this.session, expressions, columnCount);
                temp.setDistinct();
                while (l.next()) {
                    temp.addRow(this.convert(l.currentRow()));
                }
                while (r.next()) {
                    Value[] values = this.convert(r.currentRow());
                    if (!temp.containsDistinct(values)) continue;
                    result.addRow(values);
                }
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.unionType);
            }
        }
        if (this.offset != null) {
            result.setOffset(this.offset.getValue(this.session).getInt());
        }
        if (this.limit != null) {
            result.setLimit(this.limit.getValue(this.session).getInt());
        }
        result.done();
        return result;
    }

    public void init() throws SQLException {
        if (Constants.CHECK && this.checkInit) {
            throw Message.getInternalError();
        }
        this.checkInit = true;
        this.left.init();
        this.right.init();
        int len = this.left.getColumnCount();
        if (len != this.right.getColumnCount()) {
            throw Message.getSQLException(21002);
        }
    }

    public void prepare() throws SQLException {
        if (Constants.CHECK && (this.checkPrepared || !this.checkInit)) {
            throw Message.getInternalError("already prepared");
        }
        this.checkPrepared = true;
        this.left.prepare();
        this.right.prepare();
        ObjectArray le = this.left.getExpressions();
        ObjectArray re = this.right.getExpressions();
        this.expressions = new ObjectArray();
        int len = this.left.getColumnCount();
        for (int i = 0; i < len; ++i) {
            Expression l = (Expression)le.get(i);
            Expression r = (Expression)re.get(i);
            int type = Value.getHigherOrder(l.getType(), r.getType());
            long prec = Math.max(l.getPrecision(), r.getPrecision());
            int scale = Math.max(l.getScale(), r.getScale());
            Column col = new Column(l.getAlias(), type, prec, scale);
            ExpressionColumn e = new ExpressionColumn(this.session.getDatabase(), null, col);
            this.expressions.add(e);
        }
        if (this.orderList != null) {
            this.sort = this.initOrder(this.expressions, this.orderList, this.getColumnCount(), true);
            this.orderList = null;
        }
    }

    public double getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    public HashSet getTables() {
        HashSet set = this.left.getTables();
        set.addAll(this.right.getTables());
        return set;
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public ObjectArray getExpressions() {
        return this.expressions;
    }

    public void setForUpdate(boolean forUpdate) {
        this.left.setForUpdate(forUpdate);
        this.right.setForUpdate(forUpdate);
        this.isForUpdate = forUpdate;
    }

    public int getColumnCount() {
        return this.left.getColumnCount();
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        this.left.mapColumns(resolver, level);
        this.right.mapColumns(resolver, level);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
    }

    public void addGlobalCondition(Expression expr, int columnId, int comparisonType) throws SQLException {
        switch (this.unionType) {
            case 0: 
            case 1: 
            case 3: {
                this.left.addGlobalCondition(expr, columnId, comparisonType);
                this.right.addGlobalCondition(expr, columnId, comparisonType);
                break;
            }
            case 2: {
                this.left.addGlobalCondition(expr, columnId, comparisonType);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.unionType);
            }
        }
    }

    public String getPlan() {
        StringBuffer buff = new StringBuffer();
        buff.append('(');
        buff.append(this.left.getPlan());
        buff.append(") ");
        switch (this.unionType) {
            case 1: {
                buff.append("UNION ALL ");
                break;
            }
            case 0: {
                buff.append("UNION ");
                break;
            }
            case 3: {
                buff.append("INTERSECT ");
                break;
            }
            case 2: {
                buff.append("EXCEPT ");
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.unionType);
            }
        }
        buff.append('(');
        buff.append(this.right.getPlan());
        buff.append(')');
        Object[] exprList = new Expression[this.expressions.size()];
        this.expressions.toArray(exprList);
        if (this.sort != null) {
            buff.append(" ORDER BY ");
            buff.append(this.sort.getSQL((Expression[])exprList, exprList.length));
        }
        if (this.limit != null) {
            buff.append(" LIMIT ");
            buff.append(StringUtils.unEnclose(this.limit.getSQL()));
            if (this.offset != null) {
                buff.append(" OFFSET ");
                buff.append(StringUtils.unEnclose(this.offset.getSQL()));
            }
        }
        if (this.isForUpdate) {
            buff.append(" FOR UPDATE");
        }
        return buff.toString();
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }

    public boolean isReadOnly() {
        return this.left.isReadOnly() && this.right.isReadOnly();
    }

    public Query getLeftQuery() {
        return this.left;
    }

    public Query getRightQuery() {
        return this.right;
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
    }
}

