/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.util.HashSet;
import org.h2.command.Prepared;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Session;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public abstract class Query
extends Prepared {
    protected Expression limit;
    protected Expression offset;
    protected int sampleSize;
    private int lastLimit;
    private long lastEvaluated;
    private LocalResult lastResult;
    private Value[] lastParameters;

    abstract LocalResult queryWithoutCache(int var1) throws SQLException;

    public Query(Session session) {
        super(session);
    }

    public boolean isQuery() {
        return true;
    }

    public boolean isTransactional() {
        return true;
    }

    public final boolean sameResultAsLast(Session session, Value[] params, Value[] lastParams, long lastEvaluated) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            if (session.getDatabase().areEqual(lastParams[i], params[i])) continue;
            return false;
        }
        if (!this.isEverything(2) || !this.isEverything(0)) {
            return false;
        }
        return this.getMaxDataModificationId() <= lastEvaluated;
    }

    public final Value[] getParameterValues() throws SQLException {
        ObjectArray list = this.getParameters();
        if (list == null) {
            list = new ObjectArray();
        }
        Value[] params = new Value[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Value v;
            params[i] = v = ((Parameter)list.get(i)).getParamValue();
        }
        return params;
    }

    public final LocalResult query(int limit) throws SQLException {
        if (!this.session.getDatabase().getOptimizeReuseResults()) {
            return this.queryWithoutCache(limit);
        }
        Value[] params = this.getParameterValues();
        long now = this.session.getDatabase().getModificationDataId();
        if (this.lastResult != null && limit == this.lastLimit && this.sameResultAsLast(this.session, params, this.lastParameters, this.lastEvaluated)) {
            this.lastResult = this.lastResult.createShallowCopy(this.session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return this.lastResult;
            }
        }
        this.lastParameters = params;
        this.lastResult = this.queryWithoutCache(limit);
        this.lastEvaluated = now;
        this.lastLimit = limit;
        return this.lastResult;
    }

    protected SortOrder initOrder(ObjectArray expressions, ObjectArray orderList, int visible, boolean mustBeInResult) throws SQLException {
        int[] index = new int[orderList.size()];
        int[] sortType = new int[orderList.size()];
        int originalLength = expressions.size();
        for (int i = 0; i < orderList.size(); ++i) {
            int type;
            int idx;
            SelectOrderBy o = (SelectOrderBy)orderList.get(i);
            if (o.expression != null) {
                Expression e = o.expression;
                boolean isAlias = false;
                idx = expressions.size();
                if (e instanceof ExpressionColumn) {
                    ExpressionColumn exprCol = (ExpressionColumn)e;
                    String alias = exprCol.getOriginalAliasName();
                    String col = exprCol.getOriginalColumnName();
                    for (int j = 0; j < visible; ++j) {
                        boolean found = false;
                        Expression ec = (Expression)expressions.get(j);
                        if (ec instanceof ExpressionColumn) {
                            ExpressionColumn c = (ExpressionColumn)ec;
                            found = col.equals(c.getColumnName());
                            if (alias != null && found) {
                                found = alias.equals(c.getOriginalAliasName());
                            }
                        } else {
                            if (!(ec instanceof Alias)) continue;
                            if (col.equals(ec.getAlias())) {
                                found = true;
                            } else {
                                Expression ec2 = ec.getNonAliasExpression();
                                if (ec2 instanceof ExpressionColumn) {
                                    ExpressionColumn c2 = (ExpressionColumn)ec2;
                                    String ta = exprCol.getSQL();
                                    String tb = c2.getSQL();
                                    found = col.equals(c2.getColumnName());
                                    if (ta == null || tb == null) {
                                        if (ta != tb) {
                                            found = false;
                                        }
                                    } else if (!ta.equals(tb)) {
                                        found = false;
                                    }
                                }
                            }
                        }
                        if (!found) continue;
                        idx = j;
                        isAlias = true;
                        break;
                    }
                }
                if (!isAlias) {
                    if (mustBeInResult) {
                        throw Message.getSQLException(90068, e.getSQL());
                    }
                    expressions.add(e);
                }
            } else {
                idx = o.column;
                if (idx >= originalLength) {
                    throw Message.getSQLException(90068, "index " + idx);
                }
            }
            index[i] = idx;
            int n = type = o.descending ? 1 : 0;
            if (o.nullsFirst) {
                type += 2;
            } else if (o.nullsLast) {
                type += 4;
            }
            sortType[i] = type;
        }
        return new SortOrder(this.session.getDatabase(), index, sortType);
    }

    public void setOffset(Expression offset) {
        this.offset = offset;
    }

    public void setLimit(Expression limit) {
        this.limit = limit;
    }

    public abstract void init() throws SQLException;

    public abstract ObjectArray getExpressions();

    public abstract double getCost();

    public abstract HashSet getTables();

    public abstract void setOrder(ObjectArray var1);

    public abstract void setForUpdate(boolean var1);

    public abstract int getColumnCount();

    public abstract void mapColumns(ColumnResolver var1, int var2) throws SQLException;

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Expression var1, int var2, int var3) throws SQLException;

    public abstract void setDistinct(boolean var1);

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor visitor = ExpressionVisitor.get(4);
        this.isEverything(visitor);
        return visitor.getMaxDataModificationId();
    }

    public abstract boolean isEverything(ExpressionVisitor var1);

    public final boolean isEverything(int expressionVisitorType) {
        ExpressionVisitor visitor = ExpressionVisitor.get(expressionVisitorType);
        return this.isEverything(visitor);
    }
}

