/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.Socket;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.engine.Constants;
import org.h2.engine.SessionInterface;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.tools.SimpleResultSet;
import org.h2.util.ExactUTF8InputStreamReader;
import org.h2.util.IOUtils;
import org.h2.util.StringCache;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class Transfer {
    private static final int BUFFER_SIZE = 16384;
    private static final int LOB_MAGIC = 4660;
    protected Socket socket;
    protected DataInputStream in;
    protected DataOutputStream out;
    private Exception stackTrace = new Exception();
    private SessionInterface session;

    public Transfer(SessionInterface session) {
        this.session = session;
    }

    public void finalize() {
        if (!Constants.RUN_FINALIZERS) {
            return;
        }
        if (this.socket != null) {
            throw Message.getInternalError("not closed", this.stackTrace);
        }
    }

    public void setSocket(Socket s) {
        this.socket = s;
    }

    public void init() throws IOException {
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 16384));
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 16384));
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public Transfer writeBoolean(boolean x) throws IOException {
        this.out.writeByte((byte)(x ? 1 : 0));
        return this;
    }

    public boolean readBoolean() throws IOException {
        return this.in.readByte() == 1;
    }

    public Transfer writeByte(byte x) throws IOException {
        this.out.writeByte(x);
        return this;
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public Transfer writeInt(int i) throws IOException {
        this.out.writeInt(i);
        return this;
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public Transfer writeLong(long i) throws IOException {
        this.out.writeLong(i);
        return this;
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public Transfer writeDouble(double i) throws IOException {
        this.out.writeDouble(i);
        return this;
    }

    public Transfer writeFloat(float i) throws IOException {
        this.out.writeFloat(i);
        return this;
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public Transfer writeString(String s) throws IOException {
        if (s == null) {
            this.out.writeInt(-1);
        } else {
            int len = s.length();
            this.out.writeInt(len);
            for (int i = 0; i < len; ++i) {
                this.out.writeChar(s.charAt(i));
            }
        }
        return this;
    }

    public String readString() throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        StringBuffer buff = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            buff.append(this.in.readChar());
        }
        String s = buff.toString();
        s = StringCache.get(s);
        return s;
    }

    public Transfer writeBytes(byte[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            this.out.write(data);
        }
        return this;
    }

    public byte[] readBytes() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        byte[] b = new byte[len];
        this.in.readFully(b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.socket != null) {
            try {
                this.out.flush();
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                TraceSystem.traceThrowable(e);
            }
            finally {
                this.socket = null;
            }
        }
    }

    public void writeValue(Value v) throws IOException, SQLException {
        int type = v.getType();
        this.writeInt(type);
        switch (type) {
            case 0: {
                break;
            }
            case 12: 
            case 19: {
                this.writeBytes(v.getBytes());
                break;
            }
            case 20: {
                ValueUuid uuid = (ValueUuid)v;
                this.writeLong(uuid.getHigh());
                this.writeLong(uuid.getLow());
                break;
            }
            case 1: {
                this.writeBoolean(v.getBoolean());
                break;
            }
            case 2: {
                this.writeByte(v.getByte());
                break;
            }
            case 9: {
                this.writeLong(v.getTime().getTime());
                break;
            }
            case 10: {
                this.writeLong(v.getDate().getTime());
                break;
            }
            case 11: {
                Timestamp ts = v.getTimestamp();
                this.writeLong(ts.getTime());
                this.writeInt(ts.getNanos());
                break;
            }
            case 6: {
                this.writeString(v.getString());
                break;
            }
            case 7: {
                this.writeDouble(v.getDouble());
                break;
            }
            case 8: {
                this.writeFloat(v.getFloat());
                break;
            }
            case 4: {
                this.writeInt(v.getInt());
                break;
            }
            case 5: {
                this.writeLong(v.getLong());
                break;
            }
            case 3: {
                this.writeInt(v.getShort());
                break;
            }
            case 13: 
            case 14: {
                this.writeString(v.getString());
                break;
            }
            case 15: {
                long length = v.getPrecision();
                if (Constants.CHECK && length < 0L) {
                    throw Message.getInternalError("length: " + length);
                }
                this.writeLong(length);
                InputStream in = v.getInputStream();
                long written = IOUtils.copyAndCloseInput(in, this.out);
                if (Constants.CHECK && written != length) {
                    throw Message.getInternalError("length:" + length + " written:" + written);
                }
                this.writeInt(4660);
                break;
            }
            case 16: {
                long length = v.getPrecision();
                if (Constants.CHECK && length < 0L) {
                    throw Message.getInternalError("length: " + length);
                }
                this.writeLong(length);
                Reader reader = v.getReader();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.out, "UTF8");
                long written = IOUtils.copyAndCloseInput(reader, writer);
                if (Constants.CHECK && written != length) {
                    throw Message.getInternalError("length:" + length + " written:" + written);
                }
                ((Writer)writer).flush();
                this.writeInt(4660);
                break;
            }
            case 17: {
                Value[] list = ((ValueArray)v).getList();
                this.writeInt(list.length);
                for (int i = 0; i < list.length; ++i) {
                    this.writeValue(list[i]);
                }
                break;
            }
            case 18: {
                int i;
                ResultSet rs = ((ValueResultSet)v).getResultSet();
                rs.beforeFirst();
                ResultSetMetaData meta = rs.getMetaData();
                int columnCount = meta.getColumnCount();
                this.writeInt(columnCount);
                for (i = 0; i < columnCount; ++i) {
                    this.writeString(meta.getColumnName(i + 1));
                    this.writeInt(meta.getColumnType(i + 1));
                    this.writeInt(meta.getPrecision(i + 1));
                    this.writeInt(meta.getScale(i + 1));
                }
                while (rs.next()) {
                    this.writeBoolean(true);
                    for (i = 0; i < columnCount; ++i) {
                        int t = DataType.convertSQLTypeToValueType(meta.getColumnType(i + 1));
                        Value val = DataType.readValue(this.session, rs, i + 1, t);
                        this.writeValue(val);
                    }
                }
                this.writeBoolean(false);
                rs.beforeFirst();
                break;
            }
            default: {
                throw Message.getInternalError("type=" + type);
            }
        }
    }

    public Value readValue() throws IOException, SQLException {
        int type = this.readInt();
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                return ValueBytes.get(this.readBytes());
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 19: {
                return ValueJavaObject.get(this.readBytes());
            }
            case 1: {
                return ValueBoolean.get(this.readBoolean());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 10: {
                return ValueDate.get(new Date(this.readLong()));
            }
            case 9: {
                return ValueTime.get(new Time(this.readLong()));
            }
            case 11: {
                Timestamp ts = new Timestamp(this.readLong());
                ts.setNanos(this.readInt());
                return ValueTimestamp.get(ts);
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 7: {
                return ValueDouble.get(this.readDouble());
            }
            case 8: {
                return ValueFloat.get(this.readFloat());
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 15: {
                long length = this.readLong();
                ValueLob v = ValueLob.createBlob(this.in, length, this.session.getDataHandler());
                if (this.readInt() != 4660) {
                    throw Message.getSQLException(90067);
                }
                return v;
            }
            case 16: {
                long length = this.readLong();
                ValueLob v = ValueLob.createClob(new ExactUTF8InputStreamReader(this.in), length, this.session.getDataHandler());
                if (this.readInt() != 4660) {
                    throw Message.getSQLException(90067);
                }
                return v;
            }
            case 17: {
                int len = this.readInt();
                Value[] list = new Value[len];
                for (int i = 0; i < len; ++i) {
                    list[i] = this.readValue();
                }
                return ValueArray.get(list);
            }
            case 18: {
                SimpleResultSet rs = new SimpleResultSet();
                int columns = this.readInt();
                for (int i = 0; i < columns; ++i) {
                    rs.addColumn(this.readString(), this.readInt(), this.readInt(), this.readInt());
                }
                while (this.readBoolean()) {
                    Object[] o = new Object[columns];
                    for (int i = 0; i < columns; ++i) {
                        o[i] = this.readValue().getObject();
                    }
                    rs.addRow(o);
                }
                return ValueResultSet.get(rs);
            }
        }
        throw Message.getInternalError("type=" + type);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSession(SessionInterface session) {
        this.session = session;
    }
}

