/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.message.Message;
import org.h2.util.StringUtils;

public class Backup {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " -url <url> -user <user> [-password <pwd>] [-script <file>] [-options <option> ...]");
    }

    public static void main(String[] args) throws SQLException {
        new Backup().run(args);
    }

    private void run(String[] args) throws SQLException {
        String url = null;
        String user = null;
        String password = "";
        String script = "backup.sql";
        String options1 = null;
        String options2 = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-url")) {
                url = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-password")) {
                password = args[++i];
                continue;
            }
            if (args[i].equals("-script")) {
                script = args[++i];
                continue;
            }
            if (args[i].equals("-options")) {
                StringBuffer buff1 = new StringBuffer();
                StringBuffer buff2 = new StringBuffer();
                ++i;
                while (i < args.length) {
                    String a = args[i];
                    String upper = StringUtils.toUpperEnglish(a);
                    if (upper.startsWith("NO") || upper.equals("DROP")) {
                        buff1.append(' ');
                        buff1.append(args[i]);
                    } else {
                        buff2.append(' ');
                        buff2.append(args[i]);
                    }
                    ++i;
                }
                options1 = buff1.toString();
                options2 = buff2.toString();
                continue;
            }
            this.showUsage();
            return;
        }
        if (url == null || user == null || script == null) {
            this.showUsage();
            return;
        }
        if (options1 != null) {
            Backup.executeScript(url, user, password, script, options1, options2);
        } else {
            Backup.execute(url, user, password, script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeScript(String url, String user, String password, String fileName, String options1, String options2) throws SQLException {
        try {
            Driver.load();
            Connection conn = DriverManager.getConnection(url, user, password);
            Statement stat = conn.createStatement();
            String sql = "SCRIPT " + options1 + " TO '" + fileName + "' " + options2;
            try {
                stat.execute(sql);
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    public static void execute(String url, String user, String password, String script) throws SQLException {
        try {
            Driver.load();
            Connection conn = DriverManager.getConnection(url, user, password);
            Statement stat = conn.createStatement();
            FileWriter fileWriter = new FileWriter(script);
            PrintWriter writer = new PrintWriter(new BufferedWriter(fileWriter));
            ResultSet rs = stat.executeQuery("SCRIPT");
            while (rs.next()) {
                String s = rs.getString(1);
                writer.println(s + ";");
            }
            writer.close();
            fileWriter.close();
            conn.close();
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }
}

