/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.server.web.DbSchema;
import org.h2.util.StringUtils;

public class DbContents {
    DbSchema[] schemas;
    DbSchema defaultSchema;
    boolean isOracle;
    boolean isH2;
    boolean isPostgreSQL;
    boolean isHSQLDB;
    boolean isMySQL;
    boolean isDerby;
    boolean isFirebird;
    boolean isSQLite;

    void readContents(DatabaseMetaData meta) throws SQLException {
        int i;
        String prod = StringUtils.toLowerEnglish(meta.getDatabaseProductName());
        this.isSQLite = prod.indexOf("sqlite") >= 0;
        String url = meta.getURL();
        if (url != null) {
            this.isH2 = url.startsWith("jdbc:h2:");
            this.isOracle = url.startsWith("jdbc:oracle:");
            this.isPostgreSQL = url.startsWith("jdbc:postgresql:");
            this.isHSQLDB = url.startsWith("jdbc:hsqldb:");
            this.isMySQL = url.startsWith("jdbc:mysql:");
            this.isDerby = url.startsWith("jdbc:derby:");
            this.isFirebird = url.startsWith("jdbc:firebirdsql:");
        }
        String defaultSchemaName = this.getDefaultSchemaName(meta);
        String[] schemaNames = this.getSchemaNames(meta);
        this.schemas = new DbSchema[schemaNames.length];
        for (i = 0; i < schemaNames.length; ++i) {
            String schemaName = schemaNames[i];
            boolean isDefault = defaultSchemaName == null || defaultSchemaName.equals(schemaName);
            DbSchema schema = new DbSchema(this, schemaName, isDefault);
            if (schema.isDefault) {
                this.defaultSchema = schema;
            }
            this.schemas[i] = schema;
            String[] tableTypes = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "SYSTEM VIEW", "TABLE LINK", "SYNONYM"};
            schema.readTables(meta, tableTypes);
        }
        if (this.defaultSchema == null) {
            for (i = 0; i < this.schemas.length; ++i) {
                String best = null;
                if ("dbo".equals(this.schemas[i].name)) {
                    this.defaultSchema = this.schemas[i];
                    break;
                }
                if (this.defaultSchema != null && best != null && this.schemas[i].name.length() >= best.length()) continue;
                best = this.schemas[i].name;
                this.defaultSchema = this.schemas[i];
            }
        }
    }

    private String[] getSchemaNames(DatabaseMetaData meta) throws SQLException {
        if (this.isMySQL) {
            return new String[]{""};
        }
        if (this.isFirebird) {
            return new String[]{null};
        }
        ResultSet rs = meta.getSchemas();
        ArrayList<String> schemas = new ArrayList<String>();
        while (rs.next()) {
            String schema = rs.getString("TABLE_SCHEM");
            if (schema == null) continue;
            schemas.add(schema);
        }
        rs.close();
        String[] list = new String[schemas.size()];
        schemas.toArray(list);
        return list;
    }

    private String getDefaultSchemaName(DatabaseMetaData meta) throws SQLException {
        String defaultSchemaName = "";
        try {
            if (this.isOracle) {
                return meta.getUserName();
            }
            if (this.isPostgreSQL) {
                return "public";
            }
            if (this.isMySQL) {
                return "";
            }
            if (this.isDerby) {
                return StringUtils.toUpperEnglish(meta.getUserName());
            }
            if (this.isFirebird) {
                return null;
            }
            ResultSet rs = meta.getSchemas();
            int index = rs.findColumn("IS_DEFAULT");
            while (rs.next()) {
                if (!rs.getBoolean(index)) continue;
                defaultSchemaName = rs.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return defaultSchemaName;
    }

    String quoteIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (this.isH2) {
            return Parser.quoteIdentifier(identifier);
        }
        return StringUtils.toUpperEnglish(identifier);
    }
}

