/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.h2.engine.ConnectionInfo;
import org.h2.message.Message;
import org.h2.server.OdbcServer;
import org.h2.server.OdbcTransfer;
import org.h2.util.StringUtils;

public class OdbcServerThread
implements Runnable {
    private OdbcServer server;
    private Socket socket;
    private Connection conn;
    private DatabaseMetaData meta;
    private boolean stop;
    private int cacheId;
    private Object cache;
    private OdbcTransfer transfer;
    private Thread thread;
    private BufferedOutputStream outBuff;
    private HashMap object = new HashMap();
    private int nextId;

    OdbcServerThread(Socket socket, OdbcServer server) {
        this.server = server;
        this.socket = socket;
    }

    private int addObject(Object o) {
        int id = this.nextId++;
        this.server.log("addObj " + id + " " + o);
        this.object.put(new Integer(id), o);
        this.cacheId = id;
        this.cache = o;
        return id;
    }

    private void freeObject(int id) {
        if (this.cacheId == id) {
            this.cacheId = -1;
            this.cache = null;
        }
        this.object.remove(new Integer(id));
    }

    private Object getObject(int id) {
        if (id == this.cacheId) {
            this.server.log("getObj " + id + " " + this.cache);
            return this.cache;
        }
        this.server.log("getObj " + id + " " + this.object.get(new Integer(id)));
        return this.object.get(new Integer(id));
    }

    public void run() {
        try {
            this.server.log("Connect");
            InputStream ins = this.socket.getInputStream();
            OutputStream outs = this.socket.getOutputStream();
            DataInputStream in = new DataInputStream(new BufferedInputStream(ins, 1024));
            this.outBuff = new BufferedOutputStream(outs, 1024);
            DataOutputStream out = new DataOutputStream(this.outBuff);
            this.transfer = new OdbcTransfer(in, out);
            this.outBuff.flush();
            while (!this.stop) {
                this.process();
                this.outBuff.flush();
            }
            this.server.log("Disconnect");
        }
        catch (Exception e) {
            this.server.logError(e);
        }
    }

    public void close() {
        try {
            this.stop = true;
            this.conn.close();
            this.socket.close();
            this.server.log("Close");
        }
        catch (Exception e) {
            this.server.logError(e);
        }
        this.conn = null;
        this.socket = null;
        this.server.remove(this);
    }

    private void sendError(Throwable e) throws IOException {
        SQLException s = Message.convert(e);
        this.server.log("Exception " + s);
        s.printStackTrace();
        this.transfer.writeByte((byte)69);
    }

    private void processResultSet(ResultSet rs) throws IOException, SQLException {
        int id = this.addObject(rs);
        this.transfer.writeInt(id);
        ResultSetMetaData m = rs.getMetaData();
        int columnCount = m.getColumnCount();
        this.transfer.writeInt(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            this.transfer.writeInt(this.mapType(m.getColumnType(i + 1)));
            this.transfer.writeString(m.getTableName(i + 1));
            this.transfer.writeString(m.getColumnLabel(i + 1));
            this.transfer.writeInt(m.getPrecision(i + 1));
            this.transfer.writeInt(m.getScale(i + 1));
            this.transfer.writeInt(m.getColumnDisplaySize(i + 1));
        }
    }

    private void setParameter(PreparedStatement prep, int index, int type) throws SQLException, IOException {
        switch (type) {
            case 0: {
                prep.setNull(index, 4);
                break;
            }
            case 4: {
                int value = this.transfer.readInt();
                this.server.log("  index=" + index + " int=" + value);
                prep.setInt(index, value);
                break;
            }
            case 12: {
                String value = this.transfer.readString();
                this.server.log("  index=" + index + " string=" + value);
                prep.setString(index, value);
                break;
            }
            default: {
                throw Message.getInternalError("unexpected data type " + type);
            }
        }
    }

    private void setParameters(PreparedStatement prep) throws SQLException, IOException {
        int x;
        while ((x = this.transfer.readByte()) != 48) {
            if (x == 49) {
                int index = this.transfer.readInt();
                int type = this.transfer.readInt();
                this.setParameter(prep, index + 1, type);
                continue;
            }
            throw Message.getInternalError("unexpected " + x);
        }
    }

    private void processMeta() throws IOException {
        int operation = this.transfer.readByte();
        this.server.log("meta op=" + (char)operation);
        switch (operation) {
            case 66: {
                String catalog = this.transfer.readString();
                String schema = this.transfer.readString();
                String table = this.transfer.readString();
                if (table == null || table.length() == 0) {
                    table = "%";
                }
                int scope = this.transfer.readInt();
                boolean nullable = this.transfer.readBoolean();
                try {
                    ResultSet rs = this.meta.getBestRowIdentifier(catalog, schema, table, scope, nullable);
                    this.processResultSet(rs);
                }
                catch (Throwable e) {
                    this.sendError(e);
                }
                break;
            }
            case 67: {
                String schemaPattern = this.transfer.readString();
                String tableNamePattern = this.transfer.readString();
                String columnNamePattern = this.transfer.readString();
                if (tableNamePattern == null || tableNamePattern.length() == 0) {
                    tableNamePattern = "%";
                }
                if (columnNamePattern == null || columnNamePattern.length() == 0) {
                    columnNamePattern = "%";
                }
                try {
                    PreparedStatement prep = this.conn.prepareStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, TYPE_NAME, CHARACTER_MAXIMUM_LENGTH COLUMN_SIZE, CHARACTER_MAXIMUM_LENGTH BUFFER_LENGTH, CAST(NUMERIC_SCALE AS SMALLINT) DECIMAL_DIGITS, CAST(10 AS SMALLINT) NUM_PREC_RADIX, CAST(NULLABLE AS SMALLINT) NULLABLE, '' REMARKS, COLUMN_DEFAULT COLUMN_DEF, CAST(DATA_TYPE AS SMALLINT) SQL_DATA_TYPE, CAST(0 AS SMALLINT) SQL_DATETIME_SUB, CHARACTER_OCTET_LENGTH CHAR_OCTET_LENGTH, ORDINAL_POSITION ORDINAL_POSITION, NULLABLE IS_NULLABLE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA LIKE ? AND TABLE_NAME LIKE ? AND COLUMN_NAME LIKE ? ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
                    prep.setString(1, schemaPattern == null ? "%" : schemaPattern);
                    prep.setString(2, tableNamePattern == null ? "%" : tableNamePattern);
                    prep.setString(3, columnNamePattern == null ? "%" : columnNamePattern);
                    ResultSet rs = prep.executeQuery();
                    this.processResultSet(rs);
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            case 68: {
                String where;
                if (this.transfer.readByte() == 65) {
                    where = "";
                } else {
                    int type = this.transfer.readInt();
                    where = " WHERE TYPE=" + type + " ";
                }
                try {
                    ResultSet rs = this.conn.createStatement().executeQuery("SELECT TYPE_NAME, DATA_TYPE, PRECISION COLUMN_SIZE, PREFIX LITERAL_PREFIX, PREFIX LITERAL_SUFFIX, PARAMS CREATE_PARAMS, CAST(1 AS SMALLINT) NULLABLE, CAST(1 AS SMALLINT) CASE_SENSITIVE, CAST(1 AS SMALLINT) SEARCHABLE, CAST(0 AS SMALLINT) UNSIGNED_ATTRIBUTE, CAST(0 AS SMALLINT) FIXED_PREC_SCALE, CAST(0 AS SMALLINT) AUTO_UNIQUE_VALUE, TYPE_NAME LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE, DATA_TYPE SQL_DATA_TYPE, CAST(1 AS SMALLINT) SQL_DATETIME_SUB, RADIX NUM_PREC_RADIX, CAST(0 AS SMALLINT) INTERVAL_PRECISION FROM INFORMATION_SCHEMA.TYPE_INFO " + where + "ORDER BY DATA_TYPE, POS");
                    this.processResultSet(rs);
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            case 73: {
                String schemaPattern = this.transfer.readString();
                String tableNamePattern = this.transfer.readString();
                if (tableNamePattern == null || tableNamePattern.length() == 0) {
                    tableNamePattern = "%";
                }
                try {
                    PreparedStatement prep = this.conn.prepareStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, CAST(NON_UNIQUE AS SMALLINT) NON_UNIQUE, TABLE_CATALOG INDEX_QUALIFIER, INDEX_NAME, CAST(3 AS SMALLINT) TYPE, ORDINAL_POSITION, COLUMN_NAME, 'A' ASC_OR_DESC, CARDINALITY, 0 PAGES, '' FILTER_CONDITION FROM INFORMATION_SCHEMA.INDEXES WHERE CATALOG_NAME LIKE ? AND TABLE_NAME LIKE ? ORDER BY NON_UNIQUE, TYPE, TABLE_SCHEM, INDEX_NAME, ORDINAL_POSITION");
                    prep.setString(1, schemaPattern);
                    prep.setString(2, tableNamePattern);
                    ResultSet rs = prep.executeQuery();
                    this.processResultSet(rs);
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            case 78: {
                String sql = this.transfer.readString();
                try {
                    sql = this.conn.nativeSQL(sql);
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                this.transfer.writeString(sql);
                break;
            }
            case 84: {
                String catalog = this.transfer.readString();
                String schema = this.transfer.readString();
                String table = this.transfer.readString();
                String tableTypes = this.transfer.readString();
                this.server.log(" catalog=" + catalog + " schema=" + schema + " table=" + table + " tableTypes=" + tableTypes);
                String[] types = null;
                try {
                    ResultSet rs;
                    if (catalog.equals("%") && schema.length() == 0 && table.length() == 0) {
                        this.server.log(" allCatalogs");
                        PreparedStatement prep = this.conn.prepareStatement("SELECT CATALOG_NAME TABLE_CAT, NULL TABLE_SCHEM, NULL TABLE_NAME, NULL TABLE_TYPE, '' REMARKS FROM INFORMATION_SCHEMA.CATALOGS");
                        rs = prep.executeQuery();
                    } else if (catalog.length() == 0 && schema.equals("%") && table.length() == 0) {
                        this.server.log(" allSchemas");
                        PreparedStatement prep = this.conn.prepareStatement("SELECT CATALOG_NAME TABLE_CAT, SCHEMA_NAME TABLE_SCHEM, NULL TABLE_NAME, NULL TABLE_TYPE, '' REMARKS FROM INFORMATION_SCHEMA.SCHEMATA");
                        rs = prep.executeQuery();
                    } else if (catalog.length() == 0 && schema.length() == 0 && table.length() == 0 && tableTypes.equals("%")) {
                        this.server.log(" allTableTypes");
                        PreparedStatement prep = this.conn.prepareStatement("SELECT NULL TABLE_CAT, NULL TABLE_SCHEM, NULL TABLE_NAME, TYPE TABLE_TYPE, '' REMARKS FROM  INFORMATION_SCHEMA.TABLE_TYPES");
                        rs = prep.executeQuery();
                    } else {
                        this.server.log(" getTables");
                        if (tableTypes.equals("%") || tableTypes.length() == 0) {
                            types = null;
                        } else {
                            types = StringUtils.arraySplit(tableTypes, ',', false);
                            for (int i = 0; i < types.length; ++i) {
                                String t = StringUtils.toUpperEnglish(types[i]);
                                if (t.startsWith("'")) {
                                    t = t.substring(1, t.length() - 2);
                                }
                                types[i] = t;
                            }
                        }
                        this.server.log("getTables " + catalog + " " + schema + " " + table);
                        if (table.length() == 0) {
                            table = null;
                        }
                        rs = this.meta.getTables(catalog, schema, table, types);
                    }
                    this.processResultSet(rs);
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            case 86: {
                String catalog = this.transfer.readString();
                String schema = this.transfer.readString();
                String table = this.transfer.readString();
                if (table == null || table.length() == 0) {
                    table = "%";
                }
                try {
                    ResultSet rs = this.meta.getVersionColumns(catalog, schema, table);
                    this.processResultSet(rs);
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            default: {
                this.server.log("meta operation? " + (char)operation);
            }
        }
    }

    private void process() throws IOException {
        int operation = this.transfer.readByte();
        if (operation == -1) {
            this.stop = true;
            return;
        }
        this.server.log("op=" + (char)operation);
        block6 : switch (operation) {
            case 65: {
                try {
                    int op = this.transfer.readByte();
                    switch (op) {
                        case 48: {
                            this.server.log("autoCommit false");
                            this.conn.setAutoCommit(false);
                            break block6;
                        }
                        case 49: {
                            this.server.log("autoCommit true");
                            this.conn.setAutoCommit(true);
                            break block6;
                        }
                        case 67: {
                            this.server.log("commit");
                            this.conn.commit();
                            break block6;
                        }
                        case 82: {
                            this.server.log("rollback");
                            this.conn.rollback();
                            break block6;
                        }
                    }
                    this.server.log("operation? " + (char)operation);
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            case 67: {
                this.server.log("connect");
                String db = this.transfer.readString();
                this.server.log(" db=" + db);
                String user = this.transfer.readString();
                this.server.log(" user=" + user);
                String password = this.transfer.readString();
                this.server.log(" password=" + password);
                String baseDir = this.server.getBaseDir();
                ConnectionInfo ci = new ConnectionInfo(db);
                if (baseDir != null) {
                    ci.setBaseDir(baseDir);
                }
                if (this.server.getIfExists()) {
                    ci.setProperty("IFEXISTS", "TRUE");
                }
                String dbName = ci.getDatabaseName();
                try {
                    this.conn = DriverManager.getConnection("jdbc:h2:" + dbName, user, password);
                    this.meta = this.conn.getMetaData();
                    this.transfer.writeByte((byte)79);
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            case 69: {
                String sql = this.transfer.readString();
                this.server.log("<" + sql + ">");
                try {
                    int params = this.getParametersCount(sql);
                    if (params > 0) {
                        PreparedStatement prep = this.conn.prepareStatement(sql);
                        int id = this.addObject(prep);
                        this.transfer.writeByte((byte)79);
                        this.transfer.writeInt(id);
                        this.transfer.writeInt(params);
                        break;
                    }
                    Statement stat = this.conn.createStatement();
                    boolean isResultSet = stat.execute(sql);
                    if (isResultSet) {
                        this.transfer.writeByte((byte)82);
                        ResultSet rs = stat.getResultSet();
                        this.processResultSet(rs);
                        break;
                    }
                    this.transfer.writeByte((byte)85);
                    this.transfer.writeInt(stat.getUpdateCount());
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            case 70: {
                int id = this.transfer.readInt();
                this.server.log("free " + id);
                this.freeObject(id);
                break;
            }
            case 71: {
                int objectId = this.transfer.readInt();
                ResultSet rs = (ResultSet)this.getObject(objectId);
                try {
                    boolean hasNext = rs.next();
                    if (hasNext) {
                        this.transfer.writeByte((byte)49);
                        ResultSetMetaData m = rs.getMetaData();
                        int columnCount = m.getColumnCount();
                        for (int i = 0; i < columnCount; ++i) {
                            this.write(m, rs, i);
                        }
                        break;
                    }
                    this.transfer.writeByte((byte)48);
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            case 77: {
                this.processMeta();
                break;
            }
            case 80: {
                String sql = this.transfer.readString();
                this.server.log("<" + sql + ">");
                try {
                    PreparedStatement prep = this.conn.prepareStatement(sql);
                    int id = this.addObject(prep);
                    this.transfer.writeByte((byte)79);
                    this.transfer.writeInt(id);
                    int params = this.getParametersCount(sql);
                    this.transfer.writeInt(params);
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            case 81: {
                int id = this.transfer.readInt();
                PreparedStatement prep = (PreparedStatement)this.getObject(id);
                try {
                    this.setParameters(prep);
                    boolean isResultSet = prep.execute();
                    if (isResultSet) {
                        this.transfer.writeByte((byte)82);
                        ResultSet rs = prep.getResultSet();
                        this.processResultSet(rs);
                        break;
                    }
                    this.transfer.writeByte((byte)85);
                    this.transfer.writeInt(prep.getUpdateCount());
                }
                catch (SQLException e) {
                    this.sendError(e);
                }
                break;
            }
            case 88: {
                this.stop = true;
                break;
            }
            default: {
                this.server.log("operation? " + (char)operation);
            }
        }
    }

    private void write(ResultSetMetaData m, ResultSet rs, int i) throws IOException {
        try {
            int type = this.mapType(m.getColumnType(i + 1));
            switch (type) {
                case 4: 
                case 5: {
                    int value = rs.getInt(i + 1);
                    if (rs.wasNull()) {
                        this.transfer.writeBoolean(true);
                        break;
                    }
                    this.transfer.writeBoolean(false);
                    this.transfer.writeInt(value);
                    break;
                }
                case 0: {
                    break;
                }
                case 12: {
                    this.transfer.writeString(rs.getString(i + 1));
                    break;
                }
                default: {
                    throw Message.getInternalError("unsupported data type " + type);
                }
            }
        }
        catch (SQLException e) {
            this.sendError(e);
        }
    }

    int mapType(int sqlType) {
        switch (sqlType) {
            case 0: 
            case 4: 
            case 5: 
            case 12: {
                return sqlType;
            }
            case -7: 
            case -6: 
            case 16: {
                return 4;
            }
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2004: {
                return 12;
            }
        }
        throw Message.getInternalError("sqlType " + sqlType);
    }

    int getParametersCount(String sql) throws SQLException {
        if (sql == null || sql.indexOf(63) < 0) {
            return 0;
        }
        int len = sql.length();
        int param = 0;
        for (int i = 0; i < len; ++i) {
            try {
                char c = sql.charAt(i);
                switch (c) {
                    case '\'': {
                        int j = sql.indexOf(39, i + 1);
                        if (j < 0) {
                            throw Message.getSyntaxError(sql, i);
                        }
                        i = j;
                        break;
                    }
                    case '\"': {
                        int j = sql.indexOf(34, i + 1);
                        if (j < 0) {
                            throw Message.getSyntaxError(sql, i);
                        }
                        i = j;
                        break;
                    }
                    case '/': {
                        int j;
                        if (sql.charAt(i + 1) == '*') {
                            j = sql.indexOf("*/", i + 2);
                            if (j < 0) {
                                throw Message.getSyntaxError(sql, i);
                            }
                            i = j + 1;
                            break;
                        }
                        if (sql.charAt(i + 1) != '/') break;
                        i += 2;
                        while (i < len && (c = sql.charAt(i)) != '\r' && c != '\n') {
                            ++i;
                        }
                        break;
                    }
                    case '-': {
                        if (sql.charAt(i + 1) != '-') break;
                        i += 2;
                        while (i < len && (c = sql.charAt(i)) != '\r' && c != '\n') {
                            ++i;
                        }
                        break;
                    }
                    case '?': {
                        ++param;
                    }
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw Message.getSyntaxError(sql, i);
            }
        }
        return param;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }
}

