/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Random;
import org.h2.command.Command;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Engine;
import org.h2.engine.SessionInterface;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.schema.Schema;
import org.h2.store.DataHandler;
import org.h2.store.InDoubtTransaction;
import org.h2.store.LogSystem;
import org.h2.store.UndoLog;
import org.h2.store.UndoLogRecord;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;

public class Session
implements SessionInterface {
    private User user;
    private int id;
    private Database database;
    private ObjectArray locks = new ObjectArray();
    private UndoLog undoLog;
    private boolean autoCommit = true;
    private Random random;
    private LogSystem logSystem;
    private int lockTimeout;
    private long lastIdentity;
    private int firstUncommittedLog = -1;
    private int firstUncommittedPos = -1;
    private HashMap savepoints;
    private Exception stackTrace = new Exception();
    private HashMap localTempTables;
    private int throttle;
    private long lastThrottle;
    private Command currentCommand;
    private boolean allowLiterals;
    private String currentSchemaName;
    private String traceModuleName;

    public Table findLocalTempTable(String name) {
        Table t = null;
        if (t == null && this.localTempTables != null) {
            t = (Table)this.localTempTables.get(name);
        }
        return t;
    }

    public ObjectArray getLocalTempTables() {
        if (this.localTempTables == null) {
            return new ObjectArray();
        }
        ObjectArray list = new ObjectArray(this.localTempTables.values());
        return list;
    }

    public String getNewLocalTempTransactionTableName() {
        String name = "TEMP_TRANS_TABLE_";
        int i = 0;
        String n;
        while (this.findLocalTempTable(n = name + i) != null) {
            ++i;
        }
        return n;
    }

    public void addLocalTempTable(TableData table) throws SQLException {
        this.cleanTempTables();
        if (this.localTempTables == null) {
            this.localTempTables = new HashMap();
        }
        if (this.localTempTables.get(table.getName()) != null) {
            throw Message.getSQLException(42101, table.getSQL());
        }
        this.localTempTables.put(table.getName(), table);
    }

    public void removeLocalTempTable(Table table) throws SQLException {
        this.localTempTables.remove(table.getName());
        table.removeChildrenAndResources(this);
    }

    public void finalize() {
        if (!Constants.RUN_FINALIZERS) {
            return;
        }
        if (this.database != null) {
            throw Message.getInternalError("not closed", this.stackTrace);
        }
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public User getUser() {
        return this.user;
    }

    public void setAutoCommit(boolean b) {
        this.autoCommit = b;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public Session() {
    }

    public SessionInterface createSession(ConnectionInfo ci) throws SQLException {
        return Engine.getInstance().getSession(ci);
    }

    Session(Database database, User user, int id) {
        this.database = database;
        this.undoLog = new UndoLog(this);
        this.user = user;
        this.id = id;
        this.logSystem = database.getLog();
        Setting setting = database.findSetting(SetTypes.getTypeName(6));
        this.lockTimeout = setting == null ? 1000 : setting.getIntValue();
        this.currentSchemaName = "PUBLIC";
    }

    public CommandInterface prepareCommand(String sql) throws SQLException {
        return this.prepareLocal(sql);
    }

    public Prepared prepare(String sql) throws SQLException {
        return this.prepare(sql, false);
    }

    public Prepared prepare(String sql, boolean rightsChecked) throws SQLException {
        Parser parser = new Parser(this);
        parser.setRightsChecked(rightsChecked);
        return parser.prepare(sql);
    }

    public Command prepareLocal(String sql) throws SQLException {
        if (this.database == null) {
            throw Message.getSQLException(90067);
        }
        Parser parser = new Parser(this);
        return parser.prepareCommand(sql);
    }

    public Database getDatabase() {
        return this.database;
    }

    public int getPowerOffCount() {
        return this.database == null ? 0 : this.database.getPowerOffCount();
    }

    public void setPowerOffCount(int count) {
        if (this.database != null) {
            this.database.setPowerOffCount(count);
        }
    }

    public void commit() throws SQLException {
        if (this.containsUncommitted()) {
            this.logSystem.commit(this);
        }
        if (this.undoLog.size() > 0) {
            this.undoLog.clear();
            this.cleanTempTables();
        }
        this.unlockAll();
    }

    public void rollback() throws SQLException {
        boolean needCommit = false;
        if (this.undoLog.size() > 0) {
            this.rollbackTo(0);
            needCommit = true;
        }
        if (this.locks.size() > 0 || needCommit) {
            this.logSystem.commit(this);
        }
        this.cleanTempTables();
        this.unlockAll();
    }

    public void rollbackTo(int index) throws SQLException {
        while (this.undoLog.size() > index) {
            UndoLogRecord entry = this.undoLog.getAndRemoveLast();
            entry.undo(this);
        }
        if (this.savepoints != null) {
            String[] names = new String[this.savepoints.size()];
            this.savepoints.keySet().toArray(names);
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                Integer id = (Integer)this.savepoints.get(names[i]);
                if (id <= index) continue;
                this.savepoints.remove(name);
            }
        }
    }

    public int getLogId() {
        return this.undoLog.size();
    }

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.database != null) {
            try {
                this.database.removeSession(this);
            }
            finally {
                this.database = null;
            }
        }
    }

    public void addLock(Table table) {
        if (Constants.CHECK && this.locks.indexOf(table) >= 0) {
            throw Message.getInternalError();
        }
        this.locks.add(table);
    }

    public void log(UndoLogRecord log) throws SQLException {
        int lockMode;
        if (Constants.CHECK && (lockMode = this.database.getLockMode()) != 0 && this.locks.indexOf(log.getTable()) < 0 && log.getTable().getTableType() != "TABLE LINK") {
            throw Message.getInternalError();
        }
        this.undoLog.add(log);
    }

    private void unlockAll() throws SQLException {
        if (Constants.CHECK && this.undoLog.size() > 0) {
            throw Message.getInternalError();
        }
        for (int i = 0; i < this.locks.size(); ++i) {
            Table t = (Table)this.locks.get(i);
            t.unlock(this);
        }
        this.locks.clear();
        this.savepoints = null;
    }

    private void cleanTempTables() throws SQLException {
        if (this.localTempTables != null && this.localTempTables.size() > 0) {
            ObjectArray list = new ObjectArray(this.localTempTables.values());
            for (int i = 0; i < list.size(); ++i) {
                TableData table = (TableData)list.get(i);
                if (table.isOnCommitDrop()) {
                    table.setModified();
                    this.localTempTables.remove(table.getName());
                    table.removeChildrenAndResources(this);
                    continue;
                }
                if (!table.isOnCommitTruncate()) continue;
                table.truncate(this);
            }
        }
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    public Trace getTrace() {
        if (this.traceModuleName == null) {
            this.traceModuleName = "jdbc[" + this.id + "]";
        }
        if (this.database == null) {
            return new TraceSystem(null).getTrace(this.traceModuleName);
        }
        return this.database.getTrace(this.traceModuleName);
    }

    public void setLastIdentity(long last) {
        this.lastIdentity = last;
    }

    public long getLastIdentity() {
        return this.lastIdentity;
    }

    public void addLogPos(int logId, int pos) {
        if (this.firstUncommittedLog == -1) {
            this.firstUncommittedLog = logId;
            this.firstUncommittedPos = pos;
        }
    }

    public int getFirstUncommittedLog() {
        return this.firstUncommittedLog;
    }

    public int getFirstUncommittedPos() {
        return this.firstUncommittedPos;
    }

    public void setAllCommitted() {
        this.firstUncommittedLog = -1;
        this.firstUncommittedPos = -1;
    }

    private boolean containsUncommitted() {
        return this.firstUncommittedLog != -1;
    }

    public void addSavepoint(String name) {
        if (this.savepoints == null) {
            this.savepoints = new HashMap();
        }
        this.savepoints.put(name, new Integer(this.getLogId()));
    }

    public void rollbackToSavepoint(String name) throws SQLException {
        if (this.savepoints == null) {
            throw Message.getSQLException(90063, name);
        }
        Integer id = (Integer)this.savepoints.get(name);
        if (id == null) {
            throw Message.getSQLException(90063, name);
        }
        int i = id;
        this.rollbackTo(i);
    }

    public void prepareCommit(String transactionName) throws SQLException {
        if (this.containsUncommitted()) {
            this.logSystem.prepareCommit(this, transactionName);
        }
    }

    public void setPreparedTransaction(String transactionName, boolean commit) throws SQLException {
        ObjectArray list = this.logSystem.getInDoubtTransactions();
        int state = commit ? 1 : 2;
        for (int i = 0; list != null && i < list.size(); ++i) {
            InDoubtTransaction p = (InDoubtTransaction)list.get(i);
            if (!p.getTransaction().equals(transactionName)) continue;
            p.setState(state);
        }
    }

    public boolean isClosed() {
        return this.database == null;
    }

    public void setThrottle(int throttle) {
        this.throttle = throttle;
    }

    public void throttle() {
        if (this.throttle == 0) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.lastThrottle + 50L > time) {
            return;
        }
        this.lastThrottle = time + (long)this.throttle;
        try {
            Thread.sleep(this.throttle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentCommand(Command command) {
        this.currentCommand = command;
    }

    public void checkCancelled() throws SQLException {
        if (this.currentCommand != null) {
            this.currentCommand.checkCancelled();
        }
    }

    public boolean getAllowLiterals() {
        return this.allowLiterals;
    }

    public void setAllowLiterals(boolean b) {
        this.allowLiterals = b;
    }

    public void setCurrentSchema(Schema schema) {
        this.currentSchemaName = schema.getName();
    }

    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public JdbcConnection createConnection(boolean columnList) throws SQLException {
        String url = columnList ? "jdbc:default:connection" : "jdbc:default:connection";
        return new JdbcConnection(this, this.getUser().getName(), url);
    }

    public DataHandler getDataHandler() {
        return this.database;
    }
}

