/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystemDatabase;

public class FileObjectDatabase
implements FileObject {
    private FileSystemDatabase db;
    private String fileName;
    private byte[] data;
    private int pos;
    private int length;
    private boolean changed;

    FileObjectDatabase(FileSystemDatabase fileSystemDatabase, String string, byte[] byArray, boolean bl) {
        this.db = fileSystemDatabase;
        this.fileName = string;
        this.data = byArray;
        this.length = byArray.length;
        this.changed = bl;
    }

    public void close() throws IOException {
        this.sync();
    }

    public long getFilePointer() throws IOException {
        return this.pos;
    }

    public long length() throws IOException {
        return this.length;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos + n2 > this.length) {
            throw new EOFException();
        }
        System.arraycopy(this.data, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public void seek(long l) throws IOException {
        this.pos = (int)l;
    }

    public void setFileLength(long l) throws IOException {
        this.length = (int)l;
        if (this.length != this.data.length) {
            byte[] byArray = new byte[this.length];
            System.arraycopy(this.data, 0, byArray, 0, Math.min(this.data.length, byArray.length));
            this.data = byArray;
            this.changed = true;
        }
        this.pos = Math.min(this.pos, this.length);
    }

    public void sync() throws IOException {
        if (this.changed) {
            this.db.write(this.fileName, this.data, this.length);
            this.changed = false;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos + n2 > this.data.length) {
            int n3 = Math.max(this.data.length * 2, this.pos + n2);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(this.data, 0, byArray2, 0, this.length);
            this.data = byArray2;
        }
        System.arraycopy(byArray, n, this.data, this.pos, n2);
        this.pos += n2;
        this.length = Math.max(this.length, this.pos);
        this.changed = true;
    }
}

