/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.server;

import com.gwtplatform.dispatch.server.Dispatch;
import com.gwtplatform.dispatch.server.ExecutionContext;
import com.gwtplatform.dispatch.server.actionhandler.ActionHandler;
import com.gwtplatform.dispatch.server.actionhandler.ActionResult;
import com.gwtplatform.dispatch.server.actionhandlervalidator.ActionHandlerValidatorInstance;
import com.gwtplatform.dispatch.server.actionhandlervalidator.ActionHandlerValidatorRegistry;
import com.gwtplatform.dispatch.server.actionvalidator.ActionValidator;
import com.gwtplatform.dispatch.shared.Action;
import com.gwtplatform.dispatch.shared.ActionException;
import com.gwtplatform.dispatch.shared.Result;
import com.gwtplatform.dispatch.shared.ServiceException;
import com.gwtplatform.dispatch.shared.UnsupportedActionException;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public abstract class AbstractDispatchImpl
implements Dispatch {
    private static final String actionValidatorMessage = " couldn't allow access to action : ";
    private final ActionHandlerValidatorRegistry actionHandlerValidatorRegistry;

    protected AbstractDispatchImpl(ActionHandlerValidatorRegistry actionHandlerValidatorRegistry) {
        this.actionHandlerValidatorRegistry = actionHandlerValidatorRegistry;
    }

    @Override
    public <A extends Action<R>, R extends Result> R execute(A action) throws ActionException, ServiceException {
        DefaultExecutionContext ctx = new DefaultExecutionContext(this);
        try {
            return this.doExecute(action, ctx);
        }
        catch (ActionException e) {
            ctx.rollback();
            throw e;
        }
        catch (ServiceException e) {
            ctx.rollback();
            throw e;
        }
    }

    @Override
    public <A extends Action<R>, R extends Result> void undo(A action, R result) throws ActionException, ServiceException {
        DefaultExecutionContext ctx = new DefaultExecutionContext(this);
        try {
            this.doUndo(action, result, ctx);
        }
        catch (ActionException e) {
            ctx.rollback();
            throw e;
        }
        catch (ServiceException e) {
            ctx.rollback();
            throw e;
        }
    }

    private <A extends Action<R>, R extends Result> R doExecute(A action, ExecutionContext ctx) throws ActionException, ServiceException {
        ActionHandler<A, R> handler = this.findHandler(action);
        ActionValidator actionValidator = this.findActionValidator(action);
        try {
            if (actionValidator.isValid(action)) {
                return handler.execute(action, ctx);
            }
            throw new ServiceException(actionValidator.getClass().getName() + actionValidatorMessage + action.getClass().getName());
        }
        catch (ActionException e) {
            throw e;
        }
        catch (Exception e) {
            String newMessage = "Service exception executing action \"" + action.getClass().getSimpleName() + "\", " + "" + e.toString();
            throw new ServiceException(newMessage, (Throwable)e);
        }
    }

    private <A extends Action<R>, R extends Result> void doUndo(A action, R result, ExecutionContext ctx) throws ActionException, ServiceException {
        ActionValidator actionValidator = this.findActionValidator(action);
        ActionHandler<A, R> handler = this.findHandler(action);
        try {
            if (!actionValidator.isValid(action)) {
                throw new ServiceException(actionValidator.getClass().getName() + actionValidatorMessage + action.getClass().getName());
            }
            handler.undo(action, result, ctx);
        }
        catch (ActionException e) {
            throw e;
        }
        catch (Exception cause) {
            throw new ServiceException((Throwable)cause);
        }
    }

    private <A extends Action<R>, R extends Result> ActionValidator findActionValidator(A action) throws UnsupportedActionException {
        ActionHandlerValidatorInstance handlerValidator = this.actionHandlerValidatorRegistry.findActionHandlerValidator(action);
        if (handlerValidator == null) {
            throw new UnsupportedActionException(action);
        }
        return handlerValidator.getActionValidator();
    }

    private <A extends Action<R>, R extends Result> ActionHandler<A, R> findHandler(A action) throws UnsupportedActionException {
        ActionHandlerValidatorInstance handlerValidator = this.actionHandlerValidatorRegistry.findActionHandlerValidator(action);
        if (handlerValidator == null) {
            throw new UnsupportedActionException(action);
        }
        return handlerValidator.getActionHandler();
    }

    private static class DefaultExecutionContext
    implements ExecutionContext {
        private final List<ActionResult<?, ?>> actionResults;
        private final AbstractDispatchImpl dispatch;

        private DefaultExecutionContext(AbstractDispatchImpl dispatch) {
            this.dispatch = dispatch;
            this.actionResults = new ArrayList();
        }

        @Override
        public <A extends Action<R>, R extends Result> R execute(A action) throws ActionException, ServiceException {
            Result result = this.dispatch.doExecute(action, this);
            this.actionResults.add(new ActionResult<A, Result>(action, result, true));
            return (R)result;
        }

        @Override
        public <A extends Action<R>, R extends Result> void undo(A action, R result) throws ActionException, ServiceException {
            this.dispatch.doExecute(action, this);
            this.actionResults.add(new ActionResult<A, R>(action, result, false));
        }

        private void rollback() throws ActionException, ServiceException {
            DefaultExecutionContext ctx = new DefaultExecutionContext(this.dispatch);
            for (int i = this.actionResults.size() - 1; i >= 0; --i) {
                ActionResult<?, ?> actionResult = this.actionResults.get(i);
                this.rollback(actionResult, ctx);
            }
        }

        private <A extends Action<R>, R extends Result> void rollback(ActionResult<A, R> actionResult, ExecutionContext ctx) throws ActionException, ServiceException {
            if (actionResult.isExecuted()) {
                this.dispatch.doUndo(actionResult.getAction(), actionResult.getResult(), ctx);
            } else {
                this.dispatch.doExecute(actionResult.getAction(), ctx);
            }
        }
    }
}

