/*
 * Decompiled with CFR 0.152.
 */
package com.gusya.mv.simpleadid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public final class SimpleAdId {
    private static final String GP_PACKAGE = "com.android.vending";
    private static final String GP_PACKAGE_NOT_FOUND = "package 'com.android.vending' not found";
    private static final String GMS_ACTION = "com.google.android.gms.ads.identifier.service.START";
    private static final String GMS_PACKAGE = "com.google.android.gms";
    private final SimpleAdListener mListener;
    private final Handler mHandler;

    protected SimpleAdId(SimpleAdListener listener, Handler handler) {
        this.mListener = listener;
        this.mHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getGoogleAdIdInfo(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getPackageInfo(GP_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            PackageManager.NameNotFoundException exception = new PackageManager.NameNotFoundException(GP_PACKAGE_NOT_FOUND);
            this.onErrorOnUI((Exception)((Object)exception));
            return;
        }
        Intent intent = new Intent(GMS_ACTION);
        intent.setPackage(GMS_PACKAGE);
        AdIdConnection serviceConnection = new AdIdConnection();
        try {
            if (context.bindService(intent, (ServiceConnection)serviceConnection, 1)) {
                AdIdInterface adIdInterface = new AdIdInterface(serviceConnection.getBinder());
                String adId = adIdInterface.getAdId();
                boolean isAdTrackingEnabled = adIdInterface.isAdIdTrackingEnabled();
                if (TextUtils.isEmpty((CharSequence)adId)) {
                    this.onErrorOnUI(new IllegalStateException("Ad ID is null or empty"));
                } else {
                    this.onSuccessOnUI(new AdIdInfo(adId, isAdTrackingEnabled));
                }
            } else {
                this.onErrorOnUI(new IllegalStateException("Bad GMS service connection"));
            }
        }
        catch (RemoteException | IllegalStateException e) {
            this.onErrorOnUI((Exception)e);
        }
        finally {
            context.unbindService((ServiceConnection)serviceConnection);
        }
    }

    protected void onSuccessOnUI(final AdIdInfo info) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                SimpleAdId.this.mListener.onSuccess(info);
            }
        });
    }

    protected void onErrorOnUI(final Exception exception) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                SimpleAdId.this.mListener.onException(exception);
            }
        });
    }

    public static final void getAdInfo(final Context context, final SimpleAdListener simpleAdListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Handler handler = new Handler(Looper.getMainLooper());
                new SimpleAdId(simpleAdListener, handler).getGoogleAdIdInfo(context);
            }
        }).start();
    }

    private static class AdIdInterface
    implements IInterface {
        private static final String INTERFACE_TOKEN = "com.google.android.gms.ads.identifier.internal.IAdvertisingIdService";
        private static final int AD_ID_TRANSACTION_CODE = 1;
        private static final int AD_TRACKING_TRANSACTION_CODE = 2;
        private final IBinder mIBinder;

        private AdIdInterface(IBinder binder) {
            this.mIBinder = binder;
        }

        public IBinder asBinder() {
            return this.mIBinder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getAdId() throws RemoteException {
            String adId;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken(INTERFACE_TOKEN);
                this.mIBinder.transact(1, data, reply, 0);
                reply.readException();
                adId = reply.readString();
            }
            finally {
                data.recycle();
                reply.recycle();
            }
            return adId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isAdIdTrackingEnabled() throws RemoteException {
            boolean limitedTrackingEnabled;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken(INTERFACE_TOKEN);
                data.writeInt(1);
                this.mIBinder.transact(2, data, reply, 0);
                reply.readException();
                limitedTrackingEnabled = 0 != reply.readInt();
            }
            finally {
                data.recycle();
                reply.recycle();
            }
            return limitedTrackingEnabled;
        }
    }

    private static class AdIdConnection
    implements ServiceConnection {
        private final BlockingQueue<IBinder> queue = new ArrayBlockingQueue<IBinder>(1);

        private AdIdConnection() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) throws IllegalStateException {
            try {
                this.queue.put(iBinder);
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException("Exception trying to parse GMS connection");
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }

        public IBinder getBinder() throws IllegalStateException {
            try {
                return this.queue.take();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Exception trying to retrieve GMS connection");
            }
        }
    }

    public static class AdIdInfo {
        private final String adId;
        private final boolean isAdTrackingEnabled;

        private AdIdInfo(String adId, boolean isAdTrackingEnabled) {
            this.adId = adId;
            this.isAdTrackingEnabled = isAdTrackingEnabled;
        }

        public String getAdId() {
            return this.adId;
        }

        public boolean isAdTrackingEnabled() {
            return this.isAdTrackingEnabled;
        }
    }

    public static interface SimpleAdListener {
        public void onSuccess(AdIdInfo var1);

        public void onException(Exception var1);
    }
}

