/*
 * Decompiled with CFR 0.152.
 */
package com.gustavofao.jsonapi;

import android.util.Log;
import com.gustavofao.jsonapi.Annotations.Excluded;
import com.gustavofao.jsonapi.Annotations.Id;
import com.gustavofao.jsonapi.Annotations.SerialName;
import com.gustavofao.jsonapi.Annotations.Type;
import com.gustavofao.jsonapi.Annotations.Types;
import com.gustavofao.jsonapi.Models.ErrorModel;
import com.gustavofao.jsonapi.Models.ErrorSource;
import com.gustavofao.jsonapi.Models.JSONApiObject;
import com.gustavofao.jsonapi.Models.JSONList;
import com.gustavofao.jsonapi.Models.Links;
import com.gustavofao.jsonapi.Models.Resource;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONApiConverter {
    private static final String DATE_FORMAT_FROM_SERVER = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String DATE_FORMAT_TO_SERVER = "yyyy-MM-dd HH:mm:ssZ";
    private SimpleDateFormat dateFormatFromServer = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    private SimpleDateFormat dateFormatToServer = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ", Locale.US);
    private HashMap<String, Class<? extends Resource>> classesIndex;

    public JSONApiConverter(Class<? extends Resource> ... classes) {
        this.classesIndex = new HashMap();
        List<Class<? extends Resource>> classList = Arrays.asList(classes);
        for (Class<? extends Resource> c : classList) {
            if (c.getAnnotation(Type.class) != null) {
                String type = c.getAnnotation(Type.class).value();
                if (this.classesIndex.containsKey(type)) continue;
                this.classesIndex.put(type, c);
                continue;
            }
            if (c.getAnnotation(Types.class) != null) {
                String[] types;
                for (String type : types = c.getAnnotation(Types.class).value()) {
                    if (this.classesIndex.containsKey(type)) continue;
                    this.classesIndex.put(type, c);
                }
                continue;
            }
            Log.e((String)"Classes", (String)("No Annotation [" + c.getName() + "]"));
        }
    }

    public JSONApiConverter(HashMap<String, Class<? extends Resource>> classesIndex) {
        this.classesIndex = classesIndex;
    }

    public JSONApiConverter withDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormatFromServer = dateFormat;
        this.dateFormatToServer = dateFormat;
        return this;
    }

    public Date parseDate(String date) throws ParseException {
        return this.dateFormatFromServer.parse(date);
    }

    public String toJson(Resource resource) {
        JSONObject json = this.toJsonObject(resource);
        if (json != null) {
            return json.toString();
        }
        return null;
    }

    public String toJson(List<? extends Resource> resources) {
        JSONObject json = this.toJsonArray(resources);
        if (json != null) {
            return json.toString();
        }
        return null;
    }

    public JSONApiObject fromJson(String jsonObject) {
        JSONApiObject jsonApiObject = new JSONApiObject();
        try {
            JSONObject json = new JSONObject(jsonObject);
            HashMap<String, Resource> includes = new HashMap<String, Resource>();
            if (json.isNull("errors")) {
                if (!json.isNull("included")) {
                    String key;
                    JSONObject each;
                    int i;
                    JSONArray included = json.getJSONArray("included");
                    for (i = 0; i < included.length(); ++i) {
                        each = included.getJSONObject(i);
                        key = this.getResourceTag(each);
                        includes.put(key, this.resourceFromJson(each, includes));
                    }
                    for (i = 0; i < included.length(); ++i) {
                        each = included.getJSONObject(i);
                        key = this.getResourceTag(each);
                        includes.remove(key);
                        includes.put(key, this.resourceFromJson(each, includes));
                    }
                }
                if (!json.isNull("data")) {
                    Object data = json.get("data");
                    if (data instanceof JSONObject) {
                        JSONObject objectData = (JSONObject)data;
                        jsonApiObject.addData(this.resourceFromJson(objectData, includes));
                    } else if (data instanceof JSONArray) {
                        JSONArray objectData = (JSONArray)data;
                        for (int i = 0; i < objectData.length(); ++i) {
                            jsonApiObject.addData(this.resourceFromJson(objectData.getJSONObject(i), includes));
                        }
                    }
                }
                if (!json.isNull("links")) {
                    jsonApiObject.setLinks(this.linksFromJson(json.getJSONObject("links")));
                }
                Field hasErrors = jsonApiObject.getClass().getDeclaredField("hasErrors");
                boolean oldAcessible = hasErrors.isAccessible();
                hasErrors.setAccessible(true);
                hasErrors.setBoolean(jsonApiObject, false);
                hasErrors.setAccessible(oldAcessible);
            } else {
                JSONArray errorList = json.getJSONArray("errors");
                ArrayList<ErrorModel> errorModelList = new ArrayList<ErrorModel>();
                for (int i = 0; i < errorList.length(); ++i) {
                    ErrorModel error = new ErrorModel();
                    JSONObject eachRow = errorList.getJSONObject(i);
                    if (!eachRow.isNull("code")) {
                        error.setStatus(eachRow.getString("code"));
                    }
                    if (!eachRow.isNull("detail")) {
                        error.setDetail(eachRow.getString("detail"));
                    }
                    if (!eachRow.isNull("title")) {
                        error.setTitle(eachRow.getString("title"));
                    }
                    if (!eachRow.isNull("source")) {
                        ErrorSource source = new ErrorSource();
                        JSONObject sourceJson = eachRow.getJSONObject("source");
                        if (!sourceJson.isNull("parameter")) {
                            source.setParameter(sourceJson.getString("parameter"));
                        }
                        if (!sourceJson.isNull("pointer")) {
                            source.setPointer(sourceJson.getString("pointer"));
                        }
                        error.setSource(source);
                    }
                    errorModelList.add(error);
                }
                Field hasErrors = jsonApiObject.getClass().getDeclaredField("errors");
                boolean oldAcessible = hasErrors.isAccessible();
                hasErrors.setAccessible(true);
                hasErrors.set(jsonApiObject, errorModelList);
                hasErrors.setAccessible(oldAcessible);
            }
        }
        catch (Exception ex) {
            jsonApiObject = null;
            Log.e((String)JSONApiConverter.class.getSimpleName(), (String)ex.getMessage());
        }
        return jsonApiObject;
    }

    private Resource resourceFromJson(JSONObject jsonObject, HashMap<String, Resource> includes) throws JSONException, IllegalAccessException, InstantiationException, ParseException, NoSuchFieldException {
        String typeString = jsonObject.getString("type");
        Resource resource = this.classesIndex.get(typeString).newInstance();
        Field idMainField = Resource.class.getDeclaredField("id");
        Field typeMainField = Resource.class.getDeclaredField("type");
        Field attrMainField = Resource.class.getDeclaredField("hasAttributes");
        boolean oldIdAccessible = idMainField.isAccessible();
        boolean oldTypeAccessible = typeMainField.isAccessible();
        boolean oldAccessibleAccessible = attrMainField.isAccessible();
        idMainField.setAccessible(true);
        if (!jsonObject.isNull("id")) {
            idMainField.set(resource, jsonObject.getString("id"));
        } else {
            idMainField.set(resource, "");
        }
        idMainField.setAccessible(oldIdAccessible);
        typeMainField.setAccessible(true);
        typeMainField.set(resource, typeString);
        typeMainField.setAccessible(oldTypeAccessible);
        attrMainField.setAccessible(true);
        attrMainField.setBoolean(resource, jsonObject.isNull("attributes"));
        attrMainField.setAccessible(oldAccessibleAccessible);
        List<Field> fields = this.getFields(resource.getClass());
        HashMap<String, Field> fieldsHash = new HashMap<String, Field>();
        for (Field f : fields) {
            if (f.getAnnotation(SerialName.class) != null) {
                fieldsHash.put(f.getAnnotation(SerialName.class).value(), f);
                continue;
            }
            fieldsHash.put(f.getName(), f);
        }
        if (!jsonObject.isNull("attributes")) {
            JSONObject attributes = jsonObject.getJSONObject("attributes");
            Iterator it = attributes.keys();
            while (it.hasNext()) {
                String attr = (String)it.next();
                Object value = attributes.get(attr);
                if (!fieldsHash.containsKey(attr)) continue;
                Field currentField = (Field)fieldsHash.get(attr);
                Boolean oldAccessible = currentField.isAccessible();
                currentField.setAccessible(true);
                try {
                    if (value instanceof String) {
                        if (currentField.getType().equals(Character.TYPE)) {
                            currentField.setChar(resource, String.valueOf(value).charAt(0));
                        } else if (currentField.getType().equals(String.class)) {
                            currentField.set(resource, value);
                        } else if (currentField.getType().equals(Date.class)) {
                            currentField.set(resource, this.parseDate(String.valueOf(value)));
                        } else if (currentField.getType().equals(Double.TYPE) || currentField.getType().equals(Double.class)) {
                            currentField.set(resource, Double.valueOf(String.valueOf(value)));
                        } else if (currentField.getType().equals(Float.TYPE) || currentField.getType().equals(Float.class)) {
                            currentField.set(resource, Float.valueOf(String.valueOf(value)));
                        } else {
                            Log.e((String)"JSONApiConverter", (String)("Type not setted (" + currentField.getType().getName() + ")"));
                        }
                    } else if (value instanceof Double || value instanceof Float) {
                        if (currentField.getType().equals(Float.TYPE) || currentField.getType().equals(Float.class)) {
                            currentField.setDouble(resource, ((Float)value).floatValue());
                        } else if (currentField.getType().equals(Double.TYPE) || currentField.getType().equals(Double.class)) {
                            currentField.setDouble(resource, (Double)value);
                        }
                    } else if (value instanceof Integer) {
                        currentField.setInt(resource, (Integer)value);
                    } else if (value instanceof Long) {
                        currentField.setLong(resource, (Long)value);
                    } else if (value instanceof Character) {
                        currentField.setChar(resource, ((Character)value).charValue());
                    } else if (value instanceof Boolean) {
                        currentField.setBoolean(resource, (Boolean)value);
                    } else if (value instanceof JSONObject) {
                        JSONObject json = (JSONObject)value;
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        Iterator keys = json.keys();
                        while (keys.hasNext()) {
                            String k = (String)keys.next();
                            data.put(k, json.get(k));
                        }
                        currentField.set(resource, data);
                    } else if (value instanceof JSONArray) {
                        JSONArray array = (JSONArray)value;
                        ArrayList<Object> arrayData = new ArrayList<Object>();
                        if (array.length() > 0) {
                            for (int i = 0; i < array.length(); ++i) {
                                arrayData.add(array.get(i));
                            }
                        }
                        currentField.set(resource, arrayData);
                    }
                }
                catch (Exception ex) {
                    Log.e((String)"JSONApiConverter", (String)String.format("Failed to pass attribute %s", attr));
                }
                currentField.setAccessible(oldAccessible);
            }
        }
        if (!jsonObject.isNull("relationships")) {
            JSONObject relationships = jsonObject.getJSONObject("relationships");
            Iterator keys = relationships.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONObject eachRelation = relationships.getJSONObject(key);
                Object data = eachRelation.get("data");
                if (!fieldsHash.containsKey(key)) continue;
                Field field = (Field)fieldsHash.get(key);
                Boolean oldAccessible = field.isAccessible();
                field.setAccessible(true);
                if (data instanceof JSONObject) {
                    JSONObject dataJson = (JSONObject)data;
                    String keyRelation = this.getResourceTag(dataJson);
                    Resource fieldValue = null;
                    if (includes.get(keyRelation) != null) {
                        fieldValue = includes.get(keyRelation);
                    } else if (dataJson.isNull("attributes")) {
                        String id = dataJson.getString("id");
                        String type = dataJson.getString("type");
                        fieldValue = this.classesIndex.get(type).newInstance();
                        Field idField = Resource.class.getDeclaredField("id");
                        boolean oldAcessible = idField.isAccessible();
                        idField.setAccessible(true);
                        idField.set(fieldValue, id);
                        idField.setAccessible(oldAcessible);
                    } else {
                        fieldValue = this.resourceFromJson(dataJson, includes);
                    }
                    if (fieldValue != null) {
                        if (!dataJson.isNull("links")) {
                            fieldValue.getClass().getDeclaredField("links").set(fieldValue, this.linksFromJson(((JSONObject)data).getJSONObject("links")));
                        }
                        field.set(resource, fieldValue);
                    }
                } else if (data instanceof JSONArray) {
                    JSONList relationList = new JSONList();
                    JSONArray dataJson = (JSONArray)data;
                    for (int i = 0; i < dataJson.length(); ++i) {
                        String keyRelation = this.getResourceTag(dataJson.getJSONObject(i));
                        if (includes.get(keyRelation) != null) {
                            relationList.add(includes.get(keyRelation));
                            continue;
                        }
                        if (dataJson.getJSONObject(i).isNull("attributes")) {
                            String id = dataJson.getJSONObject(i).getString("id");
                            String type = dataJson.getJSONObject(i).getString("type");
                            Resource fieldValue = this.classesIndex.get(type).newInstance();
                            fieldValue.getClass().getDeclaredField("id").set(fieldValue, id);
                            relationList.add(fieldValue);
                            continue;
                        }
                        relationList.add(this.resourceFromJson(dataJson.getJSONObject(i), includes));
                    }
                    if (!eachRelation.isNull("links")) {
                        relationList.setLinks(this.linksFromJson(eachRelation.getJSONObject("links")));
                    }
                    field.set(resource, relationList);
                }
                field.setAccessible(oldAccessible);
            }
        }
        return resource;
    }

    private Links linksFromJson(JSONObject linksJson) throws NoSuchFieldException, JSONException, IllegalAccessException {
        Links links = new Links();
        Iterator it = linksJson.keys();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (links.getClass().getDeclaredField(next) == null) continue;
            Field currentField = links.getClass().getDeclaredField(next);
            Boolean oldAccessible = currentField.isAccessible();
            currentField.setAccessible(true);
            currentField.set(links, linksJson.getString(next));
            currentField.setAccessible(oldAccessible);
        }
        return links;
    }

    private JSONObject toJsonArray(List<? extends Resource> resources) {
        JSONObject mainNode = new JSONObject();
        try {
            JSONArray mainContent = new JSONArray();
            JSONArray include = new JSONArray();
            ArrayList<String> includedIds = new ArrayList<String>();
            for (Resource resource : resources) {
                JSONObject obj = this.toJsonObject(resource);
                JSONObject data = obj.getJSONObject("data");
                mainContent.put((Object)data);
                if (obj.isNull("included")) continue;
                JSONArray extras = obj.getJSONArray("included");
                for (int i = 0; i < extras.length(); ++i) {
                    JSONObject eachInclude = extras.getJSONObject(i);
                    String key = this.getResourceTag(eachInclude);
                    if (includedIds.contains(key)) continue;
                    includedIds.add(key);
                    include.put((Object)eachInclude);
                }
            }
            mainNode.put("data", (Object)mainContent);
            if (include.length() > 0) {
                mainNode.put("included", (Object)include);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mainNode;
    }

    private JSONObject toJsonObject(Resource resource) {
        try {
            Resource ninstance = (Resource)resource.getClass().newInstance();
            if (resource.equals(ninstance)) {
                return new JSONObject();
            }
        }
        catch (Exception ninstance) {
            // empty catch block
        }
        List<Field> fields = this.getFields(resource.getClass());
        JSONObject mainNode = new JSONObject();
        try {
            JSONObject content = new JSONObject();
            JSONObject attributes = new JSONObject();
            JSONObject relationship = new JSONObject();
            JSONArray include = new JSONArray();
            content.put("type", (Object)resource.getType());
            for (Field field : fields) {
                String fieldName = null;
                Boolean oldAccessible = field.isAccessible();
                field.setAccessible(true);
                if (field.getAnnotation(Excluded.class) != null || field.get(resource) == null) continue;
                if (field.getAnnotation(SerialName.class) != null) {
                    fieldName = field.getAnnotation(SerialName.class).value();
                }
                if (fieldName == null) {
                    fieldName = field.getName();
                }
                if (Collection.class.isAssignableFrom(field.getType())) {
                    JSONArray array = new JSONArray();
                    List list = (List)field.get(resource);
                    if (list.size() > 0) {
                        for (Object listItem : list) {
                            try {
                                if (listItem instanceof String) {
                                    array.put((Object)String.valueOf(listItem));
                                    continue;
                                }
                                if (listItem instanceof Integer) {
                                    array.put(((Integer)listItem).intValue());
                                    continue;
                                }
                                if (listItem instanceof Double || listItem instanceof Float) {
                                    array.put((Object)Double.valueOf(String.valueOf(listItem)));
                                    continue;
                                }
                                if (listItem instanceof Long) {
                                    array.put((Object)((Long)listItem));
                                    continue;
                                }
                                if (listItem instanceof Character) {
                                    array.put((Object)Character.toString(((Character)listItem).charValue()));
                                    continue;
                                }
                                if (listItem instanceof Boolean) {
                                    array.put(((Boolean)listItem).booleanValue());
                                    continue;
                                }
                                if (listItem instanceof Date) {
                                    array.put((Object)this.dateFormatToServer.format((Date)field.get(resource)).replace(" ", "T"));
                                    continue;
                                }
                                if (listItem instanceof Map) {
                                    JSONObject obj = new JSONObject();
                                    Map data = (Map)field.get(listItem);
                                    for (String key : data.keySet()) {
                                        obj.put(key, data.get(key));
                                    }
                                    array.put((Object)obj);
                                    continue;
                                }
                                if (!(listItem instanceof Resource)) continue;
                                JSONObject relationshipNode = null;
                                JSONArray relationshipNodeData = null;
                                relationshipNode = relationship.isNull(fieldName) ? new JSONObject() : relationship.getJSONObject(fieldName);
                                relationshipNodeData = relationshipNode.isNull("data") ? new JSONArray() : relationshipNode.getJSONArray("data");
                                relationshipNodeData.put((Object)this.getNodeAsRelationship(listItem));
                                relationshipNode.put("data", (Object)relationshipNodeData);
                                relationship.put(fieldName, (Object)relationshipNode);
                                include.put((Object)this.getNodeAsInclude(listItem));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (array.length() > 0) {
                        attributes.put(fieldName, (Object)array);
                    }
                } else {
                    try {
                        if (field.getAnnotation(Id.class) != null) {
                            content.put("id", (Object)String.valueOf(field.get(resource)));
                        } else if (field.get(resource) instanceof String) {
                            attributes.put(fieldName, (Object)String.valueOf(field.get(resource)));
                        } else if (field.get(resource) instanceof Integer) {
                            attributes.put(fieldName, field.getInt(resource));
                        } else if (field.get(resource) instanceof Double || field.get(resource) instanceof Float) {
                            attributes.put(fieldName, (Object)Double.valueOf(String.valueOf(field.get(resource))));
                        } else if (field.get(resource) instanceof Long) {
                            attributes.put(fieldName, field.getLong(resource));
                        } else if (field.get(resource) instanceof Character) {
                            attributes.put(fieldName, (Object)Character.toString(field.getChar(resource)));
                        } else if (field.get(resource) instanceof Boolean) {
                            attributes.put(fieldName, field.getBoolean(resource));
                        } else if (field.get(resource) instanceof Date) {
                            attributes.put(fieldName, (Object)this.dateFormatToServer.format((Date)field.get(resource)).replace(" ", "T"));
                        } else if (field.get(resource) instanceof Map) {
                            JSONObject obj = new JSONObject();
                            Map data = (Map)field.get(resource);
                            for (String key : data.keySet()) {
                                obj.put(key, data.get(key));
                            }
                            attributes.put(fieldName, (Object)obj);
                        } else if (field.get(resource) instanceof Resource) {
                            JSONObject relationshipNode = new JSONObject();
                            relationshipNode.put("data", (Object)this.getNodeAsRelationship(field.get(resource)));
                            relationship.put(fieldName, (Object)relationshipNode);
                            include.put((Object)this.getNodeAsInclude(field.get(resource)));
                        }
                    }
                    catch (Exception ex) {
                        Log.e((String)"JSONApiConverter", (String)String.format("Failed to pass attribute %s", fieldName));
                    }
                }
                field.setAccessible(oldAccessible);
            }
            content.put("attributes", (Object)attributes);
            if (relationship.length() > 0) {
                content.put("relationships", (Object)relationship);
            }
            mainNode.put("data", (Object)content);
            if (include.length() > 0) {
                mainNode.put("included", (Object)include);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mainNode;
    }

    private String getResourceTag(Resource resource) {
        String type = resource.getType();
        return type + "|" + resource.getId();
    }

    private String getResourceTag(JSONObject json) throws JSONException {
        return json.getString("type") + "|" + json.getString("id");
    }

    private JSONObject getNodeAsRelationship(Object resource) throws JSONException, IllegalAccessException {
        List<Field> fields = this.getFields(resource.getClass());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)((Resource)resource).getType());
        for (Field field : fields) {
            Boolean oldAccessible = field.isAccessible();
            field.setAccessible(true);
            if (field.getAnnotation(Id.class) != null) {
                jsonObject.put("id", field.get(resource));
            }
            field.setAccessible(oldAccessible);
        }
        return jsonObject;
    }

    private JSONObject getNodeAsInclude(Object resource) throws JSONException, IllegalAccessException, ParseException {
        List<Field> fields = this.getFields(resource.getClass());
        JSONObject content = new JSONObject();
        JSONObject attributes = new JSONObject();
        JSONObject relationship = new JSONObject();
        content.put("type", (Object)((Resource)resource).getType());
        for (Field field : fields) {
            if (Collection.class.isAssignableFrom(field.getType())) continue;
            String fieldName = null;
            Boolean oldAccessible = field.isAccessible();
            field.setAccessible(true);
            if (field.getAnnotation(Excluded.class) != null) continue;
            if (field.getAnnotation(SerialName.class) != null) {
                fieldName = field.getAnnotation(SerialName.class).value();
            }
            if (fieldName == null) {
                fieldName = field.getName();
            }
            if (field.getAnnotation(Id.class) != null) {
                content.put("id", (Object)String.valueOf(field.get(resource)));
            } else if (field.get(resource) instanceof String) {
                attributes.put(fieldName, (Object)String.valueOf(field.get(resource)));
            } else if (field.get(resource) instanceof Integer) {
                attributes.put(fieldName, field.getInt(resource));
            } else if (field.get(resource) instanceof Double || field.get(resource) instanceof Float) {
                attributes.put(fieldName, Double.parseDouble(String.valueOf(field.get(resource))));
            } else if (field.get(resource) instanceof Long) {
                attributes.put(fieldName, field.getLong(resource));
            } else if (field.get(resource) instanceof Character) {
                attributes.put(fieldName, (Object)Character.toString(field.getChar(resource)));
            } else if (field.get(resource) instanceof Boolean) {
                attributes.put(fieldName, field.getBoolean(resource));
            } else if (field.get(resource) instanceof Date) {
                attributes.put(fieldName, (Object)this.dateFormatToServer.format((Date)field.get(resource)).replace(" ", "T"));
            } else if (field.get(resource) instanceof Resource) {
                JSONObject relationshipNode = new JSONObject();
                relationshipNode.put("data", (Object)this.getNodeAsRelationship(field.get(resource)));
                relationship.put(fieldName, (Object)relationshipNode);
            }
            field.setAccessible(oldAccessible);
        }
        content.put("attributes", (Object)attributes);
        if (relationship.length() > 0) {
            content.put("relationships", (Object)relationship);
        }
        return content;
    }

    private List<Field> getFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null && !type.getSuperclass().getName().equals(Object.class.getName())) {
            fields.addAll(this.getFields(type.getSuperclass()));
        }
        return fields;
    }
}

