/*
 * Decompiled with CFR 0.152.
 */
package com.gushenge.atools.util;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.ColorUtils;
import com.gushenge.atools.dao.AKeys;
import com.gushenge.atools.util.OsUtilsKt;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0005\u001a\n\u0010\n\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\t*\u00020\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\t\u001a\u0012\u0010\u0011\u001a\u00020\u0004*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t\u001a*\u0010\u0014\u001a\u00020\u0004*\u00020\u00122\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t\u001a\u0014\u0010\u0019\u001a\u00020\u0004*\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0001\u001a\u0012\u0010\u001b\u001a\u00020\u0004*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\t\u00a8\u0006\u001d"}, d2={"checkDeviceHasNavigationBar", "", "Landroid/content/Context;", "fullScreen", "", "Landroid/app/Activity;", "getDisplayScreenDensity", "", "getDisplayScreenHeight", "", "getMiSupplementHeight", "getScreenHeight", "getStatusBarHeight", "getVirtualBarHeight", "hideStatusBar", "enable", "isLightColor", "setHeight", "Landroid/view/View;", "heightAsPx", "setMargins", "start", "top", "end", "bottom", "setStatusBar", "isTextColorBlack", "setWidth", "widthAsPx", "kotlin_release"})
public final class ViewUtilKt {
    public static final void setHeight(@NotNull View $this$setHeight, int heightAsPx) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setHeight, (String)"$this$setHeight");
        ViewGroup.LayoutParams pp = $this$setHeight.getLayoutParams();
        pp.height = heightAsPx;
        $this$setHeight.setLayoutParams(pp);
    }

    public static final void setWidth(@NotNull View $this$setWidth, int widthAsPx) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setWidth, (String)"$this$setWidth");
        ViewGroup.LayoutParams pp = $this$setWidth.getLayoutParams();
        pp.width = widthAsPx;
        $this$setWidth.setLayoutParams(pp);
    }

    public static final boolean isLightColor(int $this$isLightColor) {
        return ColorUtils.calculateLuminance((int)$this$isLightColor) >= 0.5;
    }

    public static final int getStatusBarHeight(@NotNull Context $this$getStatusBarHeight) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getStatusBarHeight, (String)"$this$getStatusBarHeight");
        Resources res = $this$getStatusBarHeight.getResources();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        return resourceId > 0 ? res.getDimensionPixelSize(resourceId) : 0;
    }

    public static final void setMargins(@NotNull View $this$setMargins, int start, int top, int end, int bottom) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setMargins, (String)"$this$setMargins");
        if ($this$setMargins.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.LayoutParams layoutParams = $this$setMargins.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)layoutParams;
            p.setMargins(start, top, end, bottom);
            $this$setMargins.setLayoutParams((ViewGroup.LayoutParams)p);
        }
    }

    public static final void setStatusBar(@NotNull Activity $this$setStatusBar, boolean isTextColorBlack) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setStatusBar, (String)"$this$setStatusBar");
        if (Build.VERSION.SDK_INT >= 21) {
            Window window;
            Window window2 = window = $this$setStatusBar.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window2, (String)"window");
            View view = window2.getDecorView();
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView");
            View decorView = view;
            if (isTextColorBlack) {
                decorView.setSystemUiVisibility(9472);
            } else {
                decorView.setSystemUiVisibility(1280);
            }
            window.setStatusBarColor(0);
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
        } else {
            Log.e((String)AKeys.INSTANCE.getTAG(), (String)"\u60a8\u53ef\u80fd\u5728\u4f4e\u4e8eAndroid5.0\u7684\u8bbe\u5907\u4e2d\u4f7f\u7528\u6b64\u65b9\u6cd5\uff0c\u8bf7\u6ce8\u610f");
        }
    }

    public static /* synthetic */ void setStatusBar$default(Activity activity, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        ViewUtilKt.setStatusBar(activity, bl);
    }

    public static final void hideStatusBar(@NotNull Activity $this$hideStatusBar, boolean enable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hideStatusBar, (String)"$this$hideStatusBar");
        Window window = $this$hideStatusBar.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.flags = enable ? (lp.flags |= 0x400) : (lp.flags &= ~1024);
        Window window2 = $this$hideStatusBar.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window2, (String)"window");
        window2.setAttributes(lp);
    }

    @RequiresApi(value=21)
    public static final void fullScreen(@NotNull Activity $this$fullScreen) {
        Window windowManager;
        Intrinsics.checkParameterIsNotNull((Object)$this$fullScreen, (String)"$this$fullScreen");
        Window window = windowManager = $this$fullScreen.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"windowManager");
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.flags |= 0x400;
        windowManager.setAttributes(lp);
        View view = windowManager.getDecorView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"windowManager.decorView");
        View decorView = view;
        int option = 2050;
        decorView.setSystemUiVisibility(option);
        windowManager.setStatusBarColor(0);
    }

    public static final int getScreenHeight(@NotNull Context $this$getScreenHeight) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getScreenHeight, (String)"$this$getScreenHeight");
        Object object = $this$getScreenHeight.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics realMetric = new DisplayMetrics();
        try {
            Class<?> clazz = Class.forName("android.view.Display");
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.view.Display\")");
            Class<?> c = clazz;
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"c.getMethod(\"getRealMetr\u2026splayMetrics::class.java)");
            Method method2 = method;
            method2.invoke((Object)display, realMetric);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return realMetric.heightPixels;
    }

    public static final int getDisplayScreenHeight(@NotNull Activity $this$getDisplayScreenHeight) {
        WindowManager windowManager;
        Intrinsics.checkParameterIsNotNull((Object)$this$getDisplayScreenHeight, (String)"$this$getDisplayScreenHeight");
        WindowManager windowManager2 = windowManager = $this$getDisplayScreenHeight.getWindowManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)windowManager2, (String)"windowManager");
        Display display = windowManager2.getDefaultDisplay();
        DisplayMetrics metric = new DisplayMetrics();
        display.getMetrics(metric);
        return metric.heightPixels;
    }

    public static final float getDisplayScreenDensity(@NotNull Context $this$getDisplayScreenDensity) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getDisplayScreenDensity, (String)"$this$getDisplayScreenDensity");
        Object object = $this$getDisplayScreenDensity.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics metric = new DisplayMetrics();
        display.getMetrics(metric);
        return metric.density;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int getMiSupplementHeight(@NotNull Context $this$getMiSupplementHeight) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getMiSupplementHeight, (String)"$this$getMiSupplementHeight");
        String string = Build.MANUFACTURER;
        if (string == null) return 0;
        String string2 = string;
        switch (string2.hashCode()) {
            case -1675632421: {
                if (!string2.equals("Xiaomi")) return 0;
                String string3 = Build.DEVICE;
                if (string3 == null) return 0;
                String string4 = string3;
                switch (string4.hashCode()) {
                    case -816343937: {
                        int n;
                        if (!string4.equals("violet")) return 0;
                        if (Settings.Global.getInt((ContentResolver)$this$getMiSupplementHeight.getContentResolver(), (String)"force_fsg_nav_bar", (int)0) != 0) {
                            n = (int)((double)ViewUtilKt.getVirtualBarHeight($this$getMiSupplementHeight) * 1.5) + 4;
                            return n;
                        }
                        n = ViewUtilKt.getVirtualBarHeight($this$getMiSupplementHeight) / 2 + 4;
                        return n;
                    }
                }
                return 0;
            }
            default: {
                return 0;
            }
        }
    }

    public static final int getVirtualBarHeight(@NotNull Context $this$getVirtualBarHeight) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getVirtualBarHeight, (String)"$this$getVirtualBarHeight");
        int vh = 0;
        Object object = $this$getVirtualBarHeight.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        try {
            Class<?> clazz = Class.forName("android.view.Display");
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.view.Display\")");
            Class<?> c = clazz;
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"c.getMethod(\"getRealMetr\u2026splayMetrics::class.java)");
            Method method2 = method;
            method2.invoke((Object)display, dm);
            int n = dm.heightPixels;
            Display display2 = windowManager.getDefaultDisplay();
            Intrinsics.checkExpressionValueIsNotNull((Object)display2, (String)"windowManager.defaultDisplay");
            vh = n - display2.getHeight();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vh;
    }

    public static final boolean checkDeviceHasNavigationBar(@NotNull Context $this$checkDeviceHasNavigationBar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$checkDeviceHasNavigationBar, (String)"$this$checkDeviceHasNavigationBar");
        if (OsUtilsKt.isMiui()) {
            return Settings.Global.getInt((ContentResolver)$this$checkDeviceHasNavigationBar.getContentResolver(), (String)"force_fsg_nav_bar", (int)0) == 0;
        }
        boolean hasNavigationBar = false;
        Resources resources = $this$checkDeviceHasNavigationBar.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        Resources rs = resources;
        int id = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id > 0) {
            hasNavigationBar = rs.getBoolean(id);
        }
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.os.SystemProperties\")");
            Class<?> systemPropertiesClass = clazz;
            Method method = systemPropertiesClass.getMethod("get", String.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"systemPropertiesClass.ge\u2026get\", String::class.java)");
            Method m = method;
            Object object = m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String navBarOverride = (String)object;
            if (Intrinsics.areEqual((Object)"1", (Object)navBarOverride)) {
                hasNavigationBar = false;
            } else if (Intrinsics.areEqual((Object)"0", (Object)navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasNavigationBar;
    }
}

