/*
 * Decompiled with CFR 0.152.
 */
package com.gushenge.atools.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.ColorUtils;
import com.gushenge.atools.dao.AKeys;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gushenge/atools/util/AView;", "", "()V", "Companion", "kotlin_release"})
public final class AView {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bJ.\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bJ\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u0011J\u0016\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u000b\u00a8\u0006!"}, d2={"Lcom/gushenge/atools/util/AView$Companion;", "", "()V", "fullScreen", "", "context", "Landroid/app/Activity;", "getDisplayScreenDensity", "", "Landroid/content/Context;", "getDisplayScreenHeight", "", "getScreenHeight", "getStatusBarHeight", "getVirtualBarHeight", "hideStatusBar", "enable", "", "isLightColor", "color", "setHeight", "view", "Landroid/view/View;", "heightAsPx", "setMargins", "start", "top", "end", "bottom", "setStatusBar", "isTextColorBlack", "setWidth", "widthAsPx", "kotlin_release"})
    public static final class Companion {
        public final void setHeight(@NotNull View view, int heightAsPx) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            ViewGroup.LayoutParams pp = view.getLayoutParams();
            pp.height = heightAsPx;
            view.setLayoutParams(pp);
        }

        public final void setWidth(@NotNull View view, int widthAsPx) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            ViewGroup.LayoutParams pp = view.getLayoutParams();
            pp.width = widthAsPx;
            view.setLayoutParams(pp);
        }

        public final boolean isLightColor(@ColorInt int color) {
            return ColorUtils.calculateLuminance((int)color) >= 0.5;
        }

        public final int getStatusBarHeight(@NotNull Activity context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Resources res = context.getResources();
            int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
            return resourceId > 0 ? res.getDimensionPixelSize(resourceId) : 0;
        }

        public final void setMargins(@NotNull View view, int start, int top, int end, int bottom) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                if (layoutParams == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)layoutParams;
                p.setMargins(start, top, end, bottom);
                view.setLayoutParams((ViewGroup.LayoutParams)p);
            }
        }

        public final void setStatusBar(@NotNull Activity context, boolean isTextColorBlack) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (Build.VERSION.SDK_INT >= 21) {
                Window window;
                Window window2 = window = context.getWindow();
                Intrinsics.checkExpressionValueIsNotNull((Object)window2, (String)"window");
                View view = window2.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView");
                View decorView = view;
                if (isTextColorBlack) {
                    decorView.setSystemUiVisibility(9472);
                } else {
                    decorView.setSystemUiVisibility(1280);
                }
                window.setStatusBarColor(0);
                window.addFlags(Integer.MIN_VALUE);
                window.clearFlags(0x4000000);
            } else {
                Log.e((String)AKeys.INSTANCE.getTAG(), (String)"\u60a8\u53ef\u80fd\u5728\u4f4e\u4e8eAndroid5.0\u7684\u8bbe\u5907\u4e2d\u4f7f\u7528\u6b64\u65b9\u6cd5\uff0c\u8bf7\u6ce8\u610f");
            }
        }

        public static /* synthetic */ void setStatusBar$default(Companion companion, Activity activity, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            companion.setStatusBar(activity, bl);
        }

        public final void hideStatusBar(@NotNull Activity context, boolean enable) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Window window = context.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"context.window");
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.flags = enable ? (lp.flags |= 0x400) : (lp.flags &= ~1024);
            Window window2 = context.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window2, (String)"context.window");
            window2.setAttributes(lp);
        }

        @RequiresApi(value=21)
        public final void fullScreen(@NotNull Activity context) {
            Window windowManager;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Window window = windowManager = context.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"windowManager");
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.flags |= 0x400;
            windowManager.setAttributes(lp);
            View view = windowManager.getDecorView();
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"windowManager.decorView");
            View decorView = view;
            int option = 2050;
            decorView.setSystemUiVisibility(option);
            windowManager.setStatusBarColor(0);
        }

        public final int getScreenHeight(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("window");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager windowManager = (WindowManager)object;
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics realMetric = new DisplayMetrics();
            try {
                Class<?> clazz = Class.forName("android.view.Display");
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.view.Display\")");
                Class<?> c = clazz;
                Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"c.getMethod(\"getRealMetr\u2026splayMetrics::class.java)");
                Method method2 = method;
                method2.invoke((Object)display, realMetric);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return realMetric.heightPixels;
        }

        public final int getDisplayScreenHeight(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("window");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager windowManager = (WindowManager)object;
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics metric = new DisplayMetrics();
            display.getMetrics(metric);
            return metric.heightPixels;
        }

        public final float getDisplayScreenDensity(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("window");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager windowManager = (WindowManager)object;
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics metric = new DisplayMetrics();
            display.getMetrics(metric);
            return metric.density;
        }

        public final int getVirtualBarHeight(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return this.getScreenHeight(context) - this.getDisplayScreenHeight(context);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

