/*
 * Decompiled with CFR 0.152.
 */
package com.gushenge.atools.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Build;
import android.util.Log;
import com.gushenge.atools.others.CommandUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gushenge/atools/util/ASystem;", "", "()V", "Companion", "kotlin_release"})
public final class ASystem {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lcom/gushenge/atools/util/ASystem$Companion;", "", "()V", "emulatorCheck", "", "context", "Landroid/content/Context;", "getAppVersionCode", "", "getAppVersionName", "", "kotlin_release"})
    public static final class Companion {
        public final long getAppVersionCode(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            long versionCode = 1L;
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            try {
                long l;
                if (Build.VERSION.SDK_INT >= 28) {
                    PackageInfo packageInfo2 = packageInfo;
                    Intrinsics.checkExpressionValueIsNotNull((Object)packageInfo2, (String)"packageInfo");
                    l = packageInfo2.getLongVersionCode();
                } else {
                    l = packageInfo.versionCode;
                }
                versionCode = l;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            return versionCode;
        }

        @NotNull
        public final String getAppVersionName(@NotNull Context context) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            try {
                String string2 = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.packageManager.g\u2026ckageName, 0).versionName");
                string = string2;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                string = "\u672a\u83b7\u53d6\u5230VersionName";
            }
            return string;
        }

        public final boolean emulatorCheck(@NotNull Context context) {
            String filter;
            String boardPlatform;
            String productBoard;
            String basebandVersion;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            int suspectCount = 0;
            Object object = context.getSystemService("sensor");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.hardware.SensorManager");
            }
            SensorManager sensorManager = (SensorManager)object;
            Sensor sensor = sensorManager.getDefaultSensor(5);
            if (sensor == null) {
                ++suspectCount;
                Log.e((String)"emulatorCheck: ", (String)"\u5149\u4f20\u611f\u5668\u4e0d\u5b58\u5728");
            }
            if ((basebandVersion = new CommandUtil().getProperty("gsm.version.baseband")) == null | Intrinsics.areEqual((Object)"", (Object)basebandVersion)) {
                ++suspectCount;
                Log.e((String)"emulatorCheck: ", (String)"\u57fa\u5e26\u4e0d\u5b58\u5728");
            }
            if ((productBoard = new CommandUtil().getProperty("ro.product.board")) == null | Intrinsics.areEqual((Object)"", (Object)productBoard)) {
                ++suspectCount;
                Log.e((String)"emulatorCheck: ", (String)"\u5904\u7406\u5668\u4e0d\u5b58\u5728");
            }
            if ((boardPlatform = new CommandUtil().getProperty("ro.board.platform")) == null | Intrinsics.areEqual((Object)"", (Object)boardPlatform)) {
                ++suspectCount;
                Log.e((String)"emulatorCheck: ", (String)"\u5904\u7406\u5668\u5e73\u53f0\u4e0d\u5b58\u5728");
            }
            if (!Build.BRAND.equals("HUAWEI")) {
                String buildFlavor = new CommandUtil().getProperty("ro.build.flavor");
                if (buildFlavor == null | Intrinsics.areEqual((Object)"", (Object)buildFlavor) | (buildFlavor != null && StringsKt.contains$default((CharSequence)buildFlavor, (CharSequence)"vbox", (boolean)false, (int)2, null))) {
                    ++suspectCount;
                    Log.e((String)"emulatorCheck: ", (String)"\u6e20\u9053\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                if (productBoard != null && boardPlatform != null && Intrinsics.areEqual((Object)productBoard, (Object)boardPlatform) ^ true) {
                    ++suspectCount;
                    Log.e((String)"emulatorCheck: ", (String)"\u5904\u7406\u5668\u4fe1\u606f\u4e0d\u4e00\u81f4");
                }
            }
            if ((filter = new CommandUtil().exec("cat /proc/self/cgroup")) == null || filter.length() == 0) {
                ++suspectCount;
                Log.e((String)"emulatorCheck: ", (String)"\u8fdb\u7a0b\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            return suspectCount < 2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

