/*
 * Decompiled with CFR 0.152.
 */
package com.gushenge.atools.util.keyboard.test;

import android.content.Context;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import com.gushenge.atools.util.ViewUtilKt;
import com.gushenge.atools.util.keyboard.test.DisplayMetricsHolder;
import com.gushenge.atools.util.keyboard.test.OnKeyboardChangedListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/gushenge/atools/util/keyboard/test/GlobalLayoutListener;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "mView", "Landroid/view/View;", "l", "Lcom/gushenge/atools/util/keyboard/test/OnKeyboardChangedListener;", "(Landroid/view/View;Lcom/gushenge/atools/util/keyboard/test/OnKeyboardChangedListener;)V", "mKeyboardHeight", "", "mListener", "mMinKeyboardHeightDetected", "mVisibleViewArea", "Landroid/graphics/Rect;", "checkForKeyboardEvents", "", "onGlobalLayout", "kotlin_release"})
public class GlobalLayoutListener
implements ViewTreeObserver.OnGlobalLayoutListener {
    private final Rect mVisibleViewArea;
    private final int mMinKeyboardHeightDetected;
    private int mKeyboardHeight;
    private final OnKeyboardChangedListener mListener;
    private final View mView;

    public void onGlobalLayout() {
        if (this.mView == null) {
            return;
        }
        this.checkForKeyboardEvents();
    }

    private final void checkForKeyboardEvents() {
        int heightDiff;
        View view = this.mView;
        if (view == null) {
            Intrinsics.throwNpe();
        }
        view.getRootView().getWindowVisibleDisplayFrame(this.mVisibleViewArea);
        DisplayMetrics displayMetrics = DisplayMetricsHolder.INSTANCE.getWindowDisplayMetrics();
        if (displayMetrics == null) {
            Intrinsics.throwNpe();
        }
        if (this.mKeyboardHeight != (heightDiff = displayMetrics.heightPixels - this.mVisibleViewArea.bottom) && heightDiff > this.mMinKeyboardHeightDetected) {
            this.mKeyboardHeight = heightDiff;
            if (this.mListener != null) {
                this.mListener.onChange(true, this.mKeyboardHeight, this.mVisibleViewArea.width(), this.mVisibleViewArea.bottom);
            }
        } else if (this.mKeyboardHeight != 0 && heightDiff <= this.mMinKeyboardHeightDetected) {
            this.mKeyboardHeight = 0;
            if (this.mListener != null) {
                this.mListener.onChange(false, this.mKeyboardHeight, this.mVisibleViewArea.width(), this.mVisibleViewArea.bottom);
            }
        }
    }

    public GlobalLayoutListener(@Nullable View mView, @Nullable OnKeyboardChangedListener l) {
        View view = this.mView = mView;
        if (view == null) {
            Intrinsics.throwNpe();
        }
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mView!!.context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"mView!!.context.applicationContext");
        DisplayMetricsHolder.INSTANCE.initDisplayMetricsIfNotInitialized(context2);
        this.mVisibleViewArea = new Rect();
        this.mMinKeyboardHeightDetected = (int)ViewUtilKt.toPixelFromDIP(60);
        this.mListener = l;
    }
}

