/*
 * Decompiled with CFR 0.152.
 */
package com.gushenge.atools.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Build;
import android.util.Log;
import com.gushenge.atools.others.CommandUtil;

public class ASystem {
    public static long getAppVersionCode(Context context) {
        long versionCode = 1L;
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            versionCode = Build.VERSION.SDK_INT >= 28 ? packageInfo.getLongVersionCode() : (long)packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"com.gushenge.atools", (String)"\u83b7\u53d6VersionCode\u51fa\u9519");
        }
        return versionCode;
    }

    public static String getAppVersionName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "\u672a\u83b7\u53d6\u5230VersionName";
        }
    }

    public Boolean emulatorCheck(Context context) {
        String filter;
        String boardPlatform;
        String productBoard;
        String basebandVersion;
        int suspectCount = 0;
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(5);
        if (null == sensor) {
            ++suspectCount;
            Log.e((String)"emulatorCheck: ", (String)"\u5149\u4f20\u611f\u5668\u4e0d\u5b58\u5728");
        }
        if ((basebandVersion = CommandUtil.getSingleInstance().getProperty("gsm.version.baseband")) == null | "".equals(basebandVersion)) {
            ++suspectCount;
            Log.e((String)"emulatorCheck: ", (String)"\u57fa\u5e26\u4e0d\u5b58\u5728");
        }
        if ((productBoard = CommandUtil.getSingleInstance().getProperty("ro.product.board")) == null | "".equals(productBoard)) {
            ++suspectCount;
            Log.e((String)"emulatorCheck: ", (String)"\u5904\u7406\u5668\u4e0d\u5b58\u5728");
        }
        if ((boardPlatform = CommandUtil.getSingleInstance().getProperty("ro.board.platform")) == null | "".equals(boardPlatform)) {
            ++suspectCount;
            Log.e((String)"emulatorCheck: ", (String)"\u5904\u7406\u5668\u5e73\u53f0\u4e0d\u5b58\u5728");
        }
        if (!Build.BRAND.equals("HUAWEI")) {
            String buildFlavor = CommandUtil.getSingleInstance().getProperty("ro.build.flavor");
            if (buildFlavor == null | "".equals(buildFlavor) | (buildFlavor != null && buildFlavor.contains("vbox"))) {
                ++suspectCount;
                Log.e((String)"emulatorCheck: ", (String)"\u6e20\u9053\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            if (productBoard != null && boardPlatform != null && !productBoard.equals(boardPlatform)) {
                ++suspectCount;
                Log.e((String)"emulatorCheck: ", (String)"\u5904\u7406\u5668\u4fe1\u606f\u4e0d\u4e00\u81f4");
            }
        }
        if ((filter = CommandUtil.getSingleInstance().exec("cat /proc/self/cgroup")) == null || filter.length() == 0) {
            ++suspectCount;
            Log.e((String)"emulatorCheck: ", (String)"\u8fdb\u7a0b\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return suspectCount < 2;
    }
}

