/*
 * Decompiled with CFR 0.152.
 */
package com.gushenge.atools.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import com.gushenge.atools.R;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RollingTextView
extends AppCompatTextView {
    private static final int MONEY_TYPE = 0;
    private static final int NUM_TYPE = 1;
    private int frameNum;
    private int textType;
    private boolean useCommaFormat;
    private boolean runWhenChange;
    private ExecutorService threadPool = Executors.newFixedThreadPool(1);
    private DecimalFormat formatter = new DecimalFormat("0.00");
    private double nowMoneyNum = 0.0;
    private double finalMoneyNum;
    private int nowNum;
    private int finalNum;
    private String preStr;
    @SuppressLint(value={"HandlerLeak"})
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    String str = RollingTextView.this.formatter.format(RollingTextView.this.nowMoneyNum).toString();
                    if (RollingTextView.this.useCommaFormat) {
                        String formatStr = RollingTextView.addComma(str, true);
                        RollingTextView.this.setText(formatStr);
                    } else {
                        RollingTextView.this.setText(str);
                    }
                    RollingTextView.this.nowMoneyNum = RollingTextView.this.nowMoneyNum + (Double)msg.obj;
                    if (RollingTextView.this.nowMoneyNum < RollingTextView.this.finalMoneyNum) {
                        Message msg2 = RollingTextView.this.handler.obtainMessage();
                        msg2.what = 0;
                        msg2.obj = msg.obj;
                        RollingTextView.this.handler.sendMessage(msg2);
                        break;
                    }
                    if (RollingTextView.this.useCommaFormat) {
                        RollingTextView.this.setText(RollingTextView.addComma(RollingTextView.this.formatter.format(RollingTextView.this.finalMoneyNum), true));
                        break;
                    }
                    RollingTextView.this.setText(RollingTextView.this.formatter.format(RollingTextView.this.finalMoneyNum));
                    break;
                }
                case 1: {
                    if (RollingTextView.this.useCommaFormat) {
                        String formatStr = RollingTextView.addComma(String.valueOf(RollingTextView.this.nowNum), false);
                        RollingTextView.this.setText(formatStr);
                    } else {
                        RollingTextView.this.setText(String.valueOf(RollingTextView.this.nowNum));
                    }
                    RollingTextView.this.nowNum = RollingTextView.this.nowNum + (Integer)msg.obj;
                    if (RollingTextView.this.nowNum < RollingTextView.this.finalNum) {
                        Message msg2 = RollingTextView.this.handler.obtainMessage();
                        msg2.what = 1;
                        msg2.obj = msg.obj;
                        RollingTextView.this.handler.sendMessage(msg2);
                        break;
                    }
                    if (RollingTextView.this.useCommaFormat) {
                        RollingTextView.this.setText(RollingTextView.addComma(String.valueOf(RollingTextView.this.finalNum), false));
                        break;
                    }
                    RollingTextView.this.setText(String.valueOf(RollingTextView.this.finalNum));
                }
            }
        }
    };

    public RollingTextView(Context context) {
        this(context, null);
    }

    public RollingTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public RollingTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RollingTextView);
        this.frameNum = ta.getInt(R.styleable.RollingTextView_frameNum, 30);
        this.textType = ta.getInt(R.styleable.RollingTextView_textType, 0);
        this.useCommaFormat = ta.getBoolean(R.styleable.RollingTextView_useCommaFormat, true);
        this.runWhenChange = ta.getBoolean(R.styleable.RollingTextView_runWhenChange, true);
    }

    public void setFrameNum(int frameNum) {
        this.frameNum = frameNum;
    }

    public void setTextType(int textType) {
        this.textType = textType;
    }

    public void setUseCommaFormat(boolean useCommaFormat) {
        this.useCommaFormat = useCommaFormat;
    }

    public void setRunWhenChange(boolean runWhenChange) {
        this.runWhenChange = runWhenChange;
    }

    public void setContent(String str) {
        if (this.runWhenChange) {
            if (TextUtils.isEmpty((CharSequence)this.preStr)) {
                this.preStr = str;
                this.useAnimByType(str);
                return;
            }
            if (this.preStr.equals(str)) {
                return;
            }
            this.preStr = str;
        }
        this.useAnimByType(str);
    }

    private void useAnimByType(String str) {
        if (this.textType == 0) {
            this.startMoneyAnim(str);
        } else {
            this.startNumAnim(str);
        }
    }

    public void startMoneyAnim(String moneyStr) {
        String money = moneyStr.replace(",", "").replace("-", "");
        try {
            this.finalMoneyNum = Double.parseDouble(money);
            if (this.finalMoneyNum == 0.0) {
                this.setText(moneyStr);
                return;
            }
            this.nowMoneyNum = 0.0;
            this.threadPool.execute(() -> {
                Message msg = this.handler.obtainMessage();
                double size = this.finalMoneyNum / (double)this.frameNum;
                msg.what = 0;
                msg.obj = size < 0.01 ? 0.01 : size;
                this.handler.sendMessage(msg);
            });
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.setText(moneyStr);
        }
    }

    public void startNumAnim(String numStr) {
        String num = numStr.replace(",", "").replace("-", "");
        try {
            this.finalNum = Integer.parseInt(num);
            if (this.finalNum < this.frameNum) {
                this.setText(numStr);
                return;
            }
            this.nowNum = 0;
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    Message msg = RollingTextView.this.handler.obtainMessage();
                    int temp = RollingTextView.this.finalNum / RollingTextView.this.frameNum;
                    msg.what = 1;
                    msg.obj = temp;
                    RollingTextView.this.handler.sendMessage(msg);
                }
            });
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.setText(numStr);
        }
    }

    public static String addComma(String str, boolean isDecimal) {
        if ((str = new StringBuilder(str).reverse().toString()).equals("0")) {
            return str;
        }
        String str2 = "";
        for (int i = 0; i < str.length(); ++i) {
            if (i * 3 + 3 > str.length()) {
                str2 = str2 + str.substring(i * 3, str.length());
                break;
            }
            str2 = str2 + str.substring(i * 3, i * 3 + 3) + ",";
        }
        if (str2.endsWith(",")) {
            str2 = str2.substring(0, str2.length() - 1);
        }
        String temp = new StringBuilder(str2).reverse().toString();
        if (isDecimal) {
            return temp.substring(0, temp.lastIndexOf(",")) + temp.substring(temp.lastIndexOf(",") + 1, temp.length());
        }
        return temp;
    }
}

