/*
 * Decompiled with CFR 0.152.
 */
package com.gushenge.atools.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.widget.TextView;

@SuppressLint(value={"AppCompatCustomView"})
public class ArcButton
extends TextView {
    public static int[] mNormalState = new int[0];
    public static int[] mPressState = new int[]{16842919, 16842910};
    private int mRadius = 1000000000;
    private int mBgNormalColor = -7829368;
    private int mBgPressedColor = -12303292;
    private int mTextNormalColor = -16777216;
    private int mTextPressedColor = -16777216;

    public ArcButton(Context context) {
        super(context);
        this.initUI();
    }

    public ArcButton(Context context, AttributeSet src) {
        super(context, src);
        this.initUI();
    }

    private void initUI() {
        this.setGravity(17);
        this.buildDraweableState();
        this.buildColorDrawableState();
    }

    private void buildColorDrawableState() {
        ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{mPressState, mNormalState}, new int[]{this.mTextPressedColor, this.mTextNormalColor});
        this.setTextColor(colorStateList);
    }

    private void buildDraweableState() {
        float[] outRectr = new float[]{this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius};
        StateListDrawable drawable = new StateListDrawable();
        RoundRectShape rectShape = new RoundRectShape(outRectr, null, null);
        ShapeDrawable pressedDrawable = new ShapeDrawable((Shape)rectShape);
        pressedDrawable.getPaint().setColor(this.mBgPressedColor);
        drawable.addState(mPressState, (Drawable)pressedDrawable);
        ShapeDrawable normalDrawable = new ShapeDrawable((Shape)rectShape);
        normalDrawable.getPaint().setColor(this.mBgNormalColor);
        drawable.addState(mNormalState, (Drawable)normalDrawable);
        this.setBackgroundDrawable((Drawable)drawable);
    }

    public void setRadius(int radius) {
        this.mRadius = radius;
        this.buildDraweableState();
    }

    public void setBackgroundColor(int normalColor, int pressedColor) {
        this.mBgNormalColor = normalColor;
        this.mBgPressedColor = pressedColor;
        this.buildDraweableState();
    }

    public void setTextColor(int normalColor, int pressedColor) {
        this.mTextPressedColor = pressedColor;
        this.mTextNormalColor = normalColor;
        this.buildColorDrawableState();
    }

    public void setBackgroundColor(int color) {
        this.mBgNormalColor = color;
        this.mBgPressedColor = color;
        this.buildDraweableState();
    }

    public void setTextColor(int color) {
        this.mTextPressedColor = color;
        this.mTextNormalColor = color;
        this.buildColorDrawableState();
    }
}

